/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import top.theillusivec4.polymorph.api.client.base.IPolymorphClient;
import top.theillusivec4.polymorph.api.client.base.IRecipesWidget;

public class PolymorphClient
implements IPolymorphClient {
    private static final IPolymorphClient INSTANCE = new PolymorphClient();
    private final List<IPolymorphClient.IRecipesWidgetFactory> widgetFactories = new LinkedList<IPolymorphClient.IRecipesWidgetFactory>();

    public static IPolymorphClient get() {
        return INSTANCE;
    }

    @Override
    public Optional<IRecipesWidget> getWidget(AbstractContainerScreen<?> pContainerScreen) {
        for (IPolymorphClient.IRecipesWidgetFactory factory : this.widgetFactories) {
            IRecipesWidget widget = factory.createWidget(pContainerScreen);
            if (widget == null) continue;
            return Optional.of(widget);
        }
        return Optional.empty();
    }

    @Override
    public void registerWidget(IPolymorphClient.IRecipesWidgetFactory pFactory) {
        this.widgetFactories.add(pFactory);
    }

    @Override
    public Optional<Slot> findCraftingResultSlot(AbstractContainerScreen<?> pContainerScreen) {
        AbstractContainerMenu container = pContainerScreen.m_6262_();
        for (Slot slot : container.f_38839_) {
            if (!(slot.f_40218_ instanceof ResultContainer)) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }
}

