/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.api.common.capability.IBlockEntityRecipeData;
import top.theillusivec4.polymorph.common.capability.AbstractRecipeData;

public abstract class AbstractBlockEntityRecipeData<E extends BlockEntity>
extends AbstractRecipeData<BlockEntity>
implements IBlockEntityRecipeData {
    private NonNullList<ItemStack> lastInput = NonNullList.m_122779_();

    public AbstractBlockEntityRecipeData(E pOwner) {
        super(pOwner);
    }

    protected abstract NonNullList<ItemStack> getInput();

    @Override
    public void tick() {
        boolean changed = false;
        NonNullList<ItemStack> currentInput = this.getInput();
        this.lastInput = this.validateList(this.lastInput, currentInput.size());
        for (int i = 0; i < currentInput.size(); ++i) {
            ItemStack currentStack;
            ItemStack lastStack = (ItemStack)this.lastInput.get(i);
            if (!ItemStack.m_41746_((ItemStack)lastStack, (ItemStack)(currentStack = (ItemStack)currentInput.get(i)))) {
                changed = true;
            }
            this.lastInput.set(i, (Object)currentStack.m_41777_());
        }
        if (changed) {
            this.sendRecipesListToListeners(this.isFailing() || this.isEmpty());
        }
    }

    private NonNullList<ItemStack> validateList(NonNullList<ItemStack> pList, int pSize) {
        if (pList.size() == pSize) {
            return pList;
        }
        NonNullList resized = NonNullList.m_122780_((int)pSize, (Object)ItemStack.f_41583_);
        for (int i = 0; i < Math.min(resized.size(), pList.size()); ++i) {
            resized.set(i, (Object)((ItemStack)pList.get(i)));
        }
        return resized;
    }

    @Override
    public Set<ServerPlayer> getListeners() {
        Level world = this.getOwner().m_58904_();
        HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
        if (world instanceof ServerLevel) {
            for (ServerPlayer player : ((ServerLevel)world).m_8795_(serverPlayer -> true)) {
                PolymorphApi.common().getRecipeDataFromTileEntity(player.f_36096_).ifPresent(recipeData -> {
                    if (recipeData == this) {
                        players.add(player);
                    }
                });
            }
        }
        return players;
    }

    @Override
    public E getOwner() {
        return (E)((BlockEntity)super.getOwner());
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.getInput()) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
        return new Pair(this.getRecipesList(), null);
    }

    @Override
    public boolean isEmpty(Container pInventory) {
        return this.isEmpty();
    }
}

