/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integration.refinedstorage;

import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.blockentity.grid.GridBlockEntity;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.client.base.IPolymorphClient;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.common.crafting.RecipeSelection;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.refinedstorage.GridBlockEntityRecipeData;
import top.theillusivec4.polymorph.common.integration.refinedstorage.GridBlockEntityRecipesWidget;
import top.theillusivec4.polymorph.mixin.integration.refinedstorage.AccessorGrid;

public class RefinedStorageModule
extends AbstractCompatibilityModule {
    @Override
    public void clientSetup() {
        IPolymorphClient clientApi = PolymorphApi.client();
        clientApi.registerWidget(pContainerScreen -> {
            GridContainerMenu container;
            AbstractContainerMenu patt2538$temp = pContainerScreen.m_6262_();
            if (patt2538$temp instanceof GridContainerMenu && (container = (GridContainerMenu)patt2538$temp).getBlockEntity() instanceof GridBlockEntity) {
                return clientApi.findCraftingResultSlot(pContainerScreen).map(slot -> new GridBlockEntityRecipesWidget((AbstractContainerScreen<?>)pContainerScreen, (Slot)slot)).orElse(null);
            }
            return null;
        });
    }

    @Override
    public void setup() {
        IPolymorphCommon commonApi = PolymorphApi.common();
        commonApi.registerTileEntity2RecipeData(pTileEntity -> {
            if (pTileEntity instanceof GridBlockEntity) {
                return new GridBlockEntityRecipeData((GridBlockEntity)pTileEntity);
            }
            return null;
        });
        commonApi.registerContainer2TileEntity(pContainer -> {
            IGrid grid;
            if (pContainer instanceof GridContainerMenu && (grid = ((GridContainerMenu)pContainer).getGrid()) instanceof GridNetworkNode) {
                GridNetworkNode gridNetworkNode = (GridNetworkNode)grid;
                return gridNetworkNode.getLevel().m_7702_(gridNetworkNode.getPos());
            }
            return null;
        });
    }

    @Override
    public boolean selectRecipe(BlockEntity blockEntity, Recipe<?> recipe) {
        IGrid grid;
        if (recipe instanceof CraftingRecipe && blockEntity instanceof GridBlockEntity && (grid = (IGrid)((GridBlockEntity)blockEntity).getNode()) instanceof GridNetworkNode) {
            ((AccessorGrid)grid).setCurrentRecipe((CraftingRecipe)recipe);
            grid.onCraftingMatrixChanged();
            return true;
        }
        return false;
    }

    public static <C extends Container, T extends Recipe<C>> Optional<T> getRecipe(RecipeType<T> type, C inventory, Level world, BlockPos pos, int ticks) {
        BlockEntity te;
        if (pos != null && ticks > 1 && (te = world.m_7702_(pos)) != null) {
            return RecipeSelection.getTileEntityRecipe(type, inventory, world, te);
        }
        return world.m_7465_().m_44015_(type, inventory, world);
    }

    public static void appendPattern(boolean exactPattern, ItemStack stack, Level world, BlockPos pos, int ticks) {
        if (exactPattern) {
            BlockEntity te;
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                stack.m_41751_(new CompoundTag());
            }
            if (world != null && pos != null && ticks > 1 && (te = world.m_7702_(pos)) instanceof GridBlockEntity) {
                Optional<CraftingRecipe> recipe = RecipeSelection.getTileEntityRecipe(RecipeType.f_44107_, ((GridNetworkNode)((GridBlockEntity)te).getNode()).getCraftingMatrix(), world, te);
                recipe.ifPresent(rec -> stack.m_41783_().m_128359_("PolymorphRecipe", rec.m_6423_().toString()));
            }
        }
    }

    public static <T extends Recipe<C>, C extends Container> Optional<T> getPatternRecipe(ItemStack stack, RecipeType<T> type, C inventory, Level world) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            String id = tag.m_128461_("PolymorphRecipe");
            Optional opt = world.m_7465_().m_44043_(new ResourceLocation(id));
            if (opt.isPresent()) {
                return opt;
            }
        }
        return world.m_7465_().m_44015_(type, inventory, world);
    }

    public static <T extends Recipe<C>, C extends Container> Optional<T> getWirelessRecipe(RecipeManager unused, RecipeType<T> type, C inventory, Level world, ICraftingGridListener listener) {
        if (listener instanceof GridContainerMenu) {
            GridContainerMenu container = (GridContainerMenu)listener;
            return RecipeSelection.getPlayerRecipe(type, inventory, world, container.getPlayer());
        }
        return world.m_7465_().m_44015_(type, inventory, world);
    }
}

