/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integration.sophisticatedbackpacks;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeContainer;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.client.base.ITickingRecipesWidget;
import top.theillusivec4.polymorph.api.client.widget.AbstractRecipesWidget;

public class BackpackUpgradeRecipesWidget
extends AbstractRecipesWidget
implements ITickingRecipesWidget {
    private final BackpackContainer backpackContainer;
    private int lastUpgradeId = -1;
    private Slot outputSlot;
    private Mode mode = Mode.NONE;

    public BackpackUpgradeRecipesWidget(BackpackScreen pBackpackScreen, BackpackContainer pBackpackContainer) {
        super((AbstractContainerScreen<?>)pBackpackScreen);
        this.backpackContainer = pBackpackContainer;
        this.outputSlot = this.backpackContainer.m_38853_(0);
        int upgradeId = this.backpackContainer.getOpenContainer().map(UpgradeContainerBase::getUpgradeContainerId).orElse(-1);
        UpgradeContainerBase upgradeContainerBase = (UpgradeContainerBase)this.backpackContainer.getUpgradeContainers().get(upgradeId);
        if (upgradeContainerBase != null) {
            this.mode = upgradeContainerBase instanceof CraftingUpgradeContainer ? Mode.CRAFTING : (upgradeContainerBase instanceof CookingUpgradeContainer ? Mode.SMELTING : (upgradeContainerBase instanceof AutoCookingUpgradeContainer ? Mode.AUTOSMELTING : Mode.NONE));
        }
    }

    @Override
    public void tick() {
        int upgradeId = this.backpackContainer.getOpenContainer().map(UpgradeContainerBase::getUpgradeContainerId).orElse(-1);
        if (this.lastUpgradeId != upgradeId) {
            this.lastUpgradeId = upgradeId;
            if (upgradeId != -1) {
                UpgradeContainerBase upgradeContainerBase = (UpgradeContainerBase)this.backpackContainer.getUpgradeContainers().get(upgradeId);
                if (upgradeContainerBase != null) {
                    if (upgradeContainerBase instanceof CraftingUpgradeContainer) {
                        this.mode = Mode.CRAFTING;
                        this.outputSlot = (Slot)upgradeContainerBase.getSlots().get(9);
                        this.resetWidgetOffsets();
                    } else if (upgradeContainerBase instanceof CookingUpgradeContainer) {
                        this.mode = Mode.SMELTING;
                        this.outputSlot = (Slot)upgradeContainerBase.getSlots().get(2);
                        this.resetWidgetOffsets();
                    } else if (upgradeContainerBase instanceof AutoCookingUpgradeContainer) {
                        this.mode = Mode.AUTOSMELTING;
                        this.outputSlot = (Slot)upgradeContainerBase.getSlots().get(16);
                        this.resetWidgetOffsets();
                    } else {
                        this.mode = Mode.NONE;
                    }
                } else {
                    this.mode = Mode.NONE;
                }
            } else {
                this.mode = Mode.NONE;
            }
        }
    }

    @Override
    public void selectRecipe(ResourceLocation pResourceLocation) {
        PolymorphApi.common().getPacketDistributor().sendStackRecipeSelectionC2S(pResourceLocation);
    }

    @Override
    public Slot getOutputSlot() {
        return this.outputSlot;
    }

    @Override
    public void render(PoseStack pMatrixStack, int pMouseX, int pMouseY, float pRenderPartialTicks) {
        if (this.mode != Mode.NONE) {
            super.render(pMatrixStack, pMouseX, pMouseY, pRenderPartialTicks);
        }
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.mode != Mode.NONE) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        return false;
    }

    @Override
    public int getXPos() {
        int xOffset = this.mode == Mode.CRAFTING ? -21 : 0;
        return this.getOutputSlot().f_40220_ - xOffset;
    }

    @Override
    public int getYPos() {
        int yOffset = 0;
        if (this.mode == Mode.SMELTING) {
            yOffset = -23;
        } else if (this.mode == Mode.AUTOSMELTING) {
            yOffset = -22;
        }
        return this.getOutputSlot().f_40221_ + yOffset;
    }

    static enum Mode {
        CRAFTING,
        SMELTING,
        AUTOSMELTING,
        NONE;

    }
}

