/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integration.sophisticatedbackpacks;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoBlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmokingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.BlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.SmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.SmokingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.api.common.base.IPolymorphPacketDistributor;
import top.theillusivec4.polymorph.common.capability.StackRecipeData;
import top.theillusivec4.polymorph.common.crafting.RecipeSelection;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.sophisticatedbackpacks.BackpackUpgradeRecipesWidget;
import top.theillusivec4.polymorph.common.integration.sophisticatedbackpacks.CookingUpgradeStackRecipeData;
import top.theillusivec4.polymorph.common.util.PolymorphUtils;
import top.theillusivec4.polymorph.mixin.integration.sophisticatedbackpacks.AccessorCookingLogic;
import top.theillusivec4.polymorph.mixin.integration.sophisticatedbackpacks.AccessorCookingLogicContainer;
import top.theillusivec4.polymorph.mixin.integration.sophisticatedbackpacks.AccessorCraftingUpgradeContainer;
import top.theillusivec4.polymorph.mixin.integration.sophisticatedbackpacks.AccessorRecipeHelper;

public class SophisticatedBackpacksModule
extends AbstractCompatibilityModule {
    @Override
    public void setup() {
        PolymorphApi.common().registerItemStack2RecipeData(pStack -> {
            Item item = pStack.m_41720_();
            if (item instanceof CraftingUpgradeItem) {
                return new StackRecipeData(pStack);
            }
            if (item instanceof SmeltingUpgradeItem || item instanceof AutoSmeltingUpgradeItem || item instanceof BlastingUpgradeItem || item instanceof AutoBlastingUpgradeItem || item instanceof SmokingUpgradeItem || item instanceof AutoSmokingUpgradeItem) {
                return new CookingUpgradeStackRecipeData(pStack);
            }
            return null;
        });
        PolymorphApi.common().registerContainer2ItemStack(pContainer -> {
            if (pContainer instanceof BackpackContainer) {
                return ((BackpackContainer)pContainer).getOpenContainer().map(UpgradeContainerBase::getUpgradeStack).orElse(ItemStack.f_41583_);
            }
            return ItemStack.f_41583_;
        });
    }

    @Override
    public void clientSetup() {
        PolymorphApi.client().registerWidget(pContainerScreen -> {
            if (pContainerScreen instanceof BackpackScreen && pContainerScreen.m_6262_() instanceof BackpackContainer) {
                return new BackpackUpgradeRecipesWidget((BackpackScreen)pContainerScreen, (BackpackContainer)pContainerScreen.m_6262_());
            }
            return null;
        });
    }

    @Override
    public boolean selectRecipe(AbstractContainerMenu container, Recipe<?> recipe) {
        if (container instanceof BackpackContainer) {
            return ((BackpackContainer)container).getOpenContainer().map(upgradeContainerBase -> {
                if (upgradeContainerBase instanceof CraftingUpgradeContainer) {
                    if (recipe instanceof CraftingRecipe) {
                        AccessorCraftingUpgradeContainer craftingUpgradeContainer = (AccessorCraftingUpgradeContainer)upgradeContainerBase;
                        craftingUpgradeContainer.setLastRecipe((CraftingRecipe)recipe);
                        craftingUpgradeContainer.callOnCraftMatrixChanged(null);
                        ((BackpackContainer)container).sendSlotUpdates();
                        return true;
                    }
                } else {
                    if (upgradeContainerBase instanceof CookingUpgradeContainer) {
                        CookingLogicContainer smeltingLogicContainer = ((CookingUpgradeContainer)upgradeContainerBase).getSmeltingLogicContainer();
                        CookingLogic<?> logic = ((AccessorCookingLogicContainer)smeltingLogicContainer).getSupplyCoookingLogic().get();
                        ((AccessorCookingLogic)logic).setCookingRecipeInitialized(false);
                        return true;
                    }
                    if (upgradeContainerBase instanceof AutoCookingUpgradeContainer) {
                        CookingLogicContainer smeltingLogicContainer = ((AutoCookingUpgradeContainer)upgradeContainerBase).getCookingLogicContainer();
                        CookingLogic<?> logic = ((AccessorCookingLogicContainer)smeltingLogicContainer).getSupplyCoookingLogic().get();
                        ((AccessorCookingLogic)logic).setCookingRecipeInitialized(false);
                    }
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public boolean openContainer(AbstractContainerMenu container, ServerPlayer serverPlayerEntity) {
        if (container instanceof BackpackContainer) {
            IPolymorphCommon commonApi = PolymorphApi.common();
            commonApi.getRecipeDataFromItemStack(container).ifPresent(recipeData -> ((BackpackContainer)container).getOpenContainer().ifPresent(upgradeContainerBase -> {
                if (upgradeContainerBase instanceof CraftingUpgradeContainer) {
                    Container inv = ((CraftingUpgradeContainer)upgradeContainerBase).getCraftMatrix();
                    if (inv.m_7983_()) {
                        commonApi.getPacketDistributor().sendRecipesListS2C(serverPlayerEntity);
                    } else {
                        commonApi.getPacketDistributor().sendRecipesListS2C(serverPlayerEntity, recipeData.getRecipesList());
                    }
                } else if (upgradeContainerBase instanceof CookingUpgradeContainer) {
                    boolean hasInput = ((Slot)((CookingUpgradeContainer)upgradeContainerBase).getSmeltingLogicContainer().getCookingSlots().get(0)).m_6657_();
                    if (hasInput) {
                        ResourceLocation rl = recipeData.getSelectedRecipe().map(Recipe::m_6423_).orElse(null);
                        commonApi.getPacketDistributor().sendRecipesListS2C(serverPlayerEntity, recipeData.getRecipesList(), rl);
                    } else {
                        commonApi.getPacketDistributor().sendRecipesListS2C(serverPlayerEntity);
                    }
                } else if (upgradeContainerBase instanceof AutoCookingUpgradeContainer) {
                    boolean hasInput = ((Slot)((AutoCookingUpgradeContainer)upgradeContainerBase).getCookingLogicContainer().getCookingSlots().get(0)).m_6657_();
                    if (hasInput) {
                        ResourceLocation rl = recipeData.getSelectedRecipe().map(Recipe::m_6423_).orElse(null);
                        commonApi.getPacketDistributor().sendRecipesListS2C(serverPlayerEntity, recipeData.getRecipesList(), rl);
                    } else {
                        commonApi.getPacketDistributor().sendRecipesListS2C(serverPlayerEntity);
                    }
                }
            }));
            return true;
        }
        return false;
    }

    public static void updateCraftingResult(Level pWorld, CraftingRecipe pLastRecipe, CraftingContainer pCraftingInventory, Player pPlayer, ItemStack pUpgradeStack) {
        if (!pWorld.m_5776_() && pPlayer instanceof ServerPlayer) {
            IPolymorphCommon commonApi = PolymorphApi.common();
            commonApi.getRecipeData(pUpgradeStack).ifPresent(recipeData -> {
                if (pLastRecipe != null && pLastRecipe.m_5818_((Container)pCraftingInventory, pWorld)) {
                    recipeData.setFailing(false);
                    commonApi.getPacketDistributor().sendRecipesListS2C((ServerPlayer)pPlayer, recipeData.getRecipesList());
                }
            });
        }
    }

    public static Optional<? extends AbstractCookingRecipe> getCookingRecipe(ItemStack pInput, RecipeType<? extends AbstractCookingRecipe> pRecipeType, ItemStack pUpgrade) {
        Level world;
        WeakReference<Level> weakReference = AccessorRecipeHelper.getWorld();
        if (weakReference != null && (world = (Level)weakReference.get()) != null) {
            return RecipeSelection.getStackRecipe(pRecipeType, PolymorphUtils.wrapItems(pInput), world, pUpgrade);
        }
        return RecipeHelper.getCookingRecipe((ItemStack)pInput, pRecipeType);
    }

    public static void onOpenTab(int pId, Player pPlayer, Map<Integer, UpgradeContainerBase<?, ?>> pUpgradeContainers) {
        if (!pPlayer.f_19853_.m_5776_() && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)pPlayer;
            UpgradeContainerBase<?, ?> upgrade = pUpgradeContainers.get(pId);
            IPolymorphCommon commonApi = PolymorphApi.common();
            IPolymorphPacketDistributor packetDistributor = commonApi.getPacketDistributor();
            Container inventory = null;
            boolean sendSelected = false;
            if (upgrade != null) {
                if (upgrade instanceof CraftingUpgradeContainer) {
                    inventory = ((CraftingUpgradeContainer)upgrade).getCraftMatrix();
                } else if (upgrade instanceof CookingUpgradeContainer) {
                    sendSelected = true;
                    inventory = PolymorphUtils.wrapItems(((Slot)upgrade.getSlots().get(0)).m_7993_());
                } else if (upgrade instanceof AutoCookingUpgradeContainer) {
                    sendSelected = true;
                    inventory = PolymorphUtils.wrapItems(((Slot)upgrade.getSlots().get(14)).m_7993_());
                }
                Container finalInventory = inventory;
                boolean finalSendSelected = sendSelected;
                commonApi.getRecipeData(upgrade.getUpgradeStack()).ifPresent(recipeData -> {
                    if (!recipeData.isEmpty(finalInventory) && !recipeData.isFailing()) {
                        ResourceLocation selected = finalSendSelected ? (ResourceLocation)recipeData.getSelectedRecipe().map(Recipe::m_6423_).orElse(null) : null;
                        packetDistributor.sendRecipesListS2C(serverPlayerEntity, recipeData.getRecipesList(), selected);
                    } else {
                        packetDistributor.sendRecipesListS2C(serverPlayerEntity);
                    }
                });
            }
        }
    }
}

