/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.compat.tconstruct.modifier;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class SoulSiphonerModifier
extends Modifier {
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        block3: {
            LivingEntity target = context.getLivingTarget();
            LivingEntity attacker = context.getAttacker();
            if (target == null || target.m_6084_() || !(attacker instanceof Player)) break block3;
            Player player = (Player)attacker;
            MobSoulType type = MysticalAgricultureAPI.getMobSoulTypeRegistry().getMobSoulTypeByEntity(target);
            if (type == null || !type.isEnabled()) {
                return super.afterEntityHit(tool, level, context, damageDealt);
            }
            List<ItemStack> jars = SoulSiphonerModifier.getValidSoulJars(player, type);
            if (!jars.isEmpty()) {
                ItemStack jar;
                double remaining = 0.25 * (double)level;
                Iterator<ItemStack> iterator = jars.iterator();
                while (iterator.hasNext() && !((remaining = MobSoulUtils.addSoulsToJar((ItemStack)(jar = iterator.next()), (MobSoulType)type, (double)remaining)) <= 0.0)) {
                }
            }
        }
        return super.afterEntityHit(tool, level, context, damageDealt);
    }

    private static List<ItemStack> getValidSoulJars(Player player, MobSoulType type) {
        return player.m_150109_().f_35974_.stream().filter(s -> {
            ResourceLocation id = s.m_41720_().getRegistryName();
            return id != null && "mysticalagriculture:soul_jar".equals(id.toString());
        }).filter(s -> MobSoulUtils.canAddTypeToJar((ItemStack)s, (MobSoulType)type)).sorted((a, b) -> MobSoulUtils.getType((ItemStack)a) != null ? -1 : (MobSoulUtils.getType((ItemStack)b) != null ? 0 : 1)).collect(Collectors.toList());
    }
}

