/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.builder;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.allthemods.alltheores.datagen.RecipeException;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class ShapedIngotBuilder {
    private final String criteriaName;
    private final InventoryChangeTrigger.TriggerInstance criterion;
    private final EnumMap<Slot, Item> pieces = new EnumMap(Slot.class);
    private final Tag<Item> nugget;

    public ShapedIngotBuilder(Tag<Item> nugget) {
        this.nugget = nugget;
        ResourceLocation tagLocation = Objects.requireNonNull(ItemTags.m_13193_().m_7473_(nugget));
        this.criteriaName = String.format("has_%s_nugget", tagLocation.m_135815_().replace("nugget/", ""));
        ItemPredicate predicate = ItemPredicate.Builder.m_45068_().m_45069_(nugget).m_45077_();
        this.criterion = InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{predicate});
    }

    public static ShapedIngotBuilder builder(Tag<Item> nugget) {
        return new ShapedIngotBuilder(nugget);
    }

    public ShapedIngotBuilder setIngot(RegistryObject<Item> object) {
        this.pieces.put(Slot.INGOT, (Item)object.get());
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pieces.isEmpty()) {
            throw new RecipeException(id.toString(), "recipe must have at least 1 output");
        }
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        Consumer<ShapedRecipeBuilder> register = builder -> builder.m_176498_(consumer);
        Optional.ofNullable(this.pieces.get((Object)Slot.INGOT)).map(this::ingot).map(this::addCriterionNugget).ifPresent(register);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)provider).m_142409_("alltheores");
    }

    private ShapedRecipeBuilder addCriterionNugget(ShapedRecipeBuilder builder) {
        return builder.m_126121_(Character.valueOf('a'), this.nugget).m_142284_(this.criteriaName, (CriterionTriggerInstance)this.criterion);
    }

    private ShapedRecipeBuilder ingot(ItemLike provider) {
        return this.shaped(provider).m_126130_("aaa").m_126130_("aaa").m_126130_("aaa");
    }

    public static enum Slot {
        INGOT;


        public String lower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

