/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.allthemods.alltheores.blocks.AOreBlock;
import net.allthemods.alltheores.blocks.BOreBlock;
import net.allthemods.alltheores.blocks.BlockList;
import net.allthemods.alltheores.blocks.OtherOreBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.registries.RegistryObject;

public class LootTables
extends LootTableProvider {
    public LootTables(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((name, table) -> net.minecraft.world.level.storage.loot.LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
    }

    public static class Blocks
    extends BlockLoot {
        public void addTables() {
            this.getKnownBlocks().forEach(this::dropRaw);
        }

        private void dropRaw(Block block) {
            if (block instanceof AOreBlock || block instanceof BOreBlock || block instanceof OtherOreBlock) {
                String oretype = block.getRegistryName().m_135815_().toString();
                if (oretype.contains("aluminum")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)((Item)BlockList.ALUMINUM_RAW.get())));
                }
                if (oretype.contains("lead")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)((Item)BlockList.LEAD_RAW.get())));
                }
                if (oretype.contains("nickel")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)((Item)BlockList.NICKEL_RAW.get())));
                }
                if (oretype.contains("osmium")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)((Item)BlockList.OSMIUM_RAW.get())));
                }
                if (oretype.contains("platinum")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)((Item)BlockList.PLATINUM_RAW.get())));
                }
                if (oretype.contains("silver")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)((Item)BlockList.SILVER_RAW.get())));
                }
                if (oretype.contains("tin_")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)((Item)BlockList.TIN_RAW.get())));
                }
                if (oretype.contains("uranium")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)((Item)BlockList.URANIUM_RAW.get())));
                }
                if (oretype.contains("zinc")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)((Item)BlockList.ZINC_RAW.get())));
                }
                if (oretype.contains("coal")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)Items.f_42413_));
                }
                if (oretype.contains("copper")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)Items.f_151051_));
                }
                if (oretype.contains("diamond")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)Items.f_42415_));
                }
                if (oretype.contains("emerald")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)Items.f_42616_));
                }
                if (oretype.contains("gold")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)Items.f_151053_));
                }
                if (oretype.contains("iron")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)Items.f_151050_));
                }
                if (oretype.contains("lapis")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)Items.f_42534_));
                }
                if (oretype.contains("quartz")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)Items.f_42692_));
                }
                if (oretype.contains("redstone")) {
                    this.m_124175_(block, block1 -> Blocks.m_124139_((Block)block1, (Item)Items.f_42451_));
                }
            } else {
                this.m_124288_(block);
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return BlockList.BLOCKS.getEntries().stream().map(RegistryObject::get).filter(block -> !(block instanceof LiquidBlock)).collect(Collectors.toList());
        }
    }
}

