/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.worldgen.features;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.Random;
import net.allthemods.alltheores.infos.Configuration;
import net.allthemods.alltheores.infos.Reference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class OreVein
extends Feature<NoneFeatureConfiguration> {
    private Block oreType;
    private Block deepSlate_oreType;
    private Block rawOre;
    private Direction[] directions = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public OreVein(Codec<NoneFeatureConfiguration> p_i231953_1_, Block oretype, Block deepSlate_oretype, Block rawOre) {
        super(p_i231953_1_);
        this.oreType = oretype;
        this.deepSlate_oreType = deepSlate_oretype;
        this.rawOre = rawOre;
    }

    public Codec<ConfiguredFeature<NoneFeatureConfiguration, Feature<NoneFeatureConfiguration>>> m_65787_() {
        return super.m_65787_();
    }

    public ConfiguredFeature<NoneFeatureConfiguration, ?> configured(NoneFeatureConfiguration p_225566_1_) {
        return super.m_65815_((FeatureConfiguration)p_225566_1_);
    }

    public boolean m_142674_(FeaturePlaceContext config) {
        BlockPos pos = config.m_159777_();
        Random rand = config.m_159776_();
        WorldGenLevel world = config.m_159774_();
        int minY = -64;
        int maxY = -63;
        int veinSize = 0;
        int direction = rand.nextInt(5);
        switch (Objects.requireNonNull(this.oreType.getRegistryName()).toString()) {
            case "alltheores:aluminum_ore": {
                minY = (Integer)Configuration.COMMON.aluminum_MinY.get();
                maxY = (Integer)Configuration.COMMON.aluminum_MaxY.get();
                veinSize = (Integer)Configuration.COMMON.aluminum_SpawnSize.get();
            }
            case "alltheores:lead_ore": {
                minY = (Integer)Configuration.COMMON.lead_MinY.get();
                maxY = (Integer)Configuration.COMMON.lead_MaxY.get();
                veinSize = (Integer)Configuration.COMMON.lead_SpawnSize.get();
            }
            case "alltheores:nickel_ore": {
                minY = (Integer)Configuration.COMMON.nickel_MinY.get();
                maxY = (Integer)Configuration.COMMON.nickel_MaxY.get();
                veinSize = (Integer)Configuration.COMMON.nickel_SpawnSize.get();
            }
            case "alltheores:osmium_ore": {
                minY = (Integer)Configuration.COMMON.osmium_MinY.get();
                maxY = (Integer)Configuration.COMMON.osmium_MaxY.get();
                veinSize = (Integer)Configuration.COMMON.osmium_SpawnSize.get();
            }
            case "alltheores:platinum_ore": {
                minY = (Integer)Configuration.COMMON.platinum_MinY.get();
                maxY = (Integer)Configuration.COMMON.platinum_MaxY.get();
                veinSize = (Integer)Configuration.COMMON.platinum_SpawnSize.get();
            }
            case "alltheores:silver_ore": {
                minY = (Integer)Configuration.COMMON.silver_MinY.get();
                maxY = (Integer)Configuration.COMMON.silver_MaxY.get();
                veinSize = (Integer)Configuration.COMMON.silver_SpawnSize.get();
            }
            case "alltheores:tin_ore": {
                minY = (Integer)Configuration.COMMON.tin_MinY.get();
                maxY = (Integer)Configuration.COMMON.tin_MaxY.get();
                veinSize = (Integer)Configuration.COMMON.tin_SpawnSize.get();
            }
            case "alltheores:uranium_ore": {
                minY = (Integer)Configuration.COMMON.uranium_MinY.get();
                maxY = (Integer)Configuration.COMMON.uranium_MaxY.get();
                veinSize = (Integer)Configuration.COMMON.uranium_SpawnSize.get();
            }
            case "alltheores:zinc_ore": {
                minY = (Integer)Configuration.COMMON.zinc_MinY.get();
                maxY = (Integer)Configuration.COMMON.zinc_MaxY.get();
                veinSize = (Integer)Configuration.COMMON.zinc_SpawnSize.get();
            }
        }
        boolean negX = rand.nextBoolean();
        boolean negZ = rand.nextBoolean();
        int offsetX = rand.nextInt(12) + 4;
        int offsetZ = rand.nextInt(12) + 4;
        if (negX) {
            offsetX *= -1;
        }
        if (negZ) {
            offsetZ *= -1;
        }
        int lowY = minY + rand.nextInt((maxY - minY) / 16);
        int midY = minY + rand.nextInt((maxY - minY) / 2);
        int topY = maxY - rand.nextInt((maxY - minY) / 4);
        int processed = 0;
        BlockPos posLow = new BlockPos(pos.m_123341_() + offsetX, lowY, pos.m_123343_() + offsetZ);
        BlockPos posMid = new BlockPos(pos.m_123341_() + offsetX, midY, pos.m_123343_() + offsetZ);
        BlockPos posTop = new BlockPos(pos.m_123341_() + offsetX, topY, pos.m_123343_() + offsetZ);
        processed += this.process(world, posLow, veinSize, direction, rand);
        processed += this.process(world, posMid, veinSize, direction, rand);
        return (processed += this.process(world, posTop, veinSize, direction, rand)) > 0;
    }

    private int process(WorldGenLevel world, BlockPos pos, int veinSize, int direction, Random rand) {
        BlockState state = world.m_8055_(pos);
        int processed = 0;
        if (veinSize <= 0 || Reference.WORLDGEN_BLACKLIST.contains(state.m_60734_())) {
            return 0;
        }
        int step = (veinSize - 1) / 3;
        world.m_7731_(pos, pos.m_123342_() > 0 ? this.oreType.m_49966_() : this.deepSlate_oreType.m_49966_(), 2);
        ++processed;
        int new_direction = 0;
        for (int i = 0; i <= step && processed != veinSize; ++i) {
            processed += this.allBlocks(this, world, pos);
            switch (direction) {
                case 0: {
                    for (int up = 1; up <= 3 && !Reference.WORLDGEN_BLACKLIST.contains((state = world.m_8055_(pos.m_7494_())).m_60734_()); ++up) {
                        world.m_6933_(pos.m_7494_(), pos.m_7494_().m_123342_() > 16 ? this.oreType.m_49966_() : this.deepSlate_oreType.m_49966_(), 2, 512);
                        if (++processed == veinSize) break;
                        pos = pos.m_7494_();
                    }
                    if ((new_direction = rand.nextInt(5)) == direction) {
                        direction += 2;
                        break;
                    }
                    direction = new_direction;
                }
                case 1: {
                    for (int down = 1; down <= 3 && !Reference.WORLDGEN_BLACKLIST.contains((state = world.m_8055_(pos.m_7495_())).m_60734_()); ++down) {
                        world.m_6933_(pos.m_7495_(), pos.m_7495_().m_123342_() > 16 ? this.oreType.m_49966_() : this.deepSlate_oreType.m_49966_(), 2, 512);
                        if (++processed == veinSize) break;
                        pos = pos.m_7495_();
                    }
                    if ((new_direction = rand.nextInt(5)) == direction) {
                        direction += 2;
                        break;
                    }
                    direction = new_direction;
                }
                case 2: {
                    for (int north = 1; north <= 3 && !Reference.WORLDGEN_BLACKLIST.contains((state = world.m_8055_(pos.m_142127_())).m_60734_()); ++north) {
                        world.m_6933_(pos.m_142127_(), pos.m_142127_().m_123342_() > 16 ? this.oreType.m_49966_() : this.deepSlate_oreType.m_49966_(), 2, 512);
                        if (++processed == veinSize) break;
                        pos = pos.m_142127_();
                    }
                    if ((new_direction = rand.nextInt(5)) == direction) {
                        ++direction;
                        break;
                    }
                    direction = new_direction;
                }
                case 3: {
                    for (int east = 1; east <= 3 && !Reference.WORLDGEN_BLACKLIST.contains((state = world.m_8055_(pos.m_142126_())).m_60734_()); ++east) {
                        world.m_6933_(pos.m_142126_(), pos.m_142126_().m_123342_() > 16 ? this.oreType.m_49966_() : this.deepSlate_oreType.m_49966_(), 2, 512);
                        if (++processed == veinSize) break;
                        pos = pos.m_142126_();
                    }
                    if ((new_direction = rand.nextInt(5)) == direction) {
                        ++direction;
                        break;
                    }
                    direction = new_direction;
                }
                case 4: {
                    for (int south = 1; south <= 3 && !Reference.WORLDGEN_BLACKLIST.contains((state = world.m_8055_(pos.m_142128_())).m_60734_()); ++south) {
                        world.m_6933_(pos.m_142128_(), pos.m_142128_().m_123342_() > 16 ? this.oreType.m_49966_() : this.deepSlate_oreType.m_49966_(), 2, 512);
                        if (++processed == veinSize) break;
                        pos = pos.m_142128_();
                    }
                    if ((new_direction = rand.nextInt(5)) == direction) {
                        ++direction;
                        break;
                    }
                    direction = new_direction;
                }
                case 5: {
                    for (int west = 1; west <= 3 && !Reference.WORLDGEN_BLACKLIST.contains((state = world.m_8055_(pos.m_142125_())).m_60734_()); ++west) {
                        world.m_6933_(pos.m_142125_(), pos.m_142125_().m_123342_() > 16 ? this.oreType.m_49966_() : this.deepSlate_oreType.m_49966_(), 2, 512);
                        if (++processed == veinSize) break;
                        pos = pos.m_142125_();
                    }
                    if ((new_direction = rand.nextInt(5)) == direction) {
                        direction -= 3;
                        break;
                    }
                    direction = new_direction;
                }
            }
            float raw = rand.nextFloat();
            if (!(raw < 0.02f) || pos.m_123342_() >= 16) continue;
            world.m_6933_(pos, this.rawOre.m_49966_(), 2, 512);
        }
        return processed;
    }

    private int allBlocks(OreVein oreVein, WorldGenLevel world, BlockPos pos) {
        int x = 0;
        BlockState state = world.m_8055_(pos.m_7495_());
        if (Reference.WORLDGEN_BLACKLIST.contains(state.m_60734_())) {
            return x;
        }
        world.m_6933_(pos.m_7495_(), pos.m_7495_().m_123342_() > 16 ? oreVein.oreType.m_49966_() : oreVein.deepSlate_oreType.m_49966_(), 2, 512);
        ++x;
        state = world.m_8055_(pos.m_7494_());
        if (Reference.WORLDGEN_BLACKLIST.contains(state.m_60734_())) {
            return x;
        }
        world.m_6933_(pos.m_7494_(), pos.m_7494_().m_123342_() > 16 ? oreVein.oreType.m_49966_() : oreVein.deepSlate_oreType.m_49966_(), 2, 512);
        ++x;
        state = world.m_8055_(pos.m_142126_());
        if (Reference.WORLDGEN_BLACKLIST.contains(state.m_60734_())) {
            return x;
        }
        world.m_6933_(pos.m_142126_(), pos.m_142126_().m_123342_() > 16 ? oreVein.oreType.m_49966_() : oreVein.deepSlate_oreType.m_49966_(), 2, 512);
        ++x;
        state = world.m_8055_(pos.m_142125_());
        if (Reference.WORLDGEN_BLACKLIST.contains(state.m_60734_())) {
            return x;
        }
        world.m_6933_(pos.m_142125_(), pos.m_142125_().m_123342_() > 16 ? oreVein.oreType.m_49966_() : oreVein.deepSlate_oreType.m_49966_(), 2, 512);
        ++x;
        state = world.m_8055_(pos.m_142127_());
        if (Reference.WORLDGEN_BLACKLIST.contains(state.m_60734_())) {
            return x;
        }
        world.m_6933_(pos.m_142127_(), pos.m_142127_().m_123342_() > 16 ? oreVein.oreType.m_49966_() : oreVein.deepSlate_oreType.m_49966_(), 2, 512);
        ++x;
        state = world.m_8055_(pos.m_142128_());
        if (Reference.WORLDGEN_BLACKLIST.contains(state.m_60734_())) {
            return x;
        }
        world.m_6933_(pos.m_142128_(), pos.m_142128_().m_123342_() > 16 ? oreVein.oreType.m_49966_() : oreVein.deepSlate_oreType.m_49966_(), 2, 512);
        return ++x;
    }
}

