/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModSounds {
    public static final List<SoundEvent> SOUNDS = new ArrayList<SoundEvent>();
    public static SoundEvent TAP_SQUEAK;
    public static SoundEvent ENTITY_WITHER_SPAWN_LOCAL;
    public static SoundEvent ENTITY_WITHER_DEATH_LOCAL;
    public static SoundEvent ENTITY_DRAGON_DEATH_LOCAL;
    public static SoundEvent CHICKEN_RISE;
    public static SoundEvent SPOOPY_CHANGE;
    public static SoundEvent SOLID_XP_BLOCK_BOING;
    public static final SoundType SOLID_XP_BLOCK;

    public static SoundEvent registerSoundResource(String name) {
        return new SoundEvent(new ResourceLocation("mob_grinding_utils", name));
    }

    public static void init() {
        TAP_SQUEAK = ModSounds.registerSoundResource("tap_squeak");
        ENTITY_WITHER_SPAWN_LOCAL = ModSounds.registerSoundResource("entity_wither_spawn_local");
        ENTITY_WITHER_DEATH_LOCAL = ModSounds.registerSoundResource("entity_wither_death_local");
        ENTITY_DRAGON_DEATH_LOCAL = ModSounds.registerSoundResource("entity_dragon_death_local");
        CHICKEN_RISE = ModSounds.registerSoundResource("chicken_rise");
        SPOOPY_CHANGE = ModSounds.registerSoundResource("spoopy_change");
        SOLID_XP_BLOCK_BOING = ModSounds.registerSoundResource("solid_xp_block_boing");
    }

    public static void initReg() {
        try {
            for (Field field : ModSounds.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof SoundEvent)) continue;
                SoundEvent sound = (SoundEvent)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                ModSounds.registerSoundName(name, sound);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSoundName(String name, SoundEvent sound) {
        SOUNDS.add(sound);
        sound.setRegistryName("mob_grinding_utils", name);
    }

    static {
        SOLID_XP_BLOCK = new SoundType(1.0f, 1.0f, SoundEvents.f_12275_, SoundEvents.f_11871_, SoundEvents.f_11871_, SoundEvents.f_11871_, SoundEvents.f_11871_);
    }

    @Mod.EventBusSubscriber(modid="mob_grinding_utils", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandlerSounds {
        @SubscribeEvent
        public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            ModSounds.init();
            ModSounds.initReg();
            IForgeRegistry registry = event.getRegistry();
            for (SoundEvent sounds : SOUNDS) {
                registry.register((IForgeRegistryEntry)sounds);
            }
        }
    }
}

