/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.tile.TileEntitySaw;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class BlockSaw
extends DirectionalBlock
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final VoxelShape SAW_AABB = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public BlockSaw(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEntitySaw(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? TileEntitySaw::clientTick : TileEntitySaw::serverTick;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SAW_AABB;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_46753_(context.m_8083_())));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            TileEntitySaw tile = (TileEntitySaw)world.m_7702_(pos);
            tile.setActive(true);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, POWERED});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileentity;
        if (!world.f_46443_ && (tileentity = world.m_7702_(pos)) instanceof TileEntitySaw) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((TileEntitySaw)tileentity), (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            TileEntitySaw tile = (TileEntitySaw)world.m_7702_(pos);
            if (tile != null) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tile);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.f_46443_) {
            TileEntitySaw tile = (TileEntitySaw)world.m_7702_(pos);
            boolean flag = (Boolean)state.m_61143_((Property)POWERED);
            if (flag != world.m_46753_(pos)) {
                if (flag) {
                    world.m_186460_(pos, (Block)this, 4);
                } else {
                    world.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
                    if (tile != null) {
                        tile.setActive((Boolean)state.m_61143_((Property)POWERED) == false);
                    }
                }
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        if (!world.f_46443_) {
            TileEntitySaw tile = (TileEntitySaw)world.m_7702_(pos);
            if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !world.m_46753_(pos)) {
                world.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
                if (tile != null) {
                    tile.setActive((Boolean)state.m_61143_((Property)POWERED) == false);
                }
            }
        }
    }

    public boolean getWeakChanges(BlockState state, LevelReader world, BlockPos pos) {
        return state.m_60713_((Block)ModBlocks.SAW.getBlock());
    }
}

