/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import java.util.function.Supplier;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class MessageSolidifier {
    public int buttonID;
    public BlockPos tilePos;

    public MessageSolidifier(int button, BlockPos pos) {
        this.buttonID = button;
        this.tilePos = pos;
    }

    public MessageSolidifier(int button, int x, int y, int z) {
        this.buttonID = button;
        this.tilePos = new BlockPos(x, y, z);
    }

    public static void encode(MessageSolidifier message, FriendlyByteBuf buf) {
        buf.writeInt(message.buttonID);
        buf.m_130064_(message.tilePos);
    }

    public static MessageSolidifier decode(FriendlyByteBuf buf) {
        return new MessageSolidifier(buf.readInt(), buf.m_130135_());
    }

    public static void handle(MessageSolidifier message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerLevel world = player.m_183503_();
            TileEntityXPSolidifier solidifier = (TileEntityXPSolidifier)world.m_7702_(message.tilePos);
            if (solidifier != null) {
                if (message.buttonID == 0) {
                    solidifier.toggleOutput();
                }
                if (message.buttonID == 1) {
                    solidifier.toggleOnOff();
                }
                BlockState state = world.m_8055_(message.tilePos);
                world.m_7260_(message.tilePos, state, state, 3);
            }
        });
    }
}

