/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidIngredient
extends Ingredient {
    private final Boolean advanced;
    private final List<Fluid> matchingFluids = new ArrayList<Fluid>();
    private final Tag<Fluid> fluidTag;
    private ItemStack[] bucketCache = null;
    private IntList matchingStacksPacked;
    public static Serializer SERIALIZER = new Serializer();

    private List<Fluid> getMatchingFluids() {
        if (!this.matchingFluids.isEmpty()) {
            return this.matchingFluids;
        }
        if (this.fluidTag != null) {
            this.matchingFluids.addAll(this.fluidTag.m_6497_());
        }
        return this.matchingFluids;
    }

    public FluidIngredient(Tag<Fluid> tagIn, boolean advancedIn) {
        super(Stream.empty());
        this.advanced = advancedIn;
        this.fluidTag = tagIn;
    }

    public FluidIngredient(Fluid fluidIn, boolean advancedIn) {
        super(Stream.empty());
        this.advanced = advancedIn;
        this.matchingFluids.add(fluidIn);
        this.fluidTag = null;
    }

    public FluidIngredient(List<Fluid> fluidList, boolean advancedIn) {
        super(Stream.empty());
        this.advanced = advancedIn;
        this.fluidTag = null;
        this.matchingFluids.addAll(fluidList);
    }

    public boolean m_43947_() {
        return false;
    }

    public IntList m_43931_() {
        if (this.matchingStacksPacked == null) {
            this.matchingStacksPacked = new IntArrayList(this.m_43908_().length);
            for (ItemStack itemstack : this.bucketCache) {
                this.matchingStacksPacked.add(StackedContents.m_36496_((ItemStack)itemstack));
            }
            this.matchingStacksPacked.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.matchingStacksPacked;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("advanced", this.advanced);
        if (this.fluidTag != null) {
            json.addProperty("tag", SerializationTags.m_13199_().m_144454_(Registry.f_122899_, this.fluidTag, () -> new IllegalStateException("Unknown fluid tag")).toString());
        } else {
            json.addProperty("fluid", this.getMatchingFluids().get(0).getRegistryName().toString());
        }
        return json;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.bucketCache == null) {
            ArrayList tmp = new ArrayList();
            this.getMatchingFluids().forEach(fluid -> {
                ItemStack newBucket = FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
                if (!newBucket.m_41619_()) {
                    tmp.add(newBucket);
                }
            });
            this.bucketCache = tmp.toArray(tmp.toArray(new ItemStack[0]));
        }
        return this.bucketCache;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public boolean test(@Nullable ItemStack stack) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            if (!this.advanced.booleanValue() && !(stack.m_41720_() instanceof BucketItem)) {
                return false;
            }
            FluidStack fluid = ((IFluidHandlerItem)cap.resolve().get()).getFluidInTank(0);
            return this.getMatchingFluids().contains(fluid.getFluid()) && fluid.getAmount() >= 1000;
        }
        return false;
    }

    public static class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public static ResourceLocation NAME = new ResourceLocation("mob_grinding_utils", "fluid");

        public FluidIngredient parse(FriendlyByteBuf buffer) {
            boolean buckets = buffer.readBoolean();
            int fluidCount = buffer.m_130242_();
            ArrayList<Fluid> fluids = new ArrayList<Fluid>();
            for (int i = 0; i < fluidCount; ++i) {
                fluids.add((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(buffer.m_130277_())));
            }
            return new FluidIngredient(fluids, buckets);
        }

        public FluidIngredient parse(JsonObject json) {
            boolean advanced;
            boolean bl = advanced = json.has("advanced") && GsonHelper.m_13912_((JsonObject)json, (String)"advanced");
            if (json.has("tag")) {
                ResourceLocation tagRes = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
                Tag fluidTag = SerializationTags.m_13199_().m_144458_(Registry.f_122899_, tagRes, tag -> new IllegalStateException("Unknown fluid tag: " + tag));
                if (fluidTag != null) {
                    return new FluidIngredient((Tag<Fluid>)fluidTag, advanced);
                }
                throw new JsonSyntaxException("invalid fluid tag: " + tagRes);
            }
            if (json.has("fluid")) {
                ResourceLocation fluidRes = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidRes);
                if (fluid != null) {
                    return new FluidIngredient(fluid, advanced);
                }
            } else {
                throw new JsonSyntaxException("invalid FluidIngredient, must specify either a fluid, or a fluid tag.");
            }
            throw new JsonParseException("FluidIngredient needs either a fluid or a fluid tag.");
        }

        public void write(FriendlyByteBuf buffer, FluidIngredient ingredient) {
            buffer.writeBoolean(ingredient.advanced.booleanValue());
            buffer.m_130130_(ingredient.getMatchingFluids().size());
            ingredient.getMatchingFluids().forEach(fluid -> buffer.m_130070_(fluid.getRegistryName().toString()));
        }
    }
}

