/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.inventory.server.ContainerAbsorptionHopper;
import mob_grinding_utils.inventory.server.InventoryWrapperAH;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityAbsorptionHopper
extends TileEntityInventoryHelper
implements MenuProvider {
    public FluidTank tank = new FluidTank(16000);
    private final LazyOptional<IFluidHandler> tank_holder = LazyOptional.of(() -> this.tank);
    private final IItemHandler itemHandler;
    private LazyOptional<IItemHandler> itemholder = LazyOptional.empty();
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    public int prevTankAmount;
    public EnumStatus[] status = new EnumStatus[]{EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE};
    public boolean showRenderBox;
    public int offsetX;
    public int offsetY;
    public int offsetZ;

    public TileEntityAbsorptionHopper(BlockPos pos, BlockState state) {
        super(ModBlocks.ABSORPTION_HOPPER.getTileEntityType(), 17, pos, state);
        this.itemHandler = this.createUnSidedHandler();
        this.itemholder = LazyOptional.of(() -> this.itemHandler);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        EnumStatus[] old = new EnumStatus[]{this.status[0], this.status[1], this.status[2], this.status[3], this.status[4], this.status[5]};
        super.onDataPacket(net, packet);
        this.m_142466_(packet.m_131708_());
        for (Direction facing : Direction.values()) {
            if (old[facing.ordinal()] == this.status[facing.ordinal()]) continue;
            this.m_58904_().m_6550_(this.m_58899_(), this.m_58904_().m_8055_(this.m_58899_()), this.m_58904_().m_8055_(this.m_58899_()));
            return;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    @Override
    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.status[0] = EnumStatus.values()[tagCompound.m_128445_("down")];
        this.status[1] = EnumStatus.values()[tagCompound.m_128445_("up")];
        this.status[2] = EnumStatus.values()[tagCompound.m_128445_("north")];
        this.status[3] = EnumStatus.values()[tagCompound.m_128445_("south")];
        this.status[4] = EnumStatus.values()[tagCompound.m_128445_("west")];
        this.status[5] = EnumStatus.values()[tagCompound.m_128445_("east")];
        this.showRenderBox = tagCompound.m_128471_("showRenderBox");
        this.offsetX = tagCompound.m_128451_("offsetX");
        this.offsetY = tagCompound.m_128451_("offsetY");
        this.offsetZ = tagCompound.m_128451_("offsetZ");
        this.tank.readFromNBT(tagCompound);
    }

    @Override
    public void m_183515_(CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128344_("down", (byte)this.status[0].ordinal());
        tagCompound.m_128344_("up", (byte)this.status[1].ordinal());
        tagCompound.m_128344_("north", (byte)this.status[2].ordinal());
        tagCompound.m_128344_("south", (byte)this.status[3].ordinal());
        tagCompound.m_128344_("west", (byte)this.status[4].ordinal());
        tagCompound.m_128344_("east", (byte)this.status[5].ordinal());
        tagCompound.m_128379_("showRenderBox", this.showRenderBox);
        tagCompound.m_128405_("offsetX", this.offsetX);
        tagCompound.m_128405_("offsetY", this.offsetY);
        tagCompound.m_128405_("offsetZ", this.offsetZ);
        this.tank.writeToNBT(tagCompound);
    }

    public EnumStatus getSideStatus(Direction side) {
        return this.status[side.ordinal()];
    }

    public void toggleMode(Direction side) {
        switch (this.status[side.ordinal()]) {
            case STATUS_NONE: {
                this.status[side.ordinal()] = EnumStatus.STATUS_OUTPUT_ITEM;
                break;
            }
            case STATUS_OUTPUT_ITEM: {
                this.status[side.ordinal()] = EnumStatus.STATUS_OUTPUT_FLUID;
                break;
            }
            case STATUS_OUTPUT_FLUID: {
                this.status[side.ordinal()] = EnumStatus.STATUS_NONE;
            }
        }
        this.m_6596_();
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.m_6596_();
    }

    public void toggleOffset(int direction) {
        switch (direction) {
            case 7: {
                if (this.getoffsetY() < -3 - this.getModifierAmount()) break;
                this.offsetY = this.getoffsetY() - 1;
                break;
            }
            case 8: {
                if (this.getoffsetY() > 3 + this.getModifierAmount()) break;
                this.offsetY = this.getoffsetY() + 1;
                break;
            }
            case 9: {
                if (this.getoffsetZ() < -3 - this.getModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() - 1;
                break;
            }
            case 10: {
                if (this.getoffsetZ() > 3 + this.getModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() + 1;
                break;
            }
            case 11: {
                if (this.getoffsetX() < -3 - this.getModifierAmount()) break;
                this.offsetX = this.getoffsetX() - 1;
                break;
            }
            case 12: {
                if (this.getoffsetX() > 3 + this.getModifierAmount()) break;
                this.offsetX = this.getoffsetX() + 1;
            }
        }
        this.m_6596_();
    }

    public void updateBlock() {
        this.m_58904_().m_7260_(this.f_58858_, this.m_58904_().m_8055_(this.f_58858_), this.m_58904_().m_8055_(this.f_58858_), 3);
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityAbsorptionHopper) {
            TileEntityAbsorptionHopper tile = (TileEntityAbsorptionHopper)t;
            tile.prevTankAmount = tile.tank.getFluidAmount();
            for (Direction facing : Direction.values()) {
                BlockEntity fluidTile;
                LazyOptional tileOptional;
                if (tile.status[facing.ordinal()] == EnumStatus.STATUS_OUTPUT_ITEM) {
                    BlockEntity otherTile = level.m_7702_(worldPosition.m_142300_(facing));
                    if (otherTile != null && otherTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.m_122424_()).isPresent()) {
                        tileOptional = otherTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.m_122424_());
                        tileOptional.ifPresent(handler -> {
                            if (level.m_46467_() % 8L == 0L) {
                                for (int i = 0; i < tile.m_6643_(); ++i) {
                                    if (tile.m_8020_(i).m_41619_() || i == 0) continue;
                                    ItemStack stack = tile.m_8020_(i).m_41777_();
                                    stack.m_41764_(1);
                                    ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                                    if (!stack1.m_41619_()) continue;
                                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)tile.m_7407_(i, 1), (boolean)false);
                                    tile.m_6596_();
                                }
                            }
                        });
                    } else if (otherTile instanceof Container) {
                        Container iinventory = (Container)otherTile;
                        if (tile.isInventoryFull(iinventory, facing)) break;
                        if (level.m_46467_() % 8L == 0L) {
                            for (int i = 0; i < tile.m_6643_(); ++i) {
                                if (tile.m_8020_(i).m_41619_() || i == 0) continue;
                                ItemStack stack = tile.m_8020_(i).m_41777_();
                                ItemStack stack1 = TileEntityAbsorptionHopper.putStackInInventoryAllSlots(iinventory, tile.m_7407_(i, 1), facing.m_122424_());
                                if (stack1.m_41619_() || stack1.m_41613_() == 0) {
                                    iinventory.m_6596_();
                                    continue;
                                }
                                tile.m_6836_(i, stack);
                            }
                        }
                    }
                }
                if (tile.status[facing.ordinal()] != EnumStatus.STATUS_OUTPUT_FLUID || (fluidTile = level.m_7702_(worldPosition.m_142300_(facing))) == null) continue;
                tileOptional = fluidTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.m_122424_());
                tileOptional.ifPresent(receptacle -> {
                    int tanks = receptacle.getTanks();
                    for (int x = 0; x < tanks; ++x) {
                        if (receptacle.getTankCapacity(x) <= 0) continue;
                        FluidStack contents = receptacle.getFluidInTank(x);
                        if (tile.tank.getFluid().isEmpty() || !contents.isEmpty() && (contents.getAmount() > receptacle.getTankCapacity(x) - 100 || !contents.containsFluid(new FluidStack(tile.tank.getFluid(), 1)))) continue;
                        receptacle.fill(tile.tank.drain(new FluidStack(tile.tank.getFluid(), 100), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                        tile.m_6596_();
                    }
                });
            }
            if (level.m_46467_() % 3L == 0L && !level.m_46753_(worldPosition)) {
                if (!tile.isInventoryFull((Container)tile, null)) {
                    tile.captureDroppedItems();
                }
                if (tile.tank.getFluid().isEmpty() || tile.tank.getFluid().containsFluid(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), 1))) {
                    tile.captureDroppedXP();
                }
            }
            if (tile.prevTankAmount != tile.tank.getFluidAmount()) {
                tile.updateBlock();
            }
        }
    }

    @Override
    @Nullable
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.getItems(), (int)index, (int)count);
    }

    public boolean captureDroppedItems() {
        for (ItemEntity entityitem : this.getCaptureItems()) {
            if (!TileEntityAbsorptionHopper.putDropInInventoryAllSlots((Container)this, entityitem)) continue;
            return true;
        }
        return false;
    }

    public List<ItemEntity> getCaptureItems() {
        return this.m_58904_().m_6443_(ItemEntity.class, this.getAABBWithModifiers(), EntitySelector.f_20402_);
    }

    public boolean captureDroppedXP() {
        Iterator<ExperienceOrb> iterator = this.getCaptureXP().iterator();
        if (iterator.hasNext()) {
            ExperienceOrb entity = iterator.next();
            int xpAmount = entity.m_20801_();
            if (this.tank.getFluidAmount() < this.tank.getCapacity() - xpAmount * 20) {
                this.tank.fill(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), xpAmount * 20), IFluidHandler.FluidAction.EXECUTE);
                entity.f_20770_ = 0;
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    public List<ExperienceOrb> getCaptureXP() {
        return this.m_58904_().m_6443_(ExperienceOrb.class, this.getAABBWithModifiers(), EntitySelector.f_20402_);
    }

    public AABB getAABBWithModifiers() {
        double x = (double)this.m_58899_().m_123341_() + 0.5;
        double y = (double)this.m_58899_().m_123342_() + 0.5;
        double z = (double)this.m_58899_().m_123343_() + 0.5;
        return new AABB(x - 3.5 - (double)this.getModifierAmount(), y - 3.5 - (double)this.getModifierAmount(), z - 3.5 - (double)this.getModifierAmount(), x + 3.5 + (double)this.getModifierAmount(), y + 3.5 + (double)this.getModifierAmount(), z + 3.5 + (double)this.getModifierAmount()).m_82386_((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getAABBForRender() {
        return new AABB(-3.0 - (double)this.getModifierAmount(), -3.0 - (double)this.getModifierAmount(), -3.0 - (double)this.getModifierAmount(), 4.0 + (double)this.getModifierAmount(), 4.0 + (double)this.getModifierAmount(), 4.0 + (double)this.getModifierAmount()).m_82386_((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return this.getAABBWithModifiers();
    }

    public int getoffsetX() {
        return Math.max(-4 - this.getModifierAmount(), Math.min(this.offsetX, 4 + this.getModifierAmount()));
    }

    public int getoffsetY() {
        return Math.max(-4 - this.getModifierAmount(), Math.min(this.offsetY, 4 + this.getModifierAmount()));
    }

    public int getoffsetZ() {
        return Math.max(-4 - this.getModifierAmount(), Math.min(this.offsetZ, 4 + this.getModifierAmount()));
    }

    private boolean hasUpgrade() {
        return !((ItemStack)this.getItems().get(0)).m_41619_() && ((ItemStack)this.getItems().get(0)).m_41720_() == ModItems.ABSORPTION_UPGRADE.get();
    }

    public int getModifierAmount() {
        return this.hasUpgrade() ? ((ItemStack)this.getItems().get(0)).m_41613_() : 0;
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.getItems(), (int)index);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return slot != 0;
    }

    @Nonnull
    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction direction) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return slot != 0;
    }

    private boolean isInventoryFull(Container inventoryIn, Direction side) {
        if (inventoryIn instanceof WorldlyContainer) {
            int[] aint;
            WorldlyContainer isidedinventory = (WorldlyContainer)inventoryIn;
            for (int k : aint = isidedinventory.m_7071_(side)) {
                ItemStack itemstack1 = isidedinventory.m_8020_(k);
                if (!itemstack1.m_41619_() && itemstack1.m_41613_() == itemstack1.m_41741_()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.m_6643_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.m_8020_(j);
                if (!itemstack.m_41619_() && itemstack.m_41613_() == itemstack.m_41741_()) continue;
                return false;
            }
        }
        return true;
    }

    public static ItemStack putStackInInventoryAllSlots(Container inventory, ItemStack stack, @Nullable Direction facing) {
        if (inventory instanceof WorldlyContainer && facing != null && !(inventory instanceof TileEntityAbsorptionHopper) && inventory.m_7013_(0, stack.m_41777_())) {
            WorldlyContainer isidedinventory = (WorldlyContainer)inventory;
            int[] aint = isidedinventory.m_7071_(facing);
            for (int k = 0; k < aint.length && !stack.m_41619_(); ++k) {
                stack = TileEntityAbsorptionHopper.insertStack(inventory, stack, aint[k], facing);
            }
        } else {
            int i = inventory.m_6643_();
            for (int j = 0; j < i && !stack.m_41619_(); ++j) {
                stack = TileEntityAbsorptionHopper.insertStack(inventory, stack, j, facing);
            }
        }
        return stack;
    }

    public static boolean putDropInInventoryAllSlots(Container inventoryIn, ItemEntity itemIn) {
        boolean flag = false;
        if (itemIn == null || inventoryIn instanceof TileEntityAbsorptionHopper && inventoryIn.m_7013_(0, itemIn.m_32055_().m_41777_())) {
            return false;
        }
        ItemStack itemstack = itemIn.m_32055_().m_41777_();
        ItemStack itemstack1 = TileEntityAbsorptionHopper.putStackInInventoryAllSlots(inventoryIn, itemstack, null);
        if (!itemstack1.m_41619_()) {
            itemIn.m_32045_(itemstack1);
        } else {
            flag = true;
            itemIn.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return flag;
    }

    private static boolean canInsertItemInSlot(Container inventoryIn, ItemStack stack, int index, Direction side) {
        return inventoryIn.m_7013_(index, stack) && (!(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).m_7155_(index, stack, side));
    }

    private static ItemStack insertStack(Container inventory, ItemStack stack, int index, Direction side) {
        ItemStack itemstack = inventory.m_8020_(index);
        if (TileEntityAbsorptionHopper.canInsertItemInSlot(inventory, stack, index, side)) {
            if (itemstack.m_41619_()) {
                inventory.m_6836_(index, stack);
                stack = ItemStack.f_41583_;
            } else if (TileEntityAbsorptionHopper.canCombine(itemstack, stack)) {
                int i = stack.m_41741_() - itemstack.m_41613_();
                int j = Math.min(stack.m_41613_(), i);
                stack.m_41774_(j);
                itemstack.m_41769_(j);
            }
        }
        return stack;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() != stack2.m_41720_() ? false : (stack1.m_41773_() != stack2.m_41773_() ? false : (stack1.m_41613_() > stack1.m_41741_() ? false : ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2)));
    }

    protected IItemHandler createUnSidedHandler() {
        return new InventoryWrapperAH((Container)this);
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().getAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tank_holder.cast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemholder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player player) {
        return new ContainerAbsorptionHopper(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    @Nonnull
    public Component m_5446_() {
        return new TextComponent("Absorption Hopper");
    }

    public static enum EnumStatus implements StringRepresentable
    {
        STATUS_NONE("none"),
        STATUS_OUTPUT_ITEM("item"),
        STATUS_OUTPUT_FLUID("fluid");

        private final String name;

        private EnumStatus(String name) {
            this.name = name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }
    }
}

