/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.tile.TileEntityJumboTank;
import mob_grinding_utils.tile.TileEntitySinkTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityTank
extends BlockEntity {
    public FluidTank tank = new FluidTank(32000);
    private final LazyOptional<IFluidHandler> tank_holder = LazyOptional.of(() -> this.tank);
    public int prevTankAmount;

    public TileEntityTank(BlockPos pos, BlockState state) {
        super(ModBlocks.TANK.getTileEntityType(), pos, state);
    }

    public TileEntityTank(BlockEntityType<TileEntitySinkTank> TANK_SINK_TILE, BlockPos pos, BlockState state) {
        super(TANK_SINK_TILE, pos, state);
    }

    public TileEntityTank(BlockEntityType<TileEntityJumboTank> JUMBO_TANK_TILE, FluidTank tankIn, BlockPos pos, BlockState state) {
        super(JUMBO_TANK_TILE, pos, state);
        this.tank = tankIn;
    }

    public static <T extends BlockEntity> void serverTick(Level world, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityTank) {
            TileEntityTank tile = (TileEntityTank)t;
            if (tile.prevTankAmount != tile.tank.getFluidAmount()) {
                tile.updateBlock();
            }
            tile.prevTankAmount = tile.tank.getFluidAmount();
        }
    }

    public void updateBlock() {
        this.m_58904_().m_7260_(this.f_58858_, this.m_58904_().m_8055_(this.f_58858_), this.m_58904_().m_8055_(this.f_58858_), 3);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.m_142466_(packet.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.tank.readFromNBT(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.tank.writeToNBT(nbt);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tank_holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }
}

