/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.BoundFunction;
import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.DefaultErrorReporter;
import dev.latvian.mods.rhino.ErrorReporter;
import dev.latvian.mods.rhino.Evaluator;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.IdFunctionObject;
import dev.latvian.mods.rhino.IdScriptableObject;
import dev.latvian.mods.rhino.JavaScriptException;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.NativeCall;
import dev.latvian.mods.rhino.NativeFunction;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.UniqueTag;

public class BaseFunction
extends IdScriptableObject
implements Function {
    private static final long serialVersionUID = 5311394446546053859L;
    private static final Object FUNCTION_TAG = "Function";
    private static final String FUNCTION_CLASS = "Function";
    static final String GENERATOR_FUNCTION_CLASS = "__GeneratorFunction";
    private static final int Id_length = 1;
    private static final int Id_arity = 2;
    private static final int Id_name = 3;
    private static final int Id_prototype = 4;
    private static final int Id_arguments = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_apply = 4;
    private static final int Id_call = 5;
    private static final int Id_bind = 6;
    private static final int MAX_PROTOTYPE_ID = 6;
    private Object prototypeProperty;
    private Object argumentsObj = NOT_FOUND;
    private boolean isGeneratorFunction = false;
    private int prototypePropertyAttributes = 6;
    private int argumentsAttributes = 6;

    static void init(Scriptable scope, boolean sealed) {
        BaseFunction obj = new BaseFunction();
        obj.prototypePropertyAttributes = 7;
        obj.exportAsJSClass(6, scope, sealed);
    }

    static Object initAsGeneratorFunction(Scriptable scope, boolean sealed) {
        BaseFunction obj = new BaseFunction(true);
        obj.prototypePropertyAttributes = 5;
        obj.exportAsJSClass(6, scope, sealed);
        return BaseFunction.getProperty(scope, GENERATOR_FUNCTION_CLASS);
    }

    public BaseFunction() {
    }

    public BaseFunction(boolean isGenerator) {
        this.isGeneratorFunction = isGenerator;
    }

    public BaseFunction(Scriptable scope, Scriptable prototype) {
        super(scope, prototype);
    }

    @Override
    public String getClassName() {
        return this.isGeneratorFunction() ? GENERATOR_FUNCTION_CLASS : FUNCTION_CLASS;
    }

    protected boolean isGeneratorFunction() {
        return this.isGeneratorFunction;
    }

    @Override
    public String getTypeOf() {
        return this.avoidObjectDetection() ? "undefined" : "function";
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        Object protoProp = BaseFunction.getProperty((Scriptable)this, "prototype");
        if (protoProp instanceof Scriptable) {
            return ScriptRuntime.jsDelegatesTo(instance, (Scriptable)protoProp);
        }
        throw ScriptRuntime.typeError1("msg.instanceof.bad.prototype", this.getFunctionName());
    }

    @Override
    protected int getMaxInstanceId() {
        return 5;
    }

    @Override
    protected int findInstanceIdInfo(String s) {
        int attr;
        int id;
        switch (s) {
            case "name": {
                int n = 3;
                break;
            }
            case "length": {
                int n = 1;
                break;
            }
            case "arity": {
                int n = 2;
                break;
            }
            case "prototype": {
                int n = 4;
                break;
            }
            case "arguments": {
                int n = 5;
                break;
            }
            default: {
                int n = id = 0;
            }
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s);
        }
        switch (id) {
            case 1: 
            case 2: 
            case 3: {
                attr = 7;
                break;
            }
            case 4: {
                if (!this.hasPrototypeProperty()) {
                    return 0;
                }
                attr = this.prototypePropertyAttributes;
                break;
            }
            case 5: {
                attr = this.argumentsAttributes;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return BaseFunction.instanceIdInfo(attr, id);
    }

    @Override
    protected String getInstanceIdName(int id) {
        return switch (id) {
            case 1 -> "length";
            case 2 -> "arity";
            case 3 -> "name";
            case 4 -> "prototype";
            case 5 -> "arguments";
            default -> super.getInstanceIdName(id);
        };
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        return switch (id) {
            case 1 -> ScriptRuntime.wrapInt(this.getLength());
            case 2 -> ScriptRuntime.wrapInt(this.getArity());
            case 3 -> this.getFunctionName();
            case 4 -> this.getPrototypeProperty();
            case 5 -> this.getArguments();
            default -> super.getInstanceIdValue(id);
        };
    }

    @Override
    protected void setInstanceIdValue(int id, Object value) {
        switch (id) {
            case 4: {
                if ((this.prototypePropertyAttributes & 1) == 0) {
                    this.prototypeProperty = value != null ? value : UniqueTag.NULL_VALUE;
                }
                return;
            }
            case 5: {
                if (value == NOT_FOUND) {
                    Kit.codeBug();
                }
                if (this.defaultHas("arguments")) {
                    this.defaultPut("arguments", value);
                } else if ((this.argumentsAttributes & 1) == 0) {
                    this.argumentsObj = value;
                }
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        super.setInstanceIdValue(id, value);
    }

    @Override
    protected void setInstanceIdAttributes(int id, int attr) {
        switch (id) {
            case 4: {
                this.prototypePropertyAttributes = attr;
                return;
            }
            case 5: {
                this.argumentsAttributes = attr;
                return;
            }
        }
        super.setInstanceIdAttributes(id, attr);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        ctor.setPrototype(this);
        super.fillConstructorProperties(ctor);
    }

    @Override
    protected void initPrototypeId(int id) {
        int arity;
        this.initPrototypeMethod(FUNCTION_TAG, id, switch (id) {
            case 1 -> {
                arity = 1;
                yield "constructor";
            }
            case 2 -> {
                arity = 0;
                yield "toString";
            }
            case 3 -> {
                arity = 1;
                yield "toSource";
            }
            case 4 -> {
                arity = 2;
                yield "apply";
            }
            case 5 -> {
                arity = 1;
                yield "call";
            }
            case 6 -> {
                arity = 1;
                yield "bind";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, arity);
    }

    static boolean isApply(IdFunctionObject f) {
        return f.hasTag(FUNCTION_TAG) && f.methodId() == 4;
    }

    static boolean isApplyOrCall(IdFunctionObject f) {
        if (f.hasTag(FUNCTION_TAG)) {
            switch (f.methodId()) {
                case 4: 
                case 5: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(FUNCTION_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                return this.jsConstructor(cx, scope, args);
            }
            case 2: 
            case 3: {
                return this.toFunctionString(thisObj);
            }
            case 4: 
            case 5: {
                return ScriptRuntime.applyOrCall(id == 4, cx, scope, thisObj, args);
            }
            case 6: {
                Object[] boundArgs;
                Scriptable boundThis;
                if (!(thisObj instanceof Callable)) {
                    throw ScriptRuntime.notFunctionError(thisObj);
                }
                Callable targetFunction = (Callable)((Object)thisObj);
                int argc = args.length;
                if (argc > 0) {
                    boundThis = ScriptRuntime.toObjectOrNull(cx, args[0], scope);
                    boundArgs = new Object[argc - 1];
                    System.arraycopy(args, 1, boundArgs, 0, argc - 1);
                } else {
                    boundThis = null;
                    boundArgs = ScriptRuntime.emptyArgs;
                }
                return new BoundFunction(cx, scope, targetFunction, boundThis, boundArgs);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public void setImmunePrototypeProperty(Object value) {
        if ((this.prototypePropertyAttributes & 1) != 0) {
            throw new IllegalStateException();
        }
        this.prototypeProperty = value != null ? value : UniqueTag.NULL_VALUE;
        this.prototypePropertyAttributes = 7;
    }

    protected Scriptable getClassPrototype() {
        Object protoVal = this.getPrototypeProperty();
        if (protoVal instanceof Scriptable) {
            return (Scriptable)protoVal;
        }
        return BaseFunction.getObjectPrototype(this);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        Scriptable result = this.createObject(cx, scope);
        if (result != null) {
            Object val = this.call(cx, scope, result, args);
            if (val instanceof Scriptable) {
                result = (Scriptable)val;
            }
        } else {
            Scriptable parent;
            Scriptable proto;
            Object val = this.call(cx, scope, null, args);
            if (!(val instanceof Scriptable)) {
                throw new IllegalStateException("Bad implementaion of call as constructor, name=" + this.getFunctionName() + " in " + this.getClass().getName());
            }
            result = (Scriptable)val;
            if (result.getPrototype() == null && result != (proto = this.getClassPrototype())) {
                result.setPrototype(proto);
            }
            if (result.getParentScope() == null && result != (parent = this.getParentScope())) {
                result.setParentScope(parent);
            }
        }
        return result;
    }

    public Scriptable createObject(Context cx, Scriptable scope) {
        NativeObject newInstance = new NativeObject();
        newInstance.setPrototype(this.getClassPrototype());
        newInstance.setParentScope(this.getParentScope());
        return newInstance;
    }

    public int getArity() {
        return 0;
    }

    public int getLength() {
        return 0;
    }

    public String getFunctionName() {
        return "";
    }

    protected String toFunctionString(Scriptable parent) {
        String s = this.getFunctionName();
        if (s.isEmpty()) {
            return parent != null ? parent.getClassName() : "Unknown";
        }
        return s;
    }

    public String toString() {
        String s = this.getFunctionName();
        return s.isEmpty() ? "Unknown" : s;
    }

    protected boolean hasPrototypeProperty() {
        return this.prototypeProperty != null || this instanceof NativeFunction;
    }

    protected Object getPrototypeProperty() {
        Object result = this.prototypeProperty;
        if (result == null) {
            result = this instanceof NativeFunction ? this.setupDefaultPrototype() : Undefined.instance;
        } else if (result == UniqueTag.NULL_VALUE) {
            result = null;
        }
        return result;
    }

    private synchronized Object setupDefaultPrototype() {
        if (this.prototypeProperty != null) {
            return this.prototypeProperty;
        }
        NativeObject obj = new NativeObject();
        int attr = 2;
        obj.defineProperty("constructor", (Object)this, 2);
        this.prototypeProperty = obj;
        Scriptable proto = BaseFunction.getObjectPrototype(this);
        if (proto != obj) {
            obj.setPrototype(proto);
        }
        return obj;
    }

    private Object getArguments() {
        Object value;
        Object object = value = this.defaultHas("arguments") ? this.defaultGet("arguments") : this.argumentsObj;
        if (value != NOT_FOUND) {
            return value;
        }
        Context cx = Context.getContext();
        NativeCall activation = ScriptRuntime.findFunctionActivation(cx, this);
        return activation == null ? null : activation.get("arguments", (Scriptable)activation);
    }

    private Object jsConstructor(Context cx, Scriptable scope, Object[] args) {
        int arglen = args.length;
        StringBuilder sourceBuf = new StringBuilder();
        sourceBuf.append("function ");
        if (this.isGeneratorFunction()) {
            sourceBuf.append("* ");
        }
        sourceBuf.append("anonymous");
        sourceBuf.append('(');
        for (int i = 0; i < arglen - 1; ++i) {
            if (i > 0) {
                sourceBuf.append(',');
            }
            sourceBuf.append(ScriptRuntime.toString(args[i]));
        }
        sourceBuf.append(") {");
        if (arglen != 0) {
            String funBody = ScriptRuntime.toString(args[arglen - 1]);
            sourceBuf.append(funBody);
        }
        sourceBuf.append("\n}");
        String source = sourceBuf.toString();
        int[] linep = new int[1];
        String filename = Context.getSourcePositionFromStack(linep);
        if (filename == null) {
            filename = "<eval'ed string>";
            linep[0] = 1;
        }
        String sourceURI = ScriptRuntime.makeUrlForGeneratedScript(false, filename, linep[0]);
        Scriptable global = BaseFunction.getTopLevelScope(scope);
        ErrorReporter reporter = DefaultErrorReporter.forEval(cx.getErrorReporter());
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator == null) {
            throw new JavaScriptException("Interpreter not present", filename, linep[0]);
        }
        return cx.compileFunction(global, source, evaluator, reporter, sourceURI, 1, null);
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "constructor" -> 1;
            case "toString" -> 2;
            case "toSource" -> 3;
            case "apply" -> 4;
            case "call" -> 5;
            case "bind" -> 6;
            default -> super.findPrototypeId(s);
        };
    }
}

