/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.util.Deletable;
import java.util.ArrayList;
import java.util.Map;

public class NativeJavaMap
extends NativeJavaObject {
    private final Map map;

    public NativeJavaMap(Scriptable scope, Object jo, Map map) {
        super(scope, jo, jo.getClass());
        this.map = map;
    }

    @Override
    public String getClassName() {
        return "JavaMap";
    }

    @Override
    public boolean has(String name, Scriptable start) {
        if (this.map.containsKey(name)) {
            return true;
        }
        return super.has(name, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.map.containsKey(index)) {
            return true;
        }
        return super.has(index, start);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this.map.containsKey(name)) {
            Context cx = Context.getContext();
            Object obj = this.map.get(name);
            return cx.getWrapFactory().wrap(cx, this, obj, obj.getClass());
        }
        return super.get(name, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.map.containsKey(index)) {
            Context cx = Context.getContext();
            Object obj = this.map.get(index);
            return cx.getWrapFactory().wrap(cx, this, obj, obj.getClass());
        }
        return super.get(index, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        this.map.put(name, Context.jsToJava(value, Object.class));
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        this.map.put(index, Context.jsToJava(value, Object.class));
    }

    @Override
    public Object[] getIds() {
        ArrayList<Object> ids = new ArrayList<Object>(this.map.size());
        for (Object key : this.map.keySet()) {
            if (key instanceof Integer) {
                ids.add(key);
                continue;
            }
            ids.add(ScriptRuntime.toString(key));
        }
        return ids.toArray();
    }

    @Override
    public void delete(String name) {
        Deletable.deleteObject(this.map.remove(name));
    }

    @Override
    public void delete(int index) {
        Deletable.deleteObject(this.map.remove(index));
    }

    @Override
    protected void initMembers() {
        super.initMembers();
        this.addCustomFunction("hasOwnProperty", this::hasOwnProperty, String.class);
    }

    private boolean hasOwnProperty(Object[] args) {
        return this.map.containsKey(ScriptRuntime.toString(args[0]));
    }
}

