/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import dev.latvian.mods.rhino.mod.util.NBTSerializable;
import dev.latvian.mods.rhino.mod.util.OrderedCompoundTag;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class NBTUtils {
    private static final TagType<OrderedCompoundTag> COMPOUND_TYPE = new TagType.VariableSize<OrderedCompoundTag>(){

        public OrderedCompoundTag load(DataInput dataInput, int i, NbtAccounter nbtAccounter) throws IOException {
            byte typeId;
            nbtAccounter.m_6800_(384L);
            if (i > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            LinkedHashMap<String, Tag> map = new LinkedHashMap<String, Tag>();
            while ((typeId = dataInput.readByte()) != 0) {
                String key = dataInput.readUTF();
                nbtAccounter.m_6800_(224L + 16L * (long)key.length());
                TagType<?> valueType = NBTUtils.convertType(TagTypes.m_129397_((int)typeId));
                Tag value = valueType.m_7300_(dataInput, i + 1, nbtAccounter);
                if (map.put(key, value) == null) continue;
                nbtAccounter.m_6800_(288L);
            }
            return new OrderedCompoundTag(map);
        }

        public StreamTagVisitor.ValueResult m_196511_(DataInput dataInput, StreamTagVisitor visitor) throws IOException {
            byte typeId;
            block13: while ((typeId = dataInput.readByte()) != 0) {
                TagType<?> valueType = NBTUtils.convertType(TagTypes.m_129397_((int)typeId));
                switch (visitor.m_196214_(valueType)) {
                    case HALT: {
                        return StreamTagVisitor.ValueResult.HALT;
                    }
                    case BREAK: {
                        StringTag.m_197563_((DataInput)dataInput);
                        valueType.m_196159_(dataInput);
                        break block13;
                    }
                    case SKIP: {
                        StringTag.m_197563_((DataInput)dataInput);
                        valueType.m_196159_(dataInput);
                        continue block13;
                    }
                    default: {
                        String key = dataInput.readUTF();
                        switch (visitor.m_196425_(valueType, key)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                valueType.m_196159_(dataInput);
                                break block13;
                            }
                            case SKIP: {
                                valueType.m_196159_(dataInput);
                                continue block13;
                            }
                        }
                        switch (valueType.m_196511_(dataInput, visitor)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (typeId != 0) {
                while ((typeId = dataInput.readByte()) != 0) {
                    StringTag.m_197563_((DataInput)dataInput);
                    NBTUtils.convertType(TagTypes.m_129397_((int)typeId)).m_196159_(dataInput);
                }
            }
            return visitor.m_196527_();
        }

        public void m_196159_(DataInput dataInput) throws IOException {
            byte typeId;
            while ((typeId = dataInput.readByte()) != 0) {
                StringTag.m_197563_((DataInput)dataInput);
                NBTUtils.convertType(TagTypes.m_129397_((int)typeId)).m_196159_(dataInput);
            }
        }

        public String m_5987_() {
            return "COMPOUND";
        }

        public String m_5986_() {
            return "TAG_Compound";
        }
    };
    private static final TagType<ListTag> LIST_TYPE = new TagType.VariableSize<ListTag>(){

        public ListTag load(DataInput dataInput, int i, NbtAccounter nbtAccounter) throws IOException {
            nbtAccounter.m_6800_(296L);
            if (i > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            byte typeId = dataInput.readByte();
            int size = dataInput.readInt();
            if (typeId == 0 && size > 0) {
                throw new RuntimeException("Missing type on ListTag");
            }
            nbtAccounter.m_6800_(32L * (long)size);
            TagType<?> valueType = NBTUtils.convertType(TagTypes.m_129397_((int)typeId));
            ListTag list = new ListTag();
            for (int k = 0; k < size; ++k) {
                list.add((Object)valueType.m_7300_(dataInput, i + 1, nbtAccounter));
            }
            return list;
        }

        /*
         * Exception decompiling
         */
        public StreamTagVisitor.ValueResult m_196511_(DataInput dataInput, StreamTagVisitor visitor) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE], 4[SWITCH]], but top level block is 9[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void m_196159_(DataInput visitor) throws IOException {
            TagType<?> tagType = NBTUtils.convertType(TagTypes.m_129397_((int)visitor.readByte()));
            int size = visitor.readInt();
            tagType.m_196189_(visitor, size);
        }

        public String m_5987_() {
            return "LIST";
        }

        public String m_5986_() {
            return "TAG_List";
        }
    };

    @Nullable
    public static Tag toNBT(@Nullable Object o) {
        if (o instanceof Tag) {
            return (Tag)o;
        }
        if (o instanceof NBTSerializable) {
            NBTSerializable s = (NBTSerializable)o;
            return s.toNBT();
        }
        if (o instanceof CharSequence || o instanceof Character) {
            return StringTag.m_129297_((String)o.toString());
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return ByteTag.m_128266_((byte)(b != false ? (byte)1 : 0));
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (number instanceof Byte) {
                return ByteTag.m_128266_((byte)number.byteValue());
            }
            if (number instanceof Short) {
                return ShortTag.m_129258_((short)number.shortValue());
            }
            if (number instanceof Integer) {
                return IntTag.m_128679_((int)number.intValue());
            }
            if (number instanceof Long) {
                return LongTag.m_128882_((long)number.longValue());
            }
            if (number instanceof Float) {
                return FloatTag.m_128566_((float)number.floatValue());
            }
            return DoubleTag.m_128500_((double)number.doubleValue());
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            OrderedCompoundTag tag = new OrderedCompoundTag();
            for (Map.Entry entry : map.entrySet()) {
                Tag nbt1 = NBTUtils.toNBT(entry.getValue());
                if (nbt1 == null) continue;
                tag.m_128365_(String.valueOf(entry.getKey()), nbt1);
            }
            return tag;
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            return NBTUtils.toNBT(c);
        }
        return null;
    }

    public static CollectionTag<?> toNBT(Collection<?> c) {
        Object[] array;
        if (c.isEmpty()) {
            return new ListTag();
        }
        Tag[] values = new Tag[c.size()];
        int s = 0;
        byte commmonId = -1;
        for (Object o : c) {
            values[s] = NBTUtils.toNBT(o);
            if (values[s] == null) continue;
            if (commmonId == -1) {
                commmonId = values[s].m_7060_();
            } else if (commmonId != values[s].m_7060_()) {
                commmonId = 0;
            }
            ++s;
        }
        if (commmonId == 3) {
            array = new int[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((NumericTag)values[i]).m_7047_();
            }
            return new IntArrayTag(array);
        }
        if (commmonId == 1) {
            array = new byte[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((NumericTag)values[i]).m_7063_();
            }
            return new ByteArrayTag((byte[])array);
        }
        if (commmonId == 4) {
            array = new long[s];
            for (int i = 0; i < s; ++i) {
                array[i] = (int)((NumericTag)values[i]).m_7046_();
            }
            return new LongArrayTag((long[])array);
        }
        if (commmonId == 0 || commmonId == -1) {
            return new ListTag();
        }
        ListTag nbt = new ListTag();
        for (Tag nbt1 : values) {
            if (nbt1 == null) {
                return nbt;
            }
            nbt.add((Object)nbt1);
        }
        return nbt;
    }

    public static void quoteAndEscapeForJS(StringBuilder stringBuilder, String string) {
        int start = stringBuilder.length();
        stringBuilder.append(' ');
        int c = 0;
        for (int i = 0; i < string.length(); ++i) {
            int d = string.charAt(i);
            if (d == 92) {
                stringBuilder.append('\\');
            } else if (d == 34 || d == 39) {
                if (c == 0) {
                    int n = c = d == 39 ? 34 : 39;
                }
                if (c == d) {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append((char)d);
        }
        if (c == 0) {
            c = 39;
        }
        stringBuilder.setCharAt(start, (char)c);
        stringBuilder.append((char)c);
    }

    private static TagType<?> convertType(TagType<?> tagType) {
        return tagType == CompoundTag.f_128326_ ? COMPOUND_TYPE : (tagType == ListTag.f_128714_ ? LIST_TYPE : tagType);
    }

    @Nullable
    public static OrderedCompoundTag read(FriendlyByteBuf buf) {
        int i = buf.readerIndex();
        byte b = buf.readByte();
        if (b == 0) {
            return null;
        }
        buf.readerIndex(i);
        try {
            DataInputStream stream = new DataInputStream((InputStream)new ByteBufInputStream((ByteBuf)buf));
            byte b1 = stream.readByte();
            if (b1 == 0) {
                return null;
            }
            stream.readUTF();
            TagType<?> tagType = NBTUtils.convertType(TagTypes.m_129397_((int)b1));
            if (tagType != COMPOUND_TYPE) {
                return null;
            }
            return (OrderedCompoundTag)COMPOUND_TYPE.m_7300_((DataInput)stream, 0, NbtAccounter.f_128917_);
        }
        catch (IOException var5) {
            throw new EncoderException((Throwable)var5);
        }
    }
}

