/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import dev.latvian.mods.rhino.mod.util.OrderedCompoundTag;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public interface NBTWrapper {
    @Nullable
    public static Object fromTag(@Nullable Tag t) {
        if (t == null || t == EndTag.f_128534_) {
            return null;
        }
        if (t instanceof StringTag) {
            return t.m_7916_();
        }
        if (t instanceof NumericTag) {
            return ((NumericTag)t).m_8103_();
        }
        return t;
    }

    @Nullable
    public static Tag toTag(@Nullable Object v) {
        if (v == null || v == EndTag.f_128534_) {
            return null;
        }
        if (v instanceof Tag) {
            return (Tag)v;
        }
        if (v instanceof String) {
            return StringTag.m_129297_((String)v.toString());
        }
        if (v instanceof Number) {
            return DoubleTag.m_128500_((double)((Number)v).doubleValue());
        }
        if (v instanceof Boolean) {
            return ByteTag.m_128273_((boolean)((Boolean)v));
        }
        if (v instanceof Map) {
            return NBTWrapper.compoundTag((Map)v);
        }
        if (v instanceof List) {
            return NBTWrapper.listTag((List)v);
        }
        return null;
    }

    public static Tag compoundTag() {
        return new OrderedCompoundTag();
    }

    public static Tag compoundTag(Map<String, Object> map) {
        OrderedCompoundTag tag = new OrderedCompoundTag();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            tag.m_128365_(e.getKey(), NBTWrapper.toTag(e.getValue()));
        }
        return tag;
    }

    public static Tag listTag() {
        return new ListTag();
    }

    public static Tag listTag(List<Object> list) {
        ListTag tag = new ListTag();
        for (Object v : list) {
            tag.add((Object)NBTWrapper.toTag(v));
        }
        return tag;
    }

    public static Tag byteTag(byte v) {
        return ByteTag.m_128266_((byte)v);
    }

    public static Tag b(byte v) {
        return ByteTag.m_128266_((byte)v);
    }

    public static Tag shortTag(short v) {
        return ShortTag.m_129258_((short)v);
    }

    public static Tag s(short v) {
        return ShortTag.m_129258_((short)v);
    }

    public static Tag intTag(int v) {
        return IntTag.m_128679_((int)v);
    }

    public static Tag i(int v) {
        return IntTag.m_128679_((int)v);
    }

    public static Tag longTag(long v) {
        return LongTag.m_128882_((long)v);
    }

    public static Tag l(long v) {
        return LongTag.m_128882_((long)v);
    }

    public static Tag floatTag(float v) {
        return FloatTag.m_128566_((float)v);
    }

    public static Tag f(float v) {
        return FloatTag.m_128566_((float)v);
    }

    public static Tag doubleTag(double v) {
        return DoubleTag.m_128500_((double)v);
    }

    public static Tag d(double v) {
        return DoubleTag.m_128500_((double)v);
    }

    public static Tag stringTag(String v) {
        return StringTag.m_129297_((String)v);
    }

    public static Tag intArrayTag(int[] v) {
        return new IntArrayTag(v);
    }

    public static Tag ia(int[] v) {
        return new IntArrayTag(v);
    }

    public static Tag longArrayTag(long[] v) {
        return new LongArrayTag(v);
    }

    public static Tag la(long[] v) {
        return new LongArrayTag(v);
    }

    public static Tag byteArrayTag(byte[] v) {
        return new ByteArrayTag(v);
    }

    public static Tag ba(byte[] v) {
        return new ByteArrayTag(v);
    }
}

