/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.util;

import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.NBTWrapper;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class CompoundTagWrapper
extends AbstractMap<String, Object>
implements Wrapper {
    private final CompoundTag compoundTag;
    private final Map<String, Tag> tags;

    public CompoundTagWrapper(CompoundTag compoundTag, Map<String, Tag> tags) {
        this.compoundTag = compoundTag;
        this.tags = tags;
    }

    @Override
    public Object unwrap() {
        return this.compoundTag;
    }

    @Override
    public Object get(Object key) {
        return NBTWrapper.fromTag(this.tags.get(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.tags.containsKey(key);
    }

    @Override
    public Object put(String key, Object v) {
        Tag t = NBTWrapper.toTag(v);
        if (t == null) {
            return NBTWrapper.fromTag(this.tags.remove(key));
        }
        return NBTWrapper.fromTag(this.tags.put(key, t));
    }

    @Override
    public Set<String> keySet() {
        return this.tags.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        LinkedHashSet<Map.Entry<String, Object>> set = new LinkedHashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            set.add(new AbstractMap.SimpleEntry<String, Object>(entry.getKey(), NBTWrapper.fromTag(entry.getValue())));
        }
        return set;
    }

    @Override
    public Object remove(Object key) {
        return NBTWrapper.fromTag(this.tags.remove(key));
    }

    @Override
    public void clear() {
        this.tags.clear();
    }
}

