/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.blocks.fluid;

import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageWrapperStorageDisk;
import de.melanx.extradisks.ModConfig;
import de.melanx.extradisks.blocks.fluid.ExtraFluidStorageBlockEntity;
import de.melanx.extradisks.items.fluid.ExtraFluidStorageType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class ExtraFluidStorageNetworkNode
extends FluidStorageNetworkNode {
    public static final ResourceLocation BLOCK_FLUID_16384K_ID = new ResourceLocation("extradisks", "16384k_fluid_storage_block");
    public static final ResourceLocation BLOCK_FLUID_65536K_ID = new ResourceLocation("extradisks", "65536k_fluid_storage_block");
    public static final ResourceLocation BLOCK_FLUID_262144K_ID = new ResourceLocation("extradisks", "262144k_fluid_storage_block");
    public static final ResourceLocation BLOCK_FLUID_1048576K_ID = new ResourceLocation("extradisks", "1048576k_fluid_storage_block");
    public static final ResourceLocation BLOCK_FLUID_INFINITE_ID = new ResourceLocation("extradisks", "infinite_fluid_storage_block");
    private final ExtraFluidStorageType type;
    private IStorageDisk<FluidStack> storage;

    public ExtraFluidStorageNetworkNode(Level level, BlockPos pos, ExtraFluidStorageType type) {
        super(level, pos, null);
        this.type = type;
    }

    public static ResourceLocation getId(ExtraFluidStorageType type) {
        switch (type) {
            case TIER_5_FLUID: {
                return BLOCK_FLUID_16384K_ID;
            }
            case TIER_6_FLUID: {
                return BLOCK_FLUID_65536K_ID;
            }
            case TIER_7_FLUID: {
                return BLOCK_FLUID_262144K_ID;
            }
            case TIER_8_FLUID: {
                return BLOCK_FLUID_1048576K_ID;
            }
            case TIER_9_FLUID: {
                return BLOCK_FLUID_INFINITE_ID;
            }
        }
        throw new IllegalArgumentException("Unknown storage type " + type);
    }

    public ResourceLocation getId() {
        return ExtraFluidStorageNetworkNode.getId(this.type);
    }

    public int getEnergyUsage() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case ExtraFluidStorageType.TIER_5_FLUID -> (Integer)ModConfig.fluid_tier5usage.get();
            case ExtraFluidStorageType.TIER_6_FLUID -> (Integer)ModConfig.fluid_tier6usage.get();
            case ExtraFluidStorageType.TIER_7_FLUID -> (Integer)ModConfig.fluid_tier7usage.get();
            case ExtraFluidStorageType.TIER_8_FLUID -> (Integer)ModConfig.fluid_tier8usage.get();
            case ExtraFluidStorageType.TIER_9_FLUID -> (Integer)ModConfig.fluid_tier9usage.get();
        };
    }

    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        if (this.storage == null) {
            this.loadStorage(null);
        }
        storages.add((IStorage<FluidStack>)this.storage);
    }

    public void loadStorage(@Nullable Player owner) {
        IStorageDisk disk = API.instance().getStorageDiskManager((ServerLevel)this.level).get(this.getStorageId());
        if (disk == null) {
            disk = API.instance().createDefaultFluidDisk((ServerLevel)this.level, this.type.getCapacity(), owner);
            API.instance().getStorageDiskManager((ServerLevel)this.level).set(this.getStorageId(), disk);
            API.instance().getStorageDiskManager((ServerLevel)this.level).markForSaving();
        }
        this.storage = new FluidStorageWrapperStorageDisk((FluidStorageNetworkNode)this, disk);
    }

    public IStorageDisk<FluidStack> getStorage() {
        return this.storage;
    }

    public Component getTitle() {
        return new TranslatableComponent("block.extradisks." + this.type.getName() + "_fluid_storage_block");
    }

    public long getStored() {
        return (Long)ExtraFluidStorageBlockEntity.STORED.getValue();
    }

    public long getCapacity() {
        return this.type.getCapacity();
    }
}

