/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.EmptyPart;
import com.mojang.datafixers.util.Unit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.permutated.pylons.block.ExpulsionPylonBlock;
import net.permutated.pylons.block.InfusionPylonBlock;
import net.permutated.pylons.inventory.container.ExpulsionPylonContainer;
import net.permutated.pylons.inventory.container.InfusionPylonContainer;
import net.permutated.pylons.item.PlayerFilterCard;
import net.permutated.pylons.item.PotionFilterCard;
import net.permutated.pylons.tile.AbstractPylonTile;
import net.permutated.pylons.tile.ExpulsionPylonTile;
import net.permutated.pylons.tile.InfusionPylonTile;

public class ModRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pylons");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"pylons");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"pylons");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"pylons");
    public static final CreativeModeTab CREATIVE_TAB = new ModItemGroup("pylons", () -> new ItemStack((ItemLike)PLAYER_FILTER.get()));
    public static final RegistryObject<Item> PLAYER_FILTER = ITEMS.register("player_filter", PlayerFilterCard::new);
    public static final RegistryObject<Item> POTION_FILTER = ITEMS.register("potion_filter", PotionFilterCard::new);
    public static final RegistryObject<Block> EXPULSION_PYLON = BLOCKS.register("expulsion_pylon", ExpulsionPylonBlock::new);
    public static final RegistryObject<Block> INFUSION_PYLON = BLOCKS.register("infusion_pylon", InfusionPylonBlock::new);
    public static final RegistryObject<BlockItem> EXPULSION_PYLON_ITEM = ModRegistry.blockItem(EXPULSION_PYLON);
    public static final RegistryObject<BlockItem> INFUSION_PYLON_ITEM = ModRegistry.blockItem(INFUSION_PYLON);
    public static final RegistryObject<BlockEntityType<ExpulsionPylonTile>> EXPULSION_PYLON_TILE = ModRegistry.blockEntity(EXPULSION_PYLON, ExpulsionPylonTile::new);
    public static final RegistryObject<BlockEntityType<InfusionPylonTile>> INFUSION_PYLON_TILE = ModRegistry.blockEntity(INFUSION_PYLON, InfusionPylonTile::new);
    public static final RegistryObject<MenuType<ExpulsionPylonContainer>> EXPULSION_PYLON_CONTAINER = ModRegistry.container("expulsion_pylon", ExpulsionPylonContainer::new);
    public static final RegistryObject<MenuType<InfusionPylonContainer>> INFUSION_PYLON_CONTAINER = ModRegistry.container("infusion_pylon", InfusionPylonContainer::new);
    private static final Type<Unit> EMPTY_PART = new EmptyPart();

    private ModRegistry() {
    }

    private static RegistryObject<BlockItem> blockItem(RegistryObject<Block> registryObject) {
        return ITEMS.register(registryObject.getId().m_135815_(), () -> new BlockItem((Block)registryObject.get(), new Item.Properties().m_41491_(CREATIVE_TAB)));
    }

    private static RegistryObject<Item> material(String path) {
        return ITEMS.register(path, () -> new Item(new Item.Properties().m_41491_(CREATIVE_TAB)));
    }

    private static <T extends AbstractPylonTile> RegistryObject<BlockEntityType<T>> blockEntity(RegistryObject<Block> registryObject, BlockEntityType.BlockEntitySupplier<T> supplier) {
        return TILES.register(registryObject.getId().m_135815_(), () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{(Block)registryObject.get()}).m_58966_(EMPTY_PART));
    }

    private static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> container(String path, IContainerFactory<T> supplier) {
        return CONTAINERS.register(path, () -> IForgeMenuType.create((IContainerFactory)supplier));
    }

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        BLOCKS.register(bus);
        TILES.register(bus);
        CONTAINERS.register(bus);
    }

    public static final class ModItemGroup
    extends CreativeModeTab {
        private final Supplier<ItemStack> iconSupplier;

        public ModItemGroup(String name, Supplier<ItemStack> iconSupplier) {
            super(name);
            this.iconSupplier = iconSupplier;
        }

        @Nonnull
        public ItemStack m_6976_() {
            return this.iconSupplier.get();
        }
    }
}

