/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.inventory.container;

import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.RegistryObject;
import net.permutated.pylons.network.NetworkDispatcher;
import net.permutated.pylons.network.PacketButtonClicked;
import net.permutated.pylons.tile.AbstractPylonTile;

public abstract class AbstractPylonContainer
extends AbstractContainerMenu {
    @Nullable
    private final AbstractPylonTile tileEntity;
    protected final String ownerName;
    protected final BlockPos blockPos;

    protected AbstractPylonContainer(@Nullable MenuType<?> containerType, int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        super(containerType, windowId);
        this.blockPos = packetBuffer.m_130135_();
        Level world = playerInventory.f_35978_.m_20193_();
        this.tileEntity = (AbstractPylonTile)world.m_7702_(this.blockPos);
        InvWrapper wrappedInventory = new InvWrapper((Container)playerInventory);
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int slot = 0; slot < 9; ++slot) {
                    this.m_38897_((Slot)new SlotItemHandler(handler, slot, 8 + slot * 18, 54));
                }
            });
        }
        int nameLength = packetBuffer.readInt();
        this.ownerName = packetBuffer.m_130136_(nameLength);
        this.registerPlayerSlots((IItemHandler)wrappedInventory);
    }

    protected abstract RegistryObject<Block> getBlock();

    protected int getInventorySize() {
        return 9;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Component getWorkComponent() {
        boolean shouldWork = this.tileEntity != null && this.tileEntity.shouldWork();
        return new TextComponent(shouldWork ? "On" : "Off");
    }

    public void sendWorkPacket(Button button) {
        NetworkDispatcher.INSTANCE.sendToServer((Object)new PacketButtonClicked(PacketButtonClicked.ButtonType.WORK, this.blockPos));
    }

    public boolean shouldRenderRange() {
        return false;
    }

    public Component getRangeComponent() {
        int range = this.tileEntity != null ? this.tileEntity.getSelectedRange() : 0;
        return new TextComponent(String.format("%dx%d", range, range));
    }

    public void sendRangePacket(Button button) {
        NetworkDispatcher.INSTANCE.sendToServer((Object)new PacketButtonClicked(PacketButtonClicked.ButtonType.RANGE, this.blockPos));
    }

    public boolean m_6875_(Player playerEntity) {
        Level world;
        if (this.tileEntity != null && (world = this.tileEntity.m_58904_()) != null) {
            ContainerLevelAccess callable = ContainerLevelAccess.m_39289_((Level)world, (BlockPos)this.tileEntity.m_58899_());
            return AbstractPylonContainer.m_38889_((ContainerLevelAccess)callable, (Player)playerEntity, (Block)((Block)this.getBlock().get()));
        }
        return false;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        int inventorySize = this.getInventorySize();
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index < inventorySize ? !this.m_38903_(stack, inventorySize, this.f_38839_.size(), true) : !this.m_38903_(stack, 0, inventorySize, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void registerPlayerSlots(IItemHandler wrappedInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_((Slot)new SlotItemHandler(wrappedInventory, j + i * 9 + 9, 8 + j * 18, 90 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(wrappedInventory, i, 8 + i * 18, 148));
        }
    }
}

