/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ding.common;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ding")
public class Ding {
    public static final String MOD_ID = "ding";
    public static final String MOD_NAME = "Ding";
    private static final Logger LOGGER = LogManager.getLogger();
    public static Config config;
    private boolean ignoreFirst = true;
    private boolean hasLoadingGui = false;

    public Ding() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.setupConfig();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::finishLoading);
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> LOGGER.log(Level.ERROR, "You are loading Ding on a server. Ding is a client only mod!"));
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    private void setupConfig() {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        config = new Config(configBuilder);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)configBuilder.build(), "ding.toml");
    }

    private void finishLoading(FMLLoadCompleteEvent event) {
        EventHandler.postInit = true;
        if (((Boolean)Ding.config.playOnResourcesReload.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        }
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ((Boolean)Ding.config.playOnResourcesReload.get()).booleanValue()) {
            if (Minecraft.m_91087_().m_91265_() == null && this.hasLoadingGui) {
                if (this.ignoreFirst) {
                    this.ignoreFirst = false;
                } else if (((Boolean)Ding.config.playOnResourcesReload.get()).booleanValue()) {
                    Ding.playSound((String)Ding.config.nameResourcesReload.get(), ((Double)Ding.config.pitchResourcesReload.get()).floatValue(), (String)Ding.config.categoryResourcesReload.get());
                }
            }
            this.hasLoadingGui = Minecraft.m_91087_().m_91265_() != null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(String name, float pitch, String categoryName) {
        ResourceLocation rl = new ResourceLocation(name);
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
        SoundSource category = Ding.getCategoryByName(categoryName);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(sound == null ? rl : sound.m_11660_(), category, 0.25f, pitch, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        if (sound == null) {
            LOGGER.log(Level.WARN, "Could not find sound but attempted to play anyway: {}", (Object)rl);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SoundSource getCategoryByName(String name) {
        for (SoundSource value : SoundSource.values()) {
            if (!value.m_12676_().equals(name)) continue;
            return value;
        }
        return SoundSource.MASTER;
    }

    public class Config {
        public final ForgeConfigSpec.ConfigValue<String> name;
        public final ForgeConfigSpec.DoubleValue pitch;
        public final ForgeConfigSpec.ConfigValue<String> category;
        public final ForgeConfigSpec.ConfigValue<String> nameWorld;
        public final ForgeConfigSpec.DoubleValue pitchWorld;
        public final ForgeConfigSpec.ConfigValue<String> categoryWorld;
        public final ForgeConfigSpec.ConfigValue<String> nameResourcesReload;
        public final ForgeConfigSpec.DoubleValue pitchResourcesReload;
        public final ForgeConfigSpec.ConfigValue<String> categoryResourcesReload;
        public final ForgeConfigSpec.BooleanValue playOnLoad;
        public final ForgeConfigSpec.BooleanValue playOnWorld;
        public final ForgeConfigSpec.BooleanValue playOnResourcesReload;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Configs related to how ding works").push(Ding.MOD_ID);
            this.name = builder.comment("Resource Location based name of the sound file to play when Minecraft finishes loading.\nEG: \"ui.button.click\" or \"entity.experience_orb.pickup\"\n\nThis can also be a mod sound if the mod is installed.\nEG: \"modname:modsound.boing\"\n\nIf you want to use external sounds, consider looking into the mod Additional Resources").translation("config.ding.prop.name.desc").define("name", (Object)"entity.experience_orb.pickup");
            this.pitch = builder.comment("Pitch of the sound (when Minecraft loads)").translation("config.ding.prop.pitch.desc").defineInRange("pitch", 1.0, 0.0, 10.0);
            this.category = builder.comment("Sound category for the sound played when Minecraft finishes loading. EG: \"ambient\" or \"music\". Defaults to \"master\" if Ding cannot find your category.").translation("config.ding.prop.category.desc").define("category", (Object)"master");
            this.nameWorld = builder.comment("Resource Location based name of the sound file to play when the world finishes loading (after connecting to a server).\n\nLook at the \"name\" config for more details.").translation("config.ding.prop.nameWorld.desc").define("nameWorld", (Object)"entity.experience_orb.pickup");
            this.pitchWorld = builder.comment("Pitch of the sound (when the world loads after connecting to a server)").translation("config.ding.prop.pitchWorld.desc").defineInRange("pitchWorld", 1.0, 0.0, 10.0);
            this.categoryWorld = builder.comment("Sound category for the sound played when the world finishes loading (after connecting to a server). EG: \"ambient\" or \"music\". Defaults to \"master\" if Ding cannot find your category.").translation("config.ding.prop.categoryWorld.desc").define("categoryWorld", (Object)"master");
            this.nameResourcesReload = builder.comment("Resource Location based name of the sound file to play when resources complete reloading.\n\nLook at the \"name\" config for more details.").translation("config.ding.prop.nameResourcesReload.desc").define("nameResourcesReload", (Object)"entity.experience_orb.pickup");
            this.pitchResourcesReload = builder.comment("Pitch of the sound (when resources complete reloading)").translation("config.ding.prop.pitchResourcesReloadResourcesReload.desc").defineInRange("pitchResourcesReload", 1.0, 0.0, 10.0);
            this.categoryResourcesReload = builder.comment("Sound category for the sound played when resources complete reloading. EG: \"ambient\" or \"music\". Defaults to \"master\" if Ding cannot find your category.").translation("config.ding.prop.categoryResourcesReload.desc").define("categoryResourcesReload", (Object)"master");
            this.playOnLoad = builder.comment("Play sound when the game loads.").translation("config.ding.prop.playOnLoad.desc").define("playOnLoad", true);
            this.playOnWorld = builder.comment("Play sound when the world loads after connecting to a server.").translation("config.ding.prop.playOnWorld.desc").define("playOnWorld", false);
            this.playOnResourcesReload = builder.comment("Play sound when resources complete reloading. Requires game to be restarted.").translation("config.ding.prop.playOnResourcesReload.desc").define("playOnResourcesReload", true);
            builder.pop();
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class EventHandler {
        public static boolean postInit;
        public static boolean played;
        public static boolean playWorld;

        @SubscribeEvent
        public static void onGuiOpen(ScreenOpenEvent event) {
            if (postInit && event.getScreen() instanceof TitleScreen && !played) {
                played = true;
                if (((Boolean)Ding.config.playOnLoad.get()).booleanValue()) {
                    Ding.playSound((String)Ding.config.name.get(), ((Double)Ding.config.pitch.get()).floatValue(), (String)Ding.config.category.get());
                }
            }
        }

        @SubscribeEvent
        public static void onClientLoggedInEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
            playWorld = true;
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.WorldTickEvent event) {
            if (playWorld && event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91074_ != null && (Minecraft.m_91087_().f_91074_.f_19797_ > 20 || Minecraft.m_91087_().m_91104_())) {
                playWorld = false;
                if (((Boolean)Ding.config.playOnWorld.get()).booleanValue()) {
                    Ding.playSound((String)Ding.config.nameWorld.get(), ((Double)Ding.config.pitchWorld.get()).floatValue(), (String)Ding.config.categoryWorld.get());
                }
            }
        }
    }
}

