/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.controller.ControllerModule;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.router.RouterModule;
import mcjty.xnet.modules.wireless.WirelessRouterModule;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.NetworkChecker;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class XNetTOPDriver
implements TOPDriver {
    public static final XNetTOPDriver DRIVER = new XNetTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        Block block = blockState.m_60734_();
        ResourceLocation id = block.getRegistryName();
        if (!this.drivers.containsKey(id)) {
            if (block == CableModule.NETCABLE.get() || block == FacadeModule.FACADE.get()) {
                this.drivers.put(id, new CableDriver());
            } else if (block instanceof ConnectorBlock) {
                this.drivers.put(id, new ConnectorDriver());
            } else if (block == ControllerModule.CONTROLLER.get()) {
                this.drivers.put(id, new ControllerDriver());
            } else if (block == RouterModule.ROUTER.get()) {
                this.drivers.put(id, new RouterDriver());
            } else if (block == WirelessRouterModule.WIRELESS_ROUTER.get()) {
                this.drivers.put(id, new WirelessRouterDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class CableDriver
    extends DefaultDriver {
        private CableDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_8055_(data.getPos()).m_60734_(), block -> {
                WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
                if (mode == ProbeMode.DEBUG) {
                    Object colorId;
                    BlobId blobId = worldBlob.getBlobAt(data.getPos());
                    if (blobId != null) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Blob: ", (Object)blobId.id()));
                    }
                    if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Color: ", (Object)((ColorId)colorId).id()));
                    }
                }
                Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
                for (NetworkId network : networks) {
                    if (mode == ProbeMode.DEBUG) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Network: ", (Object)(network.id() + ", V: " + worldBlob.getNetworkVersion(network))));
                        continue;
                    }
                    probeInfo.text(CompoundText.createLabelInfo((String)"Network: ", (Object)network.id()));
                }
                ConsumerId consumerId = worldBlob.getConsumerAt(data.getPos());
                if (consumerId != null) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Consumer: ", (Object)consumerId.id()));
                }
            }, (String)"Bad block!");
        }
    }

    private static class ConnectorDriver
    extends CableDriver {
        private ConnectorDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                String name = te.getConnectorName();
                if (!name.isEmpty()) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Name: ", (Object)name));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class ControllerDriver
    extends DefaultDriver {
        private ControllerDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
                NetworkId networkId = te.getNetworkId();
                if (networkId != null) {
                    if (mode == ProbeMode.DEBUG) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Network: ", (Object)(networkId.id() + ", V: " + worldBlob.getNetworkVersion(networkId))));
                    } else {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Network: ", (Object)networkId.id()));
                    }
                }
                if (mode == ProbeMode.DEBUG) {
                    Object s = "";
                    for (NetworkId id : ((NetworkChecker)te.getNetworkChecker().get()).getAffectedNetworks()) {
                        if (((String)(s = (String)s + id.id() + " ")).length() <= 15) continue;
                        probeInfo.text(CompoundText.createLabelInfo((String)"InfNet: ", (Object)s));
                        s = "";
                    }
                    if (!((String)s).isEmpty()) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"InfNet: ", (Object)s));
                    }
                }
                if (((Boolean)blockState.m_61143_((Property)TileEntityController.ERROR)).booleanValue()) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Too many controllers on network!"));
                }
                if (mode == ProbeMode.DEBUG) {
                    ColorId colorId;
                    BlobId blobId = worldBlob.getBlobAt(data.getPos());
                    if (blobId != null) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Blob: ", (Object)blobId.id()));
                    }
                    if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Color: ", (Object)colorId.id()));
                    }
                    probeInfo.text(CompoundText.createLabelInfo((String)"Color mask: ", (Object)te.getColors()));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class RouterDriver
    extends DefaultDriver {
        private RouterDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                XNetBlobData blobData = XNetBlobData.get(world);
                WorldBlob worldBlob = blobData.getWorldBlob(world);
                Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
                for (NetworkId networkId : networks) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Network: ", (Object)networkId.id()));
                    if (mode == ProbeMode.EXTENDED) continue;
                    break;
                }
                if (((Boolean)blockState.m_61143_((Property)TileEntityController.ERROR)).booleanValue()) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Too many channels on router!"));
                } else {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Channels: ", (Object)te.getChannelCount()));
                }
                if (mode == ProbeMode.DEBUG) {
                    ColorId colorId;
                    BlobId blobId = worldBlob.getBlobAt(data.getPos());
                    if (blobId != null) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Blob: ", (Object)blobId.id()));
                    }
                    if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Color: ", (Object)colorId.id()));
                    }
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class WirelessRouterDriver
    extends DefaultDriver {
        private WirelessRouterDriver() {
        }

        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                XNetBlobData blobData = XNetBlobData.get(world);
                WorldBlob worldBlob = blobData.getWorldBlob(world);
                Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
                for (NetworkId networkId : networks) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Network: ", (Object)networkId.id()));
                    if (mode == ProbeMode.EXTENDED) continue;
                    break;
                }
                if (((Boolean)blockState.m_61143_((Property)TileEntityController.ERROR)).booleanValue()) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Missing antenna!"));
                }
                if (mode == ProbeMode.DEBUG) {
                    ColorId colorId;
                    BlobId blobId = worldBlob.getBlobAt(data.getPos());
                    if (blobId != null) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Blob: ", (Object)blobId.id()));
                    }
                    if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Color: ", (Object)colorId.id()));
                    }
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

