/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.StringUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;

public class AppEngApi {
    public static Pair<Long, AEItemKey> findAEStackFromItemStack(MEStorage monitor, ItemStack item) {
        Pair<Long, AEItemKey> stack = null;
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            AEItemKey key;
            Object object = temp.getKey();
            if (!(object instanceof AEItemKey) || !(key = (AEItemKey)object).matches(item)) continue;
            stack = Pair.of(temp.getLongValue(), key);
            break;
        }
        return stack;
    }

    public static List<Object> listStacks(MEStorage monitor, ICraftingService service, int flag) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object2LongMap.Entry aeKey : monitor.getAvailableStacks()) {
            Object object = aeKey.getKey();
            if (!(object instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)object;
            if (flag == 1 ? aeKey.getLongValue() < 0L : flag == 2 && !service.isCraftable((AEKey)itemKey)) continue;
            items.add(AppEngApi.getObjectFromStack(Pair.of(aeKey.getLongValue(), itemKey), service, flag));
        }
        return items;
    }

    public static List<Object> listFluids(MEStorage monitor, ICraftingService service, int flag) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object2LongMap.Entry aeKey : monitor.getAvailableStacks()) {
            Object object = aeKey.getKey();
            if (!(object instanceof AEFluidKey)) continue;
            AEFluidKey itemKey = (AEFluidKey)object;
            if (flag == 1 ? aeKey.getLongValue() < 0L : flag == 2 && !service.isCraftable((AEKey)itemKey)) continue;
            items.add(AppEngApi.getObjectFromStack(Pair.of(aeKey.getLongValue(), itemKey), service, flag));
        }
        return items;
    }

    public static Map<String, Object> getObjectFromStack(Pair<Long, AEKey> stack, ICraftingService service, int flag) {
        AEKey aEKey = stack.getRight();
        if (aEKey instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            return AppEngApi.getObjectFromItemStack(Pair.of(stack.getLeft(), itemKey), service, flag);
        }
        aEKey = stack.getRight();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            return AppEngApi.getObjectFromFluidStack(Pair.of(stack.getLeft(), fluidKey), service, flag);
        }
        AdvancedPeripherals.debug("Could not create table from unknown stack " + stack.getClass() + " - Report this to the owner", Level.ERROR);
        return null;
    }

    private static Map<String, Object> getObjectFromItemStack(Pair<Long, AEItemKey> stack, ICraftingService craftingService, int flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String displayName = stack.getRight().getDisplayName().getString();
        CompoundTag nbt = stack.getRight().toTag();
        long amount = stack.getLeft();
        map.put("fingerprint", AppEngApi.getFingerpint(stack.getRight()));
        map.put("name", stack.getRight().getItem().getRegistryName().toString());
        map.put("amount", amount);
        map.put("displayName", displayName);
        map.put("nbt", NBTUtil.toLua((Tag)nbt));
        map.put("tags", LuaConverter.tagsToList(stack.getRight().getItem().getTags()));
        map.put("isCraftable", craftingService.isCraftable((AEKey)stack.getRight()));
        if (flag == 0) {
            return map;
        }
        if (flag == 1 ? amount > 0L : flag == 2 && craftingService.isCraftable((AEKey)stack.getRight())) {
            return map;
        }
        return null;
    }

    private static Map<String, Object> getObjectFromFluidStack(Pair<Long, AEFluidKey> stack, ICraftingService craftingService, int flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long amount = stack.getLeft();
        map.put("name", stack.getRight().getFluid().getRegistryName().toString());
        map.put("amount", amount);
        map.put("displayName", stack.getRight().getDisplayName());
        map.put("tags", LuaConverter.tagsToList(stack.getRight().getFluid().getTags()));
        if (flag == 0) {
            return map;
        }
        if (flag == 1 ? amount > 0L : flag == 2 && craftingService.isCraftable((AEKey)stack.getRight())) {
            return map;
        }
        return null;
    }

    public static Map<String, Object> getObjectFromCPU(ICraftingCPU cpu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long storage = cpu.getAvailableStorage();
        int coProcessors = cpu.getCoProcessors();
        boolean isBusy = cpu.isBusy();
        map.put("storage", storage);
        map.put("coProcessors", coProcessors);
        map.put("isBusy", isBusy);
        return map;
    }

    public static Map<String, Object> getObjectFromJob(ICraftingPlan job, ICraftingService craftingService) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("item", AppEngApi.getObjectFromStack(Pair.of(job.finalOutput().amount(), job.finalOutput().what()), craftingService, 0));
        result.put("bytes", job.bytes());
        return result;
    }

    public static CompoundTag findMatchingTag(ItemStack stack, String nbtHash, MEStorage monitor) {
        for (Object2LongMap.Entry aeKey : monitor.getAvailableStacks()) {
            CompoundTag tag;
            String hash;
            Object object = aeKey.getKey();
            if (!(object instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)object;
            if (aeKey.getLongValue() <= 0L || itemKey.getItem() != stack.m_41720_() || !nbtHash.equals(hash = NBTUtil.getNBTHash((CompoundTag)(tag = itemKey.toStack().m_41783_())))) continue;
            return tag.m_6426_();
        }
        return null;
    }

    public static ItemStack findMatchingFingerprint(String fingerprint, MEStorage monitor) {
        for (Object2LongMap.Entry aeKey : monitor.getAvailableStacks()) {
            Object object = aeKey.getKey();
            if (!(object instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)object;
            if (aeKey.getLongValue() <= 0L || !fingerprint.equals(AppEngApi.getFingerpint(itemKey))) continue;
            return itemKey.toStack((int)aeKey.getLongValue());
        }
        return null;
    }

    public static String getFingerpint(AEItemKey itemStack) {
        ItemStack stack = itemStack.toStack();
        String fingerprint = stack.m_41784_() + stack.m_41720_().getRegistryName().toString() + stack.m_41611_().getString();
        try {
            byte[] bytesOfHash = fingerprint.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            return StringUtil.toHexString(md.digest(bytesOfHash));
        }
        catch (NoSuchAlgorithmException ex) {
            AdvancedPeripherals.debug("Could not parse fingerprint.", Level.ERROR);
            ex.printStackTrace();
            return "";
        }
    }

    public static MEStorage getMonitor(IGridNode node) {
        return ((IStorageService)node.getGrid().getService(IStorageService.class)).getInventory();
    }
}

