/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerDetectorPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String TYPE = "playerDetector";

    public PlayerDetectorPeripheral(PeripheralTileEntity<?> tileEntity) {
        super(TYPE, new BlockEntityPeripheralOwner(tileEntity));
    }

    public PlayerDetectorPeripheral(ITurtleAccess access, TurtleSide side) {
        super(TYPE, new TurtlePeripheralOwner(access, side));
    }

    public PlayerDetectorPeripheral(IPocketAccess pocket) {
        super(TYPE, new PocketPeripheralOwner(pocket));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_PLAYER_DETECTOR.get();
    }

    @LuaFunction(mainThread=true)
    public final String[] getOnlinePlayers() {
        return ServerLifecycleHooks.getCurrentServer().m_7641_();
    }

    @LuaFunction(mainThread=true)
    public final List<String> getPlayersInCoords(Map<?, ?> firstCoord, Map<?, ?> secondCoord) throws LuaException {
        ArrayList<String> playersName = new ArrayList<String>();
        BlockPos firstPos = LuaConverter.convertToBlockPos(firstCoord);
        BlockPos secondPos = LuaConverter.convertToBlockPos(secondCoord);
        for (ServerPlayer player : this.getPlayers()) {
            if (!CoordUtil.isInRange((Player)player, this.getLevel(), firstPos, secondPos)) continue;
            playersName.add(player.m_7755_().getString());
        }
        return playersName;
    }

    @LuaFunction(mainThread=true)
    public final List<String> getPlayersInCubic(int x, int y, int z) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (ServerPlayer player : this.getPlayers()) {
            if (!CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, x, y, z)) continue;
            playersName.add(player.m_7755_().getString());
        }
        return playersName;
    }

    @LuaFunction(mainThread=true)
    public final List<String> getPlayersInRange(int range) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (ServerPlayer player : this.getPlayers()) {
            if (!CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range)) continue;
            playersName.add(player.m_7755_().getString());
        }
        return playersName;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInCoords(Map<?, ?> firstCoord, Map<?, ?> secondCoord) throws LuaException {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        BlockPos firstPos = LuaConverter.convertToBlockPos(firstCoord);
        BlockPos secondPos = LuaConverter.convertToBlockPos(secondCoord);
        for (ServerPlayer player : this.getPlayers()) {
            if (!CoordUtil.isInRange((Player)player, this.getLevel(), firstPos, secondPos)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInCubic(int x, int y, int z) {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        for (ServerPlayer player : this.getPlayers()) {
            if (!CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, x, y, z)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInRange(int range) {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        for (ServerPlayer player : this.getPlayers()) {
            if (!CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInCoords(Map<?, ?> firstCoord, Map<?, ?> secondCoord, String username) throws LuaException {
        ArrayList<String> playersName = new ArrayList<String>();
        BlockPos firstPos = LuaConverter.convertToBlockPos(firstCoord);
        BlockPos secondPos = LuaConverter.convertToBlockPos(secondCoord);
        for (Player player : this.getPlayers()) {
            if (!CoordUtil.isInRange(player, this.getLevel(), firstPos, secondPos)) continue;
            playersName.add(player.m_7755_().getString());
        }
        return playersName.contains(username);
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInCubic(int x, int y, int z, String username) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (Player player : this.getPlayers()) {
            if (!CoordUtil.isInRange(this.getPos(), this.getLevel(), player, x, y, z)) continue;
            playersName.add(player.m_7755_().getString());
        }
        return playersName.contains(username);
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInRange(int range, String username) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (Player player : this.getPlayers()) {
            if (!CoordUtil.isInRange(this.getPos(), this.getLevel(), player, range)) continue;
            playersName.add(player.m_7755_().getString());
        }
        return playersName.contains(username);
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getPlayerPos(String username) throws LuaException {
        if (!((Boolean)APConfig.PERIPHERALS_CONFIG.PLAYER_SPY.get()).booleanValue()) {
            throw new LuaException("This function is disabled in the config. Activate it or ask an admin if he can activate it.");
        }
        ServerPlayer existingPlayer = null;
        for (ServerPlayer player : this.getPlayers()) {
            if (!player.m_7755_().getString().equals(username) || !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, (Integer)APConfig.PERIPHERALS_CONFIG.PLAYER_DET_MAX_RANGE.get())) continue;
            existingPlayer = player;
            break;
        }
        if (existingPlayer == null) {
            return null;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("x", Math.floor(existingPlayer.m_20185_()));
        info.put("y", Math.floor(existingPlayer.m_20186_()));
        info.put("z", Math.floor(existingPlayer.m_20189_()));
        if (((Boolean)APConfig.PERIPHERALS_CONFIG.MORE_PLAYER_INFORMATION.get()).booleanValue()) {
            info.put("yaw", Float.valueOf(existingPlayer.f_19859_));
            info.put("pitch", Float.valueOf(existingPlayer.f_19860_));
            info.put("dimension", existingPlayer.m_183503_().m_46472_().m_135782_().toString());
            info.put("eyeHeight", Float.valueOf(existingPlayer.m_20192_()));
        }
        return info;
    }

    private List<ServerPlayer> getPlayers() {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
    }
}

