/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.IRSAPI;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.StringUtil;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RefinedStorage {
    public static RefinedStorage instance;
    private final IRSAPI api = API.instance();

    public RefinedStorage() {
        this.initiate();
    }

    private static INetworkNode read(CompoundTag tag, NetworkNode node) {
        node.read(tag);
        return node;
    }

    public static Object listFluids(INetwork network) {
        ArrayList fluids = new ArrayList();
        RefinedStorage.getFluids(network).forEach(item -> fluids.add(RefinedStorage.getObjectFromFluid(item)));
        return fluids;
    }

    public static Object listItems(INetwork network) {
        ArrayList items = new ArrayList();
        RefinedStorage.getItems(network).forEach(item -> items.add(RefinedStorage.getObjectFromStack(item)));
        return items;
    }

    public static boolean isItemCraftable(INetwork network, ItemStack stack) {
        for (ItemStack craftableStack : RefinedStorage.getCraftableItems(network)) {
            if (!craftableStack.m_41656_(stack)) continue;
            return true;
        }
        return false;
    }

    public static int getMaxItemDiskStorage(INetwork network) {
        int total = 0;
        boolean creative = false;
        for (IStorage store : network.getItemStorageCache().getStorages()) {
            if (!(store instanceof IStorageDisk)) continue;
            int cap = ((IStorageDisk)store).getCapacity();
            if (cap > 0) {
                total += cap;
                continue;
            }
            creative = true;
        }
        return creative ? -1 : total;
    }

    public static int getMaxFluidDiskStorage(INetwork network) {
        int total = 0;
        boolean creative = false;
        for (IStorage store : network.getFluidStorageCache().getStorages()) {
            if (!(store instanceof IStorageDisk)) continue;
            int cap = ((IStorageDisk)store).getCapacity();
            if (cap > 0) {
                total += cap;
                continue;
            }
            creative = true;
        }
        return creative ? -1 : total;
    }

    public static int getMaxItemExternalStorage(INetwork network) {
        int total = 0;
        for (IStorage store : network.getItemStorageCache().getStorages()) {
            if (!(store instanceof IExternalStorage)) continue;
            total = (int)((long)total + ((IExternalStorage)store).getCapacity());
        }
        return total;
    }

    public static int getMaxFluidExternalStorage(INetwork network) {
        int total = 0;
        for (IStorage store : network.getFluidStorageCache().getStorages()) {
            if (!(store instanceof IExternalStorage)) continue;
            total = (int)((long)total + ((IExternalStorage)store).getCapacity());
        }
        return total;
    }

    public static Object getObjectFromPattern(ICraftingPattern pattern) {
        if (pattern == null) {
            return null;
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        NonNullList outputsList = pattern.getOutputs();
        ArrayList<Map<String, Object>> outputs = new ArrayList<Map<String, Object>>();
        for (ItemStack itemStack : outputsList) {
            outputs.add(RefinedStorage.getObjectFromStack(itemStack.m_41777_()));
        }
        map.put("outputs", outputs);
        List inputList = pattern.getInputs();
        ArrayList inputs = new ArrayList();
        for (List singleInputList : inputList) {
            ArrayList<Map<String, Object>> inputs1 = new ArrayList<Map<String, Object>>();
            for (ItemStack stack : singleInputList) {
                inputs1.add(RefinedStorage.getObjectFromStack(stack.m_41777_()));
            }
            inputs.add(inputs1);
        }
        NonNullList byproductsList = pattern.getByproducts();
        ArrayList<Map<String, Object>> byproducts = new ArrayList<Map<String, Object>>();
        for (ItemStack stack : byproductsList) {
            byproducts.add(RefinedStorage.getObjectFromStack(stack.m_41777_()));
        }
        map.put("inputs", inputs);
        map.put("outputs", outputs);
        map.put("byproducts", byproducts);
        map.put("processing", Boolean.valueOf(pattern.isProcessing()));
        return map;
    }

    public static Map<String, Object> getObjectFromStack(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        CompoundTag nbt = itemStack.m_41784_();
        Set tags = itemStack.m_41720_().getTags();
        map.put("fingerprint", RefinedStorage.getFingerpint(itemStack));
        map.put("name", itemStack.m_41720_().getRegistryName().toString());
        map.put("amount", itemStack.m_41613_());
        map.put("displayName", itemStack.m_41611_().getString());
        map.put("nbt", nbt.m_128456_() ? null : NBTUtil.toLua((Tag)nbt));
        map.put("tags", tags.isEmpty() ? null : LuaConverter.tagsToList(itemStack.m_41720_().getTags()));
        return map;
    }

    public static Map<String, Object> getObjectFromFluid(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set tags = fluidStack.getFluid().getTags();
        map.put("name", fluidStack.getFluid().getRegistryName().toString());
        map.put("amount", fluidStack.getAmount());
        map.put("displayName", fluidStack.getDisplayName().getString());
        map.put("tags", tags.isEmpty() ? null : LuaConverter.tagsToList(fluidStack.getFluid().getTags()));
        return map;
    }

    public static Object getItem(INetwork network, ItemStack item) {
        for (ItemStack itemStack : RefinedStorage.getItems(network)) {
            if (!itemStack.m_41656_(item) || !Objects.equals(itemStack.m_41784_(), item.m_41784_())) continue;
            return RefinedStorage.getObjectFromStack(itemStack);
        }
        return null;
    }

    public static List<ItemStack> getCraftableItems(INetwork network) {
        IStorageCache cache = network.getItemStorageCache();
        Collection craftableEntries = cache.getCraftablesList().getStacks();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(craftableEntries.size());
        for (StackListEntry entry : craftableEntries) {
            result.add((ItemStack)entry.getStack());
        }
        return result;
    }

    public static List<FluidStack> getCraftableFluids(INetwork network) {
        IStorageCache cache = network.getFluidStorageCache();
        Collection craftableEntries = cache.getCraftablesList().getStacks();
        ArrayList<FluidStack> result = new ArrayList<FluidStack>(craftableEntries.size());
        for (StackListEntry entry : craftableEntries) {
            result.add((FluidStack)entry.getStack());
        }
        return result;
    }

    public static List<ItemStack> getItems(INetwork network) {
        IStorageCache cache = network.getItemStorageCache();
        Collection entries = cache.getList().getStacks();
        Collection craftableEntries = cache.getCraftablesList().getStacks();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
        for (StackListEntry entry : entries) {
            result.add(((ItemStack)entry.getStack()).m_41777_());
        }
        for (StackListEntry entry : craftableEntries) {
            result.add(((ItemStack)entry.getStack()).m_41777_());
        }
        return result;
    }

    public static List<FluidStack> getFluids(INetwork network) {
        IStorageCache cache = network.getFluidStorageCache();
        Collection entries = cache.getList().getStacks();
        ArrayList<FluidStack> result = new ArrayList<FluidStack>(entries.size());
        for (StackListEntry entry : entries) {
            result.add(((FluidStack)entry.getStack()).copy());
        }
        return result;
    }

    public static CompoundTag findMatchingTag(ItemStack stack, String nbtHash, List<ItemStack> items) {
        for (ItemStack rsStack : items) {
            CompoundTag tag;
            String hash;
            if (rsStack.m_41613_() <= 0 || !rsStack.m_41720_().equals(stack.m_41720_()) || !nbtHash.equals(hash = NBTUtil.getNBTHash((CompoundTag)(tag = rsStack.m_41783_())))) continue;
            return tag.m_6426_();
        }
        return null;
    }

    public static ItemStack findMatchingFingerprint(String fingerprint, List<ItemStack> items) {
        for (ItemStack rsStack : items) {
            if (rsStack.m_41613_() <= 0 || !fingerprint.equals(RefinedStorage.getFingerpint(rsStack))) continue;
            return rsStack;
        }
        return ItemStack.f_41583_;
    }

    public static String getFingerpint(ItemStack stack) {
        String fingerprint = stack.m_41784_() + stack.m_41720_().getRegistryName().toString() + stack.m_41611_().getString();
        try {
            byte[] bytesOfHash = fingerprint.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            return StringUtil.toHexString(md.digest(bytesOfHash));
        }
        catch (NoSuchAlgorithmException ex) {
            AdvancedPeripherals.debug("Could not parse fingerprint.");
            ex.printStackTrace();
            return "";
        }
    }

    public void initiate() {
        this.api.getNetworkNodeRegistry().add(new ResourceLocation("advancedperipherals", "rs_bridge"), (tag, world, pos) -> RefinedStorage.read(tag, new RefinedStorageNode(world, pos)));
    }

    public IRSAPI getApi() {
        return this.api;
    }
}

