/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.events;

import com.google.common.collect.EvictingQueue;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.items.ARGogglesItem;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.network.MNetwork;
import de.srendi.advancedperipherals.network.messages.ClearHudCanvasMessage;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="advancedperipherals", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Events {
    private static final String PLAYED_BEFORE = "ap_played_before";
    private static final int CHAT_QUEUE_MAX_SIZE = 50;
    public static final EvictingQueue<Pair<Long, ChatMessageObject>> messageQueue = EvictingQueue.create((int)50);
    private static long lastChatMessageID = 0L;

    @SubscribeEvent
    public static void onWorldJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (((Boolean)APConfig.WORLD_CONFIG.GIVE_PLAYER_BOOK_ON_JOIN.get()).booleanValue() && !Events.hasPlayedBefore(player = event.getPlayer())) {
            ItemStack book = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book")));
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("patchouli:book", "advancedperipherals:manual");
            book.m_41751_(nbt);
            player.m_36356_(book);
        }
    }

    @SubscribeEvent
    public static void onChatBox(ServerChatEvent event) {
        if (((Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_CHAT_BOX.get()).booleanValue()) {
            String message = event.getMessage();
            boolean isHidden = false;
            if (message.startsWith("$")) {
                event.setCanceled(true);
                message = message.replace("$", "");
                isHidden = true;
            }
            Events.putChatMessage(Pair.of(Events.getLastChatMessageID(), new ChatMessageObject(event.getUsername(), message, event.getPlayer().m_142081_().toString(), isHidden)));
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (event.getFrom().m_41720_() instanceof ARGogglesItem) {
            MNetwork.sendTo(new ClearHudCanvasMessage(), player);
        }
    }

    public static synchronized void putChatMessage(Pair<Long, ChatMessageObject> message) {
        messageQueue.add(message);
        ++lastChatMessageID;
    }

    public static synchronized long traverseChatMessages(long lastConsumedMessage, Consumer<ChatMessageObject> consumer) {
        for (Pair message : messageQueue) {
            if ((Long)message.getLeft() <= lastConsumedMessage) continue;
            consumer.accept((ChatMessageObject)message.getRight());
            lastConsumedMessage = (Long)message.getLeft();
        }
        return lastConsumedMessage;
    }

    public static synchronized long getLastChatMessageID() {
        return lastChatMessageID;
    }

    private static boolean hasPlayedBefore(Player player) {
        CompoundTag tag = player.getPersistentData().m_128469_("PlayerPersisted");
        if (tag.m_128471_(PLAYED_BEFORE)) {
            return true;
        }
        tag.m_128379_(PLAYED_BEFORE, true);
        player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
        return false;
    }

    public static class ChatMessageObject {
        public String username;
        public String message;
        public String uuid;
        public boolean isHidden;

        public ChatMessageObject(String username, String message, String uuid, boolean isHidden) {
            this.username = username;
            this.message = message;
            this.uuid = uuid;
            this.isHidden = isHidden;
        }
    }
}

