/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.forge;

import architectury_inject_lightoverlay_common_8a3571216ab54284b2725f771eb23314_b4806a3d8614a28729408470a45c2ead90a92b12a037f2c235705865a47e535blightoverlay604devjar.PlatformMethods;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.lightoverlay.common.forge.CubicChunkPos;
import me.shedaniel.lightoverlay.common.forge.LightOverlay;
import me.shedaniel.lightoverlay.common.forge.LightOverlayTicker;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LightOverlayRenderer
implements Consumer<PoseStack> {
    private final Minecraft minecraft = Minecraft.m_91087_();
    public Frustum frustum;
    public LightOverlayTicker ticker;
    private static final Supplier<MethodHandle> IS_FRUSTUM_VISIBLE = Suppliers.memoize(() -> {
        try {
            return MethodHandles.lookup().findStatic(Class.forName("me.shedaniel.lightoverlay." + PlatformMethods.getCurrentTarget() + ".LightOverlayImpl"), "isFrustumVisible", MethodType.methodType(Boolean.TYPE, Frustum.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    });

    public LightOverlayRenderer(LightOverlayTicker ticker) {
        this.ticker = ticker;
    }

    @Override
    public void accept(PoseStack poses) {
        if (LightOverlay.enabled) {
            LocalPlayer playerEntity = this.minecraft.f_91074_;
            BlockPos playerPos = new BlockPos(playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_());
            int playerPosX = playerPos.m_123341_() >> 4;
            int playerPosY = playerPos.m_123342_() >> 5;
            int playerPosZ = playerPos.m_123343_() >> 4;
            CollisionContext collisionContext = CollisionContext.m_82750_((Entity)playerEntity);
            Camera camera = this.minecraft.f_91063_.m_109153_();
            int chunkRange = LightOverlay.getChunkRange();
            if (LightOverlay.showNumber) {
                this.renderLevels(new PoseStack(), camera, playerPos, playerPosX, playerPosY, playerPosZ, chunkRange, collisionContext);
            } else {
                this.renderCrosses(poses, camera, playerPos, playerPosX, playerPosY, playerPosZ, chunkRange, collisionContext);
            }
        }
    }

    private void renderLevels(PoseStack poses, Camera camera, BlockPos playerPos, int playerPosX, int playerPosY, int playerPosZ, int chunkRange, CollisionContext collisionContext) {
        RenderSystem.m_69493_();
        RenderSystem.m_69458_((boolean)true);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos downMutable = new BlockPos.MutableBlockPos();
        MultiBufferSource.BufferSource source = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        for (Map.Entry<CubicChunkPos, Long2ByteMap> entry : this.ticker.CHUNK_MAP.entrySet()) {
            CubicChunkPos chunkPos = entry.getKey();
            if (LightOverlay.caching && (Mth.m_14040_((int)(chunkPos.x - playerPosX)) > chunkRange || Mth.m_14040_((int)(chunkPos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || Mth.m_14040_((int)(chunkPos.z - playerPosZ)) > chunkRange)) continue;
            for (Long2ByteMap.Entry objectEntry : entry.getValue().long2ByteEntrySet()) {
                mutable.m_122188_(objectEntry.getLongKey());
                if (!mutable.m_123314_((Vec3i)playerPos, (double)LightOverlay.reach) || !this.isFrustumVisible(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), mutable.m_123341_() + 1, mutable.m_123341_() + 1, mutable.m_123341_() + 1)) continue;
                downMutable.m_122178_(mutable.m_123341_(), mutable.m_123342_() - 1, mutable.m_123343_());
                this.renderLevel(poses, source, camera, (Level)this.minecraft.f_91073_, (BlockPos)mutable, (BlockPos)downMutable, objectEntry.getByteValue(), collisionContext);
            }
        }
        RenderSystem.m_69482_();
        source.m_109911_();
    }

    public void renderLevel(PoseStack poses, MultiBufferSource.BufferSource source, Camera camera, Level world, BlockPos pos, BlockPos down, byte level, CollisionContext collisionContext) {
        String text = String.valueOf(level);
        Font font = this.minecraft.f_91062_;
        double cameraX = camera.m_90583_().f_82479_;
        double cameraY = camera.m_90583_().f_82480_;
        VoxelShape upperOutlineShape = world.m_8055_(down).m_60651_((BlockGetter)world, down, collisionContext);
        if (!upperOutlineShape.m_83281_()) {
            cameraY += 1.0 - upperOutlineShape.m_83297_(Direction.Axis.Y);
        }
        double cameraZ = camera.m_90583_().f_82481_;
        poses.m_85836_();
        poses.m_85837_((double)pos.m_123341_() + 0.5 - cameraX, (double)pos.m_123342_() - cameraY + 0.005, (double)pos.m_123343_() + 0.5 - cameraZ);
        poses.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        float size = 0.07f;
        poses.m_85841_(-size, -size, size);
        float float_3 = (float)(-font.m_92895_(text)) / 2.0f + 0.4f;
        font.m_92811_(text, float_3, -3.5f, level > LightOverlay.higherCrossLevel ? -16505852 : (LightOverlay.lowerCrossLevel >= 0 && level > LightOverlay.lowerCrossLevel ? -16750849 : -9236207), false, poses.m_85850_().m_85861_(), (MultiBufferSource)source, false, 0, 0xF000F0);
        poses.m_85849_();
    }

    private void renderCrosses(PoseStack poses, Camera camera, BlockPos playerPos, int playerPosX, int playerPosY, int playerPosZ, int chunkRange, CollisionContext collisionContext) {
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69461_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69832_((float)LightOverlay.lineWidth);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Map.Entry<CubicChunkPos, Long2ByteMap> entry : this.ticker.CHUNK_MAP.entrySet()) {
            CubicChunkPos chunkPos = entry.getKey();
            if (LightOverlay.caching && (Mth.m_14040_((int)(chunkPos.x - playerPosX)) > chunkRange || Mth.m_14040_((int)(chunkPos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || Mth.m_14040_((int)(chunkPos.z - playerPosZ)) > chunkRange)) continue;
            for (Long2ByteMap.Entry objectEntry : entry.getValue().long2ByteEntrySet()) {
                byte crossType = objectEntry.getByteValue();
                mutable.m_122188_(objectEntry.getLongKey());
                if (!mutable.m_123314_((Vec3i)playerPos, (double)LightOverlay.reach) || !this.isFrustumVisible(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), mutable.m_123341_() + 1, mutable.m_123341_() + 1, mutable.m_123341_() + 1)) continue;
                int color = switch (crossType) {
                    case 1 -> LightOverlay.redColor;
                    case 0 -> LightOverlay.yellowColor;
                    default -> LightOverlay.secondaryColor;
                };
                this.renderCross(poses.m_85850_().m_85861_(), builder, camera, (Level)this.minecraft.f_91073_, (BlockPos)mutable, color, collisionContext);
            }
        }
        tesselator.m_85914_();
        RenderSystem.m_69832_((float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
    }

    public void renderCross(Matrix4f pose, BufferBuilder builder, Camera camera, Level world, BlockPos pos, int color, CollisionContext collisionContext) {
        double cameraX = camera.m_90583_().f_82479_;
        double cameraY = camera.m_90583_().f_82480_ - 0.005;
        double blockOffset = 0.0;
        VoxelShape upperOutlineShape = world.m_8055_(pos).m_60651_((BlockGetter)world, pos, collisionContext);
        if (!upperOutlineShape.m_83281_()) {
            blockOffset += upperOutlineShape.m_83297_(Direction.Axis.Y);
        }
        double cameraZ = camera.m_90583_().f_82481_;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        double x = (double)pos.m_123341_() - cameraX;
        double y = (double)pos.m_123342_() - cameraY + blockOffset;
        double z = (double)pos.m_123343_() - cameraZ;
        builder.m_5483_(x + 0.01, y, z + 0.01).m_6122_(red, green, blue, 255).m_5752_();
        builder.m_5483_(x + 0.99, y, z + 0.99).m_6122_(red, green, blue, 255).m_5752_();
        builder.m_5483_(x + 0.99, y, z + 0.01).m_6122_(red, green, blue, 255).m_5752_();
        builder.m_5483_(x + 0.01, y, z + 0.99).m_6122_(red, green, blue, 255).m_5752_();
    }

    public boolean isFrustumVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            return this.frustum == null || IS_FRUSTUM_VISIBLE.get().invokeExact(this.frustum, minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

