/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.forge;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import me.shedaniel.lightoverlay.common.forge.CubicChunkPos;
import me.shedaniel.lightoverlay.common.forge.LightOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;

public class LightOverlayTicker {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private long ticks = 0L;
    private static int threadNumber = 0;
    private static final ThreadPoolExecutor EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
        Thread thread = new Thread(r, "light-overlay-" + threadNumber++);
        thread.setDaemon(true);
        return thread;
    });
    public final Set<CubicChunkPos> POS = Collections.synchronizedSet(new HashSet());
    public final Set<CubicChunkPos> CALCULATING_POS = Collections.synchronizedSet(new HashSet());
    public final Map<CubicChunkPos, Long2ByteMap> CHUNK_MAP = Maps.newConcurrentMap();
    private static final Supplier<EntityType<Entity>> TESTING_ENTITY_TYPE = Suppliers.memoize(() -> EntityType.Builder.m_20710_((MobCategory)MobCategory.MONSTER).m_20699_(0.0f, 0.0f).m_20716_().m_20712_(null));

    public void queueChunk(CubicChunkPos pos) {
        if (LightOverlay.enabled && LightOverlay.caching && !this.CALCULATING_POS.contains(pos)) {
            this.POS.add(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(Minecraft minecraft) {
        block21: {
            while (LightOverlay.enableOverlay.m_90859_()) {
                LightOverlay.enabled = !LightOverlay.enabled;
            }
            try {
                ++this.ticks;
                if (minecraft.f_91074_ == null || !LightOverlay.enabled) {
                    this.POS.clear();
                    this.CALCULATING_POS.clear();
                    EXECUTOR.getQueue().clear();
                    this.CHUNK_MAP.clear();
                    break block21;
                }
                LocalPlayer player = minecraft.f_91074_;
                ClientLevel world = minecraft.f_91073_;
                CollisionContext collisionContext = CollisionContext.m_82750_((Entity)player);
                if (!LightOverlay.caching) {
                    this.CALCULATING_POS.clear();
                    this.POS.clear();
                    this.CHUNK_MAP.clear();
                    BlockPos playerPos = player.m_142538_();
                    LayerLightEventListener block = world.m_5518_().m_75814_(LightLayer.BLOCK);
                    LayerLightEventListener sky = LightOverlay.showNumber ? null : world.m_5518_().m_75814_(LightLayer.SKY);
                    BlockPos.MutableBlockPos downPos = new BlockPos.MutableBlockPos();
                    Iterable iterate = BlockPos.m_121976_((int)(playerPos.m_123341_() - LightOverlay.reach), (int)(playerPos.m_123342_() - LightOverlay.reach), (int)(playerPos.m_123343_() - LightOverlay.reach), (int)(playerPos.m_123341_() + LightOverlay.reach), (int)(playerPos.m_123342_() + LightOverlay.reach), (int)(playerPos.m_123343_() + LightOverlay.reach));
                    Long2ByteOpenHashMap chunkData = new Long2ByteOpenHashMap();
                    this.CHUNK_MAP.put(new CubicChunkPos(0, 0, 0), (Long2ByteMap)chunkData);
                    for (BlockPos blockPos : iterate) {
                        downPos.m_122178_(blockPos.m_123341_(), blockPos.m_123342_() - 1, blockPos.m_123343_());
                        if (LightOverlay.showNumber) {
                            int level = LightOverlayTicker.getCrossLevel(blockPos, (BlockPos)downPos, (BlockGetter)world, block, collisionContext);
                            if (level < 0) continue;
                            chunkData.put(blockPos.m_121878_(), (byte)level);
                            continue;
                        }
                        Biome biome = !LightOverlay.mushroom ? world.m_46857_(blockPos) : null;
                        byte type = this.getCrossType(blockPos, biome, (BlockPos)downPos, (BlockGetter)world, block, sky, collisionContext);
                        if (type == 3) continue;
                        chunkData.put(blockPos.m_121878_(), type);
                    }
                    break block21;
                }
                int height = Mth.m_14165_((double)((double)Minecraft.m_91087_().f_91073_.m_141928_() / 32.0));
                int start = Math.floorDiv(Minecraft.m_91087_().f_91073_.m_141937_(), 32);
                int playerPosX = (int)player.m_20185_() >> 4;
                int playerPosY = (int)player.m_20186_() >> 5;
                int playerPosZ = (int)player.m_20189_() >> 4;
                int chunkRange = LightOverlay.getChunkRange();
                for (int chunkX = playerPosX - chunkRange; chunkX <= playerPosX + chunkRange; ++chunkX) {
                    for (int chunkY = Math.max(playerPosY - Math.max(1, chunkRange >> 1), start); chunkY <= playerPosY + Math.max(1, chunkRange >> 1) && chunkY <= start + height; ++chunkY) {
                        for (int chunkZ = playerPosZ - chunkRange; chunkZ <= playerPosZ + chunkRange; ++chunkZ) {
                            CubicChunkPos chunkPos;
                            if (Mth.m_14040_((int)(chunkX - playerPosX)) > chunkRange || Mth.m_14040_((int)(chunkY - playerPosY)) > chunkRange || Mth.m_14040_((int)(chunkZ - playerPosZ)) > chunkRange || this.CHUNK_MAP.containsKey(chunkPos = new CubicChunkPos(chunkX, chunkY, chunkZ))) continue;
                            this.queueChunk(chunkPos);
                        }
                    }
                }
                for (int p = 0; p < 3 && EXECUTOR.getQueue().size() < Runtime.getRuntime().availableProcessors(); ++p) {
                    double d1 = Double.MAX_VALUE;
                    double d2 = Double.MAX_VALUE;
                    double d3 = Double.MAX_VALUE;
                    CubicChunkPos c1 = null;
                    CubicChunkPos c2 = null;
                    CubicChunkPos c3 = null;
                    Set<CubicChunkPos> set = this.POS;
                    synchronized (set) {
                        Iterator<CubicChunkPos> iterator = this.POS.iterator();
                        while (iterator.hasNext()) {
                            int dz;
                            int dy;
                            CubicChunkPos pos = iterator.next();
                            if (Mth.m_14040_((int)(pos.x - playerPosX)) > chunkRange || Mth.m_14040_((int)(pos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || Mth.m_14040_((int)(pos.z - playerPosZ)) > chunkRange || this.CALCULATING_POS.contains(pos)) {
                                iterator.remove();
                                continue;
                            }
                            if (!LightOverlay.renderer.isFrustumVisible(pos.getMinBlockX(), pos.getMinBlockY(), pos.getMinBlockZ(), pos.getMaxBlockX(), pos.getMaxBlockY(), pos.getMaxBlockZ())) continue;
                            int dx = Math.abs(pos.x - playerPosX);
                            double distance = Math.sqrt(dx * dx + (dy = Math.abs(pos.y - playerPosY) << 1) * dy + (dz = Math.abs(pos.z - playerPosZ)) * dz);
                            if (distance < d1) {
                                d3 = d2;
                                d2 = d1;
                                d1 = distance;
                                c3 = c2;
                                c2 = c1;
                                c1 = pos;
                                continue;
                            }
                            if (distance < d2) {
                                d3 = d2;
                                d2 = distance;
                                c3 = c2;
                                c2 = pos;
                                continue;
                            }
                            if (!(distance < d3)) continue;
                            d3 = distance;
                            c3 = pos;
                        }
                    }
                    CubicChunkPos finalC1 = c1;
                    CubicChunkPos finalC2 = c2;
                    CubicChunkPos finalC3 = c3;
                    if (finalC1 == null) continue;
                    this.CALCULATING_POS.add(finalC1);
                    this.POS.remove(finalC1);
                    if (finalC2 != null) {
                        this.CALCULATING_POS.add(finalC2);
                        this.POS.remove(finalC2);
                        if (finalC3 != null) {
                            this.CALCULATING_POS.add(finalC3);
                            this.POS.remove(finalC3);
                        }
                    }
                    EXECUTOR.submit(() -> {
                        int playerPosX1 = (int)minecraft.f_91074_.m_20185_() >> 4;
                        int playerPosY1 = (int)minecraft.f_91074_.m_20186_() >> 5;
                        int playerPosZ1 = (int)minecraft.f_91074_.m_20189_() >> 4;
                        if (finalC1 != null) {
                            this.processChunk(finalC1, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                        if (finalC2 != null) {
                            this.processChunk(finalC2, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                        if (finalC3 != null) {
                            this.processChunk(finalC3, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                    });
                }
                if (this.ticks % 50L == 0L) {
                    this.CHUNK_MAP.entrySet().removeIf(entry -> Mth.m_14040_((int)(((CubicChunkPos)entry.getKey()).x - playerPosX)) > chunkRange * 2 || Mth.m_14040_((int)(((CubicChunkPos)entry.getKey()).y - playerPosY)) > chunkRange * 2 || Mth.m_14040_((int)(((CubicChunkPos)entry.getKey()).z - playerPosZ)) > chunkRange * 2);
                }
            }
            catch (Throwable throwable) {
                LogManager.getLogger().throwing(throwable);
            }
        }
    }

    private void processChunk(CubicChunkPos pos, int playerPosX, int playerPosY, int playerPosZ, CollisionContext context) {
        this.CALCULATING_POS.remove(pos);
        int chunkRange = LightOverlay.getChunkRange();
        if (Mth.m_14040_((int)(pos.x - playerPosX)) > chunkRange || Mth.m_14040_((int)(pos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || Mth.m_14040_((int)(pos.z - playerPosZ)) > chunkRange || this.POS.contains(pos)) {
            return;
        }
        try {
            this.calculateChunk(this.minecraft.f_91073_.m_7726_().m_7587_(pos.x, pos.z, ChunkStatus.f_62326_, false), (Level)this.minecraft.f_91073_, pos, context);
        }
        catch (Throwable throwable) {
            LogManager.getLogger().throwing(throwable);
        }
    }

    private void calculateChunk(LevelChunk chunk, Level world, CubicChunkPos chunkPos, CollisionContext collisionContext) {
        if (world != null && chunk != null) {
            Long2ByteOpenHashMap chunkData = new Long2ByteOpenHashMap();
            LayerLightEventListener block = world.m_5518_().m_75814_(LightLayer.BLOCK);
            LayerLightEventListener sky = LightOverlay.showNumber ? null : world.m_5518_().m_75814_(LightLayer.SKY);
            for (BlockPos pos : BlockPos.m_121976_((int)chunkPos.getMinBlockX(), (int)chunkPos.getMinBlockY(), (int)chunkPos.getMinBlockZ(), (int)chunkPos.getMaxBlockX(), (int)chunkPos.getMaxBlockY(), (int)chunkPos.getMaxBlockZ())) {
                BlockPos down = pos.m_7495_();
                if (LightOverlay.showNumber) {
                    int level = LightOverlayTicker.getCrossLevel(pos, down, (BlockGetter)chunk, block, collisionContext);
                    if (level < 0) continue;
                    chunkData.put(pos.m_121878_(), (byte)level);
                    continue;
                }
                Biome biome = !LightOverlay.mushroom ? world.m_46857_(pos) : null;
                byte type = this.getCrossType(pos, biome, down, (BlockGetter)chunk, block, sky, collisionContext);
                if (type == 3) continue;
                chunkData.put(pos.m_121878_(), type);
            }
            this.CHUNK_MAP.put(chunkPos, (Long2ByteMap)chunkData);
        } else {
            this.CHUNK_MAP.remove(chunkPos);
        }
    }

    public byte getCrossType(BlockPos pos, Biome biome, BlockPos down, BlockGetter world, LayerLightEventListener block, LayerLightEventListener sky, CollisionContext entityContext) {
        BlockState blockBelowState = world.m_8055_(down);
        BlockState blockUpperState = world.m_8055_(pos);
        VoxelShape upperCollisionShape = blockUpperState.m_60742_(world, pos, entityContext);
        if (!LightOverlay.underwater && !blockUpperState.m_60819_().m_76178_()) {
            return 3;
        }
        if (Block.m_49918_((VoxelShape)upperCollisionShape, (Direction)Direction.UP)) {
            return 3;
        }
        if (blockUpperState.m_60803_()) {
            return 3;
        }
        if (upperCollisionShape.m_83297_(Direction.Axis.Y) > 0.0) {
            return 3;
        }
        if (blockUpperState.m_60620_((Tag)BlockTags.f_13034_)) {
            return 3;
        }
        if (!blockBelowState.m_60643_(world, down, TESTING_ENTITY_TYPE.get())) {
            return 3;
        }
        if (!LightOverlay.mushroom && Biome.BiomeCategory.MUSHROOM == biome.m_47567_()) {
            return 3;
        }
        int blockLightLevel = block.m_7768_(pos);
        int skyLightLevel = sky.m_7768_(pos);
        if (blockLightLevel > LightOverlay.higherCrossLevel) {
            return 3;
        }
        if (skyLightLevel > LightOverlay.higherCrossLevel) {
            return LightOverlay.higherCross;
        }
        return LightOverlay.lowerCrossLevel >= 0 && blockLightLevel > LightOverlay.lowerCrossLevel ? LightOverlay.lowerCross : (byte)1;
    }

    public static int getCrossLevel(BlockPos pos, BlockPos down, BlockGetter world, LayerLightEventListener view, CollisionContext collisionContext) {
        BlockState blockBelowState = world.m_8055_(down);
        BlockState blockUpperState = world.m_8055_(pos);
        VoxelShape collisionShape = blockBelowState.m_60742_(world, down, collisionContext);
        VoxelShape upperCollisionShape = blockUpperState.m_60742_(world, pos, collisionContext);
        if (!LightOverlay.underwater && !blockUpperState.m_60819_().m_76178_()) {
            return -1;
        }
        if (!blockBelowState.m_60819_().m_76178_()) {
            return -1;
        }
        if (blockBelowState.m_60795_()) {
            return -1;
        }
        if (Block.m_49918_((VoxelShape)upperCollisionShape, (Direction)Direction.DOWN)) {
            return -1;
        }
        return view.m_7768_(pos);
    }
}

