/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.forge.mixin;

import me.shedaniel.lightoverlay.common.forge.CubicChunkPos;
import me.shedaniel.lightoverlay.common.forge.LightOverlay;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public class MixinClientConnection {
    @Inject(method={"genericsFtw"}, at={@At(value="HEAD")})
    private static void handlePacket(Packet packet, PacketListener listener, CallbackInfo ci) {
        try {
            PacketListener packetListener = listener;
            if (!(packetListener instanceof ClientPacketListener)) {
                return;
            }
            ClientPacketListener packetListener2 = (ClientPacketListener)packetListener;
            ClientLevel level = packetListener2.m_105147_();
            if (level == null) {
                return;
            }
            Packet packet2 = packet;
            if (packet2 instanceof ClientboundBlockUpdatePacket) {
                ClientboundBlockUpdatePacket p = (ClientboundBlockUpdatePacket)packet2;
                LightOverlay.queueChunkAndNear(new CubicChunkPos(p.m_131749_()));
            } else {
                packet2 = packet;
                if (packet2 instanceof ClientboundSetChunkCacheCenterPacket) {
                    int start;
                    ClientboundSetChunkCacheCenterPacket p = (ClientboundSetChunkCacheCenterPacket)packet2;
                    int height = Mth.m_14165_((double)((double)level.m_141928_() / 32.0));
                    for (int y = start = Math.floorDiv(level.m_141937_(), 32); y < start + height; ++y) {
                        LightOverlay.queueChunkAndNear(new CubicChunkPos(p.m_133094_(), y, p.m_133097_()));
                    }
                } else {
                    Packet height = packet;
                    if (height instanceof ClientboundSectionBlocksUpdatePacket) {
                        ClientboundSectionBlocksUpdatePacket p = (ClientboundSectionBlocksUpdatePacket)height;
                        LightOverlay.queueChunkAndNear(new CubicChunkPos(p.f_132980_.m_123341_(), p.f_132980_.m_123342_() >> 1, p.f_132980_.m_123343_()));
                    } else {
                        height = packet;
                        if (height instanceof ClientboundLightUpdatePacket) {
                            int start;
                            ClientboundLightUpdatePacket p = (ClientboundLightUpdatePacket)height;
                            int height2 = Mth.m_14165_((double)((double)level.m_141928_() / 32.0));
                            for (int y = start = Math.floorDiv(level.m_141937_(), 32); y < start + height2; ++y) {
                                LightOverlay.queueChunk(new CubicChunkPos(p.m_132349_(), y, p.m_132352_()));
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            new RuntimeException("Light Overlay failed to process packet", throwable).printStackTrace();
        }
    }
}

