/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import ironfurnaces.container.BlockIronFurnaceContainerBase;
import ironfurnaces.network.Messages;
import ironfurnaces.network.PacketSettingsButton;
import ironfurnaces.network.PacketShowSettingsButton;
import ironfurnaces.util.StringHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BlockIronFurnaceScreenBase<T extends BlockIronFurnaceContainerBase>
extends AbstractContainerScreen<T> {
    public ResourceLocation GUI = new ResourceLocation("ironfurnaces:textures/gui/furnace.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("ironfurnaces:textures/gui/widgets.png");
    Inventory playerInv;
    Component name;
    public boolean add_button;
    public boolean sub_button;

    public BlockIronFurnaceScreenBase(T t, Inventory inv, Component name) {
        super(t, inv, name);
        this.playerInv = inv;
        this.name = name;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.m_7025_(matrix, mouseX, mouseY);
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        this.f_96541_.f_91062_.m_92889_(matrix, this.playerInv.m_5446_(), 7.0f, (float)(this.getYSize() - 93), 0x404040);
        this.f_96541_.f_91062_.m_92889_(matrix, this.name, (float)(7 + this.getXSize() / 2 - this.f_96541_.f_91062_.m_92895_(this.name.getString()) / 2), 6.0f, 0x404040);
        if (((BlockIronFurnaceContainerBase)this.m_6262_()).showInventoryButtons() && ((BlockIronFurnaceContainerBase)this.m_6262_()).getRedstoneMode() == 4) {
            int comSub = ((BlockIronFurnaceContainerBase)this.m_6262_()).getComSub();
            int i = comSub > 9 ? 28 : 31;
            this.f_96541_.f_91062_.m_92889_(matrix, (Component)new TextComponent("" + comSub), (float)(i - 42), 90.0f, 0x404040);
        }
        int actualMouseX = mouseX - (this.f_96543_ - this.getXSize()) / 2;
        int actualMouseY = mouseY - (this.f_96544_ - this.getYSize()) / 2;
        this.addTooltips(matrix, actualMouseX, actualMouseY);
        if (actualMouseX >= 26 && actualMouseX <= 42 && actualMouseY >= 35 && actualMouseY <= 51 && !((BlockIronFurnaceContainerBase)this.m_6262_()).m_38853_(3).m_6657_()) {
            this.m_96602_(matrix, (Component)new TranslatableComponent("tooltip.ironfurnaces.augment_slot"), actualMouseX, actualMouseY);
        }
    }

    private void addTooltips(PoseStack matrix, int mouseX, int mouseY) {
        if (!((BlockIronFurnaceContainerBase)this.m_6262_()).showInventoryButtons()) {
            if (mouseX >= -20 && mouseX <= 0 && mouseY >= 4 && mouseY <= 26) {
                this.m_96602_(matrix, (Component)new TranslatableComponent("tooltip.ironfurnaces.gui_open"), mouseX, mouseY);
            }
        } else if (mouseX >= -13 && mouseX <= 0 && mouseY >= 4 && mouseY <= 26) {
            this.m_96597_(matrix, StringHelper.getShiftInfoGui(), mouseX, mouseY);
        } else if (mouseX >= -47 && mouseX <= -34 && mouseY >= 12 && mouseY <= 25) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_auto_input"));
            list.add(new TextComponent("" + ((BlockIronFurnaceContainerBase)this.m_6262_()).getAutoInput()));
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -29 && mouseX <= -16 && mouseY >= 12 && mouseY <= 25) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_auto_output"));
            list.add(new TextComponent("" + ((BlockIronFurnaceContainerBase)this.m_6262_()).getAutoOutput()));
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -32 && mouseX <= -23 && mouseY >= 31 && mouseY <= 40) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_top"));
            list.add(((BlockIronFurnaceContainerBase)this.m_6262_()).getTooltip(1));
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -32 && mouseX <= -23 && mouseY >= 55 && mouseY <= 64) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_bottom"));
            list.add(((BlockIronFurnaceContainerBase)this.m_6262_()).getTooltip(0));
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -32 && mouseX <= -23 && mouseY >= 43 && mouseY <= 52) {
            ArrayList list = Lists.newArrayList();
            if (BlockIronFurnaceScreenBase.isShiftKeyDown()) {
                list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_reset"));
            } else {
                list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_front"));
                list.add(((BlockIronFurnaceContainerBase)this.m_6262_()).getTooltip(((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexFront()));
            }
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -44 && mouseX <= -35 && mouseY >= 43 && mouseY <= 52) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_left"));
            list.add(((BlockIronFurnaceContainerBase)this.m_6262_()).getTooltip(((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexLeft()));
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -20 && mouseX <= -11 && mouseY >= 43 && mouseY <= 52) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_right"));
            list.add(((BlockIronFurnaceContainerBase)this.m_6262_()).getTooltip(((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexRight()));
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -20 && mouseX <= -11 && mouseY >= 55 && mouseY <= 64) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_back"));
            list.add(((BlockIronFurnaceContainerBase)this.m_6262_()).getTooltip(((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexBack()));
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -47 && mouseX <= -34 && mouseY >= 70 && mouseY <= 83) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_redstone_ignored"));
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -31 && mouseX <= -18 && mouseY >= 70 && mouseY <= 83) {
            ArrayList list = Lists.newArrayList();
            if (BlockIronFurnaceScreenBase.isShiftKeyDown()) {
                list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_redstone_low"));
            } else {
                list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_redstone_high"));
            }
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -15 && mouseX <= -2 && mouseY >= 70 && mouseY <= 83) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_redstone_comparator"));
            this.m_96597_(matrix, list, mouseX, mouseY);
        } else if (mouseX >= -47 && mouseX <= -34 && mouseY >= 86 && mouseY <= 99) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("tooltip.ironfurnaces.gui_redstone_comparator_sub"));
            this.m_96597_(matrix, list, mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        int i;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.getXSize()) / 2;
        int relY = (this.f_96544_ - this.getYSize()) / 2;
        this.m_93228_(matrix, relX, relY, 0, 0, this.getXSize(), this.getYSize());
        if (((BlockIronFurnaceContainerBase)this.m_6262_()).isBurning()) {
            i = ((BlockIronFurnaceContainerBase)this.m_6262_()).getBurnLeftScaled(13);
            this.m_93228_(matrix, this.getGuiLeft() + 56, this.getGuiTop() + 36 + 12 - i, 176, 12 - i, 14, i + 1);
        }
        i = ((BlockIronFurnaceContainerBase)this.m_6262_()).getCookScaled(24);
        this.m_93228_(matrix, this.getGuiLeft() + 79, this.getGuiTop() + 34, 176, 14, i + 1, 16);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
        int actualMouseX = mouseX - (this.f_96543_ - this.getXSize()) / 2;
        int actualMouseY = mouseY - (this.f_96544_ - this.getYSize()) / 2;
        this.addInventoryButtons(matrix, actualMouseX, actualMouseY);
        this.addRedstoneButtons(matrix, actualMouseX, actualMouseY);
    }

    private void addRedstoneButtons(PoseStack matrix, int mouseX, int mouseY) {
        if (((BlockIronFurnaceContainerBase)this.m_6262_()).showInventoryButtons()) {
            this.blitRedstone(matrix);
            if (((BlockIronFurnaceContainerBase)this.m_6262_()).getRedstoneMode() == 4) {
                int comSub = ((BlockIronFurnaceContainerBase)this.m_6262_()).getComSub();
                boolean flag = BlockIronFurnaceScreenBase.isShiftKeyDown();
                if (flag) {
                    if (comSub > 0) {
                        this.sub_button = true;
                        if (mouseX >= -31 && mouseX <= -18 && mouseY >= 86 && mouseY <= 99) {
                            this.m_93228_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 86, 14, 0, 14, 14);
                        } else {
                            this.m_93228_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 86, 0, 0, 14, 14);
                        }
                    } else {
                        this.sub_button = false;
                        this.m_93228_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 86, 28, 0, 14, 14);
                    }
                } else if (comSub < 15) {
                    this.add_button = true;
                    if (mouseX >= -31 && mouseX <= -18 && mouseY >= 86 && mouseY <= 99) {
                        this.m_93228_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 86, 14, 14, 14, 14);
                    } else {
                        this.m_93228_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 86, 0, 14, 14, 14);
                    }
                } else {
                    this.add_button = false;
                    this.m_93228_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 86, 28, 14, 14, 14);
                }
            }
        }
    }

    private void addInventoryButtons(PoseStack matrix, int mouseX, int mouseY) {
        if (!((BlockIronFurnaceContainerBase)this.m_6262_()).showInventoryButtons()) {
            this.m_93228_(matrix, this.getGuiLeft() - 20, this.getGuiTop() + 4, 0, 28, 23, 26);
        } else if (((BlockIronFurnaceContainerBase)this.m_6262_()).showInventoryButtons()) {
            this.m_93228_(matrix, this.getGuiLeft() - 56, this.getGuiTop() + 4, 0, 54, 59, 107);
            if (mouseX >= -47 && mouseX <= -34 && mouseY >= 12 && mouseY <= 25 || ((BlockIronFurnaceContainerBase)this.m_6262_()).getAutoInput()) {
                this.m_93228_(matrix, this.getGuiLeft() - 47, this.getGuiTop() + 12, 0, 189, 14, 14);
            }
            if (mouseX >= -29 && mouseX <= -16 && mouseY >= 12 && mouseY <= 25 || ((BlockIronFurnaceContainerBase)this.m_6262_()).getAutoOutput()) {
                this.m_93228_(matrix, this.getGuiLeft() - 29, this.getGuiTop() + 12, 14, 189, 14, 14);
            }
            this.blitIO(matrix);
        }
    }

    private void blitRedstone(PoseStack matrix) {
        int setting;
        boolean flag = BlockIronFurnaceScreenBase.isShiftKeyDown();
        if (flag) {
            this.m_93228_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 70, 84, 189, 14, 14);
        }
        if ((setting = ((BlockIronFurnaceContainerBase)this.m_6262_()).getRedstoneMode()) == 0) {
            this.m_93228_(matrix, this.getGuiLeft() - 47, this.getGuiTop() + 70, 28, 189, 14, 14);
        } else if (setting == 1 && !flag) {
            this.m_93228_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 70, 42, 189, 14, 14);
        } else if (setting == 2) {
            this.m_93228_(matrix, this.getGuiLeft() - 31, this.getGuiTop() + 70, 98, 189, 14, 14);
        } else if (setting == 3) {
            this.m_93228_(matrix, this.getGuiLeft() - 15, this.getGuiTop() + 70, 56, 189, 14, 14);
        } else if (setting == 4) {
            this.m_93228_(matrix, this.getGuiLeft() - 47, this.getGuiTop() + 86, 70, 189, 14, 14);
        }
    }

    private void blitIO(PoseStack matrix) {
        int[] settings = new int[]{0, 0, 0, 0, 0, 0};
        int setting = ((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingTop();
        if (setting == 1) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 31, 0, 161, 10, 10);
        } else if (setting == 2) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 31, 10, 161, 10, 10);
        } else if (setting == 3) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 31, 20, 161, 10, 10);
        } else if (setting == 4) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 31, 30, 161, 10, 10);
        }
        settings[1] = setting;
        setting = ((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingBottom();
        if (setting == 1) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 55, 0, 161, 10, 10);
        } else if (setting == 2) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 55, 10, 161, 10, 10);
        } else if (setting == 3) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 55, 20, 161, 10, 10);
        } else if (setting == 4) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 55, 30, 161, 10, 10);
        }
        settings[0] = setting;
        setting = ((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingFront();
        if (setting == 1) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 43, 0, 161, 10, 10);
        } else if (setting == 2) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 43, 10, 161, 10, 10);
        } else if (setting == 3) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 43, 20, 161, 10, 10);
        } else if (setting == 4) {
            this.m_93228_(matrix, this.getGuiLeft() - 32, this.getGuiTop() + 43, 30, 161, 10, 10);
        }
        settings[((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexFront()] = setting;
        setting = ((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingBack();
        if (setting == 1) {
            this.m_93228_(matrix, this.getGuiLeft() - 20, this.getGuiTop() + 55, 0, 161, 10, 10);
        } else if (setting == 2) {
            this.m_93228_(matrix, this.getGuiLeft() - 20, this.getGuiTop() + 55, 10, 161, 10, 10);
        } else if (setting == 3) {
            this.m_93228_(matrix, this.getGuiLeft() - 20, this.getGuiTop() + 55, 20, 161, 10, 10);
        } else if (setting == 4) {
            this.m_93228_(matrix, this.getGuiLeft() - 20, this.getGuiTop() + 55, 30, 161, 10, 10);
        }
        settings[((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexBack()] = setting;
        setting = ((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingLeft();
        if (setting == 1) {
            this.m_93228_(matrix, this.getGuiLeft() - 44, this.getGuiTop() + 43, 0, 161, 10, 10);
        } else if (setting == 2) {
            this.m_93228_(matrix, this.getGuiLeft() - 44, this.getGuiTop() + 43, 10, 161, 10, 10);
        } else if (setting == 3) {
            this.m_93228_(matrix, this.getGuiLeft() - 44, this.getGuiTop() + 43, 20, 161, 10, 10);
        } else if (setting == 4) {
            this.m_93228_(matrix, this.getGuiLeft() - 44, this.getGuiTop() + 43, 30, 161, 10, 10);
        }
        settings[((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexLeft()] = setting;
        setting = ((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingRight();
        if (setting == 1) {
            this.m_93228_(matrix, this.getGuiLeft() - 20, this.getGuiTop() + 43, 0, 161, 10, 10);
        } else if (setting == 2) {
            this.m_93228_(matrix, this.getGuiLeft() - 20, this.getGuiTop() + 43, 10, 161, 10, 10);
        } else if (setting == 3) {
            this.m_93228_(matrix, this.getGuiLeft() - 20, this.getGuiTop() + 43, 20, 161, 10, 10);
        } else if (setting == 4) {
            this.m_93228_(matrix, this.getGuiLeft() - 20, this.getGuiTop() + 43, 30, 161, 10, 10);
        }
        settings[((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexRight()] = setting;
        boolean input = false;
        boolean output = false;
        boolean both = false;
        boolean fuel = false;
        for (int set : settings) {
            if (set == 1) {
                input = true;
                continue;
            }
            if (set == 2) {
                output = true;
                continue;
            }
            if (set == 3) {
                both = true;
                continue;
            }
            if (set != 4) continue;
            fuel = true;
        }
        if (input || both) {
            this.m_93228_(matrix, this.getGuiLeft() + 55, this.getGuiTop() + 16, 0, 171, 18, 18);
        }
        if (output || both) {
            this.m_93228_(matrix, this.getGuiLeft() + 111, this.getGuiTop() + 30, 0, 203, 26, 26);
        }
        if (fuel) {
            this.m_93228_(matrix, this.getGuiLeft() + 55, this.getGuiTop() + 52, 18, 171, 18, 18);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        double actualMouseX = mouseX - (double)((this.f_96543_ - this.getXSize()) / 2);
        double actualMouseY = mouseY - (double)((this.f_96544_ - this.getYSize()) / 2);
        this.mouseClickedRedstoneButtons(actualMouseX, actualMouseY);
        this.mouseClickedInventoryButtons(button, actualMouseX, actualMouseY);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void mouseClickedInventoryButtons(int button, double mouseX, double mouseY) {
        boolean flag;
        boolean bl = flag = button == 1;
        if (!((BlockIronFurnaceContainerBase)this.m_6262_()).showInventoryButtons()) {
            if (mouseX >= -20.0 && mouseX <= 0.0 && mouseY >= 4.0 && mouseY <= 26.0) {
                Messages.INSTANCE.sendToServer((Object)new PacketShowSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 1));
            }
        } else if (mouseX >= -13.0 && mouseX <= 0.0 && mouseY >= 4.0 && mouseY <= 26.0) {
            Messages.INSTANCE.sendToServer((Object)new PacketShowSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 0));
        } else if (mouseX >= -47.0 && mouseX <= -34.0 && mouseY >= 12.0 && mouseY <= 25.0) {
            if (!((BlockIronFurnaceContainerBase)this.m_6262_()).getAutoInput()) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 6, 1));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
            } else {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 6, 0));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
            }
        } else if (mouseX >= -29.0 && mouseX <= -16.0 && mouseY >= 12.0 && mouseY <= 25.0) {
            if (!((BlockIronFurnaceContainerBase)this.m_6262_()).getAutoOutput()) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 7, 1));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
            } else {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 7, 0));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
            }
        } else if (mouseX >= -32.0 && mouseX <= -23.0 && mouseY >= 31.0 && mouseY <= 40.0) {
            if (flag) {
                this.sendToServerInverted(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingTop(), 1);
            } else {
                this.sendToServer(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingTop(), 1);
            }
        } else if (mouseX >= -32.0 && mouseX <= -23.0 && mouseY >= 55.0 && mouseY <= 64.0) {
            if (flag) {
                this.sendToServerInverted(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingBottom(), 0);
            } else {
                this.sendToServer(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingBottom(), 0);
            }
        } else if (mouseX >= -32.0 && mouseX <= -23.0 && mouseY >= 43.0 && mouseY <= 52.0) {
            if (BlockIronFurnaceScreenBase.isShiftKeyDown()) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 0, 0));
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 1, 0));
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 2, 0));
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 3, 0));
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 4, 0));
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 5, 0));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.8f, (float)0.3f));
            } else if (flag) {
                this.sendToServerInverted(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingFront(), ((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexFront());
            } else {
                this.sendToServer(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingFront(), ((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexFront());
            }
        } else if (mouseX >= -20.0 && mouseX <= -11.0 && mouseY >= 55.0 && mouseY <= 64.0) {
            if (flag) {
                this.sendToServerInverted(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingBack(), ((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexBack());
            } else {
                this.sendToServer(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingBack(), ((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexBack());
            }
        } else if (mouseX >= -44.0 && mouseX <= -35.0 && mouseY >= 43.0 && mouseY <= 52.0) {
            if (flag) {
                this.sendToServerInverted(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingLeft(), ((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexLeft());
            } else {
                this.sendToServer(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingLeft(), ((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexLeft());
            }
        } else if (mouseX >= -20.0 && mouseX <= -11.0 && mouseY >= 43.0 && mouseY <= 52.0) {
            if (flag) {
                this.sendToServerInverted(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingRight(), ((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexRight());
            } else {
                this.sendToServer(((BlockIronFurnaceContainerBase)this.m_6262_()).getSettingRight(), ((BlockIronFurnaceContainerBase)this.m_6262_()).getIndexRight());
            }
        }
    }

    private void sendToServer(int setting, int index) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
        if (setting <= 0) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 1));
        } else if (setting == 1) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 2));
        } else if (setting == 2) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 3));
        } else if (setting == 3) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 4));
        } else if (setting >= 4) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 0));
        }
    }

    private void sendToServerInverted(int setting, int index) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.3f, (float)0.3f));
        if (setting <= 0) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 4));
        } else if (setting == 1) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 0));
        } else if (setting == 2) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 1));
        } else if (setting == 3) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 2));
        } else if (setting >= 4) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), index, 3));
        }
    }

    public void mouseClickedRedstoneButtons(double mouseX, double mouseY) {
        if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 86.0 && mouseY <= 99.0 && this.sub_button && BlockIronFurnaceScreenBase.isShiftKeyDown()) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 9, ((BlockIronFurnaceContainerBase)this.m_6262_()).getComSub() - 1));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.3f, (float)0.3f));
        }
        if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 86.0 && mouseY <= 99.0 && this.add_button && !BlockIronFurnaceScreenBase.isShiftKeyDown()) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 9, ((BlockIronFurnaceContainerBase)this.m_6262_()).getComSub() + 1));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
        }
        if (mouseX >= -47.0 && mouseX <= -34.0 && mouseY >= 70.0 && mouseY <= 83.0 && ((BlockIronFurnaceContainerBase)this.m_6262_()).getRedstoneMode() != 0) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 8, 0));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
        }
        if (mouseX >= -31.0 && mouseX <= -18.0 && mouseY >= 70.0 && mouseY <= 83.0) {
            if (((BlockIronFurnaceContainerBase)this.m_6262_()).getRedstoneMode() != 1 && !BlockIronFurnaceScreenBase.isShiftKeyDown()) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 8, 1));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
            }
            if (((BlockIronFurnaceContainerBase)this.m_6262_()).getRedstoneMode() != 2 && BlockIronFurnaceScreenBase.isShiftKeyDown()) {
                Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 8, 2));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
            }
        }
        if (mouseX >= -15.0 && mouseX <= -2.0 && mouseY >= 70.0 && mouseY <= 83.0 && ((BlockIronFurnaceContainerBase)this.m_6262_()).getRedstoneMode() != 3) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 8, 3));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
        }
        if (mouseX >= -47.0 && mouseX <= -34.0 && mouseY >= 86.0 && mouseY <= 99.0 && ((BlockIronFurnaceContainerBase)this.m_6262_()).getRedstoneMode() != 4) {
            Messages.INSTANCE.sendToServer((Object)new PacketSettingsButton(((BlockIronFurnaceContainerBase)this.m_6262_()).getPos(), 8, 4));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)0.6f, (float)0.3f));
        }
    }

    public static boolean isShiftKeyDown() {
        return BlockIronFurnaceScreenBase.isKeyDown(340) || BlockIronFurnaceScreenBase.isKeyDown(344);
    }

    public static boolean isKeyDown(int glfw) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.m_84895_(glfw);
        int keyCode = key.m_84873_();
        if (keyCode != InputConstants.f_84822_.m_84873_()) {
            long windowHandle = Minecraft.m_91087_().m_91268_().m_85439_();
            try {
                if (key.m_84868_() == InputConstants.Type.KEYSYM) {
                    return InputConstants.m_84830_((long)windowHandle, (int)keyCode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

