/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.network.NetworkTools;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTypeTools;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import mcjty.rftoolscontrol.modules.processor.logic.registry.InventoryUtil;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ParameterTools {
    public static Parameter readFromBuf(FriendlyByteBuf buf) {
        byte b = buf.readByte();
        if (b == -1) {
            return null;
        }
        ParameterType type = ParameterType.values()[b];
        Parameter.Builder builder = Parameter.builder().type(type);
        if (buf.readBoolean()) {
            switch (type) {
                case PAR_STRING: {
                    builder.value(ParameterValue.constant((Object)buf.m_130136_(Short.MAX_VALUE)));
                    break;
                }
                case PAR_INTEGER: {
                    builder.value(ParameterValue.constant((Object)buf.readInt()));
                    break;
                }
                case PAR_LONG: {
                    builder.value(ParameterValue.constant((Object)buf.readLong()));
                    break;
                }
                case PAR_FLOAT: {
                    builder.value(ParameterValue.constant((Object)Float.valueOf(buf.readFloat())));
                    break;
                }
                case PAR_NUMBER: {
                    byte t = buf.readByte();
                    switch (t) {
                        case 0: {
                            builder.value(ParameterValue.constant((Object)buf.readInt()));
                            break;
                        }
                        case 1: {
                            builder.value(ParameterValue.constant((Object)buf.readLong()));
                            break;
                        }
                        case 2: {
                            builder.value(ParameterValue.constant((Object)Float.valueOf(buf.readFloat())));
                            break;
                        }
                        case 3: {
                            builder.value(ParameterValue.constant((Object)buf.readDouble()));
                        }
                    }
                    break;
                }
                case PAR_SIDE: {
                    String nodeName = buf.m_130136_(Short.MAX_VALUE);
                    byte sideIdx = buf.readByte();
                    Direction side = sideIdx == -1 ? null : Direction.values()[sideIdx];
                    builder.value(ParameterValue.constant((Object)new BlockSide(nodeName, side)));
                    break;
                }
                case PAR_BOOLEAN: {
                    builder.value(ParameterValue.constant((Object)buf.readBoolean()));
                    break;
                }
                case PAR_INVENTORY: {
                    builder.value(ParameterValue.constant((Object)InventoryUtil.readBuf(buf)));
                    break;
                }
                case PAR_ITEM: {
                    builder.value(ParameterValue.constant((Object)NetworkTools.readItemStack((FriendlyByteBuf)buf)));
                    break;
                }
                case PAR_FLUID: {
                    builder.value(ParameterValue.constant((Object)NetworkTools.readFluidStack((ByteBuf)buf)));
                    break;
                }
                case PAR_EXCEPTION: {
                    builder.value(ParameterValue.constant((Object)((Object)ExceptionType.getExceptionForCode(buf.m_130136_(Short.MAX_VALUE)))));
                    break;
                }
                case PAR_TUPLE: {
                    builder.value(ParameterValue.constant((Object)new Tuple(buf.readInt(), buf.readInt())));
                    break;
                }
                case PAR_VECTOR: {
                    int size = buf.readInt();
                    ArrayList<Parameter> vector = new ArrayList<Parameter>(size);
                    for (int i = 0; i < size; ++i) {
                        vector.add(ParameterTools.readFromBuf(buf));
                    }
                    builder.value(ParameterValue.constant(Collections.unmodifiableList(vector)));
                }
            }
        }
        return builder.build();
    }

    public static void writeToBuf(FriendlyByteBuf buf, Parameter parameter) {
        buf.writeByte(parameter.getParameterType().ordinal());
        Object value = parameter.getParameterValue().getValue();
        if (value == null) {
            buf.writeBoolean(false);
            return;
        }
        buf.writeBoolean(true);
        switch (parameter.getParameterType()) {
            case PAR_STRING: {
                buf.m_130070_((String)value);
                break;
            }
            case PAR_INTEGER: {
                buf.writeInt(((Integer)value).intValue());
                break;
            }
            case PAR_LONG: {
                buf.writeLong(((Long)value).longValue());
                break;
            }
            case PAR_FLOAT: {
                buf.writeFloat(((Float)value).floatValue());
                break;
            }
            case PAR_NUMBER: {
                if (value instanceof Integer) {
                    buf.writeByte(0);
                    buf.writeInt(((Integer)value).intValue());
                    break;
                }
                if (value instanceof Long) {
                    buf.writeByte(1);
                    buf.writeLong(((Long)value).longValue());
                    break;
                }
                if (value instanceof Float) {
                    buf.writeByte(2);
                    buf.writeFloat(((Float)value).floatValue());
                    break;
                }
                if (!(value instanceof Double)) break;
                buf.writeByte(3);
                buf.writeDouble(((Double)value).doubleValue());
                break;
            }
            case PAR_SIDE: {
                BlockSide bs = (BlockSide)value;
                buf.m_130070_(bs.getNodeNameSafe());
                buf.writeByte(bs.getSide() == null ? -1 : bs.getSide().ordinal());
                break;
            }
            case PAR_BOOLEAN: {
                buf.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case PAR_INVENTORY: {
                Inventory inv = (Inventory)value;
                InventoryUtil.writeBuf(inv, buf);
                break;
            }
            case PAR_ITEM: {
                NetworkTools.writeItemStack((FriendlyByteBuf)buf, (ItemStack)((ItemStack)value));
                break;
            }
            case PAR_FLUID: {
                NetworkTools.writeFluidStack((ByteBuf)buf, (FluidStack)((FluidStack)value));
                break;
            }
            case PAR_EXCEPTION: {
                buf.m_130070_(((ExceptionType)((Object)value)).getCode());
                break;
            }
            case PAR_TUPLE: {
                Tuple tuple = (Tuple)value;
                buf.writeInt(tuple.getX());
                buf.writeInt(tuple.getY());
                break;
            }
            case PAR_VECTOR: {
                List vector = (List)value;
                buf.writeInt(vector.size());
                for (Parameter p : vector) {
                    ParameterTools.writeToBuf(buf, p);
                }
                break;
            }
        }
    }

    public static CompoundTag writeToNBT(Parameter parameter) {
        ParameterType type = parameter.getParameterType();
        ParameterValue value = parameter.getParameterValue();
        CompoundTag parTag = new CompoundTag();
        parTag.m_128405_("type", type.ordinal());
        ParameterTypeTools.writeToNBT(parTag, type, value);
        return parTag;
    }

    public static Parameter readFromNBT(CompoundTag parTag) {
        ParameterType type = ParameterType.values()[parTag.m_128451_("type")];
        ParameterValue value = ParameterTypeTools.readFromNBT(parTag, type);
        return Parameter.builder().type(type).value(value).build();
    }

    public static Parameter readFromJson(JsonObject object) {
        ParameterType type = ParameterType.getByName((String)object.get("type").getAsString());
        ParameterValue value = ParameterTypeTools.readFromJson(type, object.get("value").getAsJsonObject());
        return Parameter.builder().type(type).value(value).build();
    }

    public static JsonElement getJsonElement(Parameter parameter) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(parameter.getParameterType().getName()));
        jsonObject.add("value", ParameterTypeTools.writeToJson(parameter.getParameterType(), parameter.getParameterValue()));
        return jsonObject;
    }

    public static int compare(Parameter par1, Parameter par2) {
        Object v1 = par1.getParameterValue().getValue();
        Object v2 = par2.getParameterValue().getValue();
        if (v1 == null) {
            return v2 == null ? 0 : 1;
        }
        if (v2 == null) {
            return -1;
        }
        switch (par2.getParameterType()) {
            case PAR_STRING: {
                return ((String)v1).compareTo((String)v2);
            }
            case PAR_INTEGER: {
                return ((Integer)v1).compareTo((Integer)v2);
            }
            case PAR_LONG: {
                return ((Long)v1).compareTo((Long)v2);
            }
            case PAR_FLOAT: {
                return ((Float)v1).compareTo((Float)v2);
            }
            case PAR_NUMBER: {
                return ParameterTools.compareNumbers(v1, v2);
            }
            case PAR_SIDE: {
                return 0;
            }
            case PAR_BOOLEAN: {
                return ((Boolean)v1).compareTo((Boolean)v2);
            }
            case PAR_INVENTORY: {
                return 0;
            }
            case PAR_ITEM: {
                return Integer.compare(((ItemStack)v1).m_41613_(), ((ItemStack)v2).m_41613_());
            }
            case PAR_FLUID: {
                return Integer.compare(((FluidStack)v1).getAmount(), ((FluidStack)v2).getAmount());
            }
            case PAR_EXCEPTION: {
                return 0;
            }
            case PAR_TUPLE: {
                Tuple t1 = (Tuple)v1;
                Tuple t2 = (Tuple)v2;
                if (t1.getX() == t2.getX()) {
                    return Integer.compare(t1.getY(), t2.getY());
                }
                return Integer.compare(t1.getX(), t2.getX());
            }
            case PAR_VECTOR: {
                List t1 = (List)v1;
                List t2 = (List)v2;
                if (t1.size() == t2.size()) {
                    for (int i = 0; i < t1.size(); ++i) {
                        Parameter p2;
                        Parameter p1 = (Parameter)t1.get(i);
                        int rc = ParameterTools.compare(p1, p2 = (Parameter)t2.get(i));
                        if (rc == 0) continue;
                        return rc;
                    }
                    return 0;
                }
                return Integer.compare(t1.size(), t2.size());
            }
        }
        return 0;
    }

    public static int compareNumbers(Object n1, Object n2) {
        if (n2 == null) {
            n2 = 0;
        }
        if (n1 instanceof Integer) {
            return ((Integer)n1).compareTo(TypeConverters.castToInt(n2));
        }
        if (n1 instanceof Long) {
            return ((Long)n1).compareTo(TypeConverters.castToLong(n2));
        }
        if (n1 instanceof Float) {
            return ((Float)n1).compareTo(Float.valueOf(TypeConverters.castToFloat(n2)));
        }
        if (n1 instanceof Double) {
            return ((Double)n1).compareTo(TypeConverters.castToDouble(n2));
        }
        if (n1 == null) {
            return Integer.compare(0, TypeConverters.castToInt(n2));
        }
        throw new IllegalArgumentException("Can't happen!");
    }

    public static int getMaxidxVector(List<Parameter> vector) {
        int maxidx = -1;
        Parameter max = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null) continue;
            if (max == null) {
                max = vector.get(i);
                maxidx = i;
                continue;
            }
            int cmp = ParameterTools.compare(max, vector.get(i));
            if (cmp >= 0) continue;
            maxidx = i;
            max = vector.get(i);
        }
        return maxidx;
    }

    public static int getMinidxVector(List<Parameter> vector) {
        int minidx = -1;
        Parameter min = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null) continue;
            if (min == null) {
                min = vector.get(i);
                minidx = i;
                continue;
            }
            int cmp = ParameterTools.compare(min, vector.get(i));
            if (cmp <= 0) continue;
            minidx = i;
            min = vector.get(i);
        }
        return minidx;
    }

    public static int getSumVector(List<Parameter> vector) {
        int sum = 0;
        for (Parameter el : vector) {
            if (el == null) continue;
            sum += TypeConverters.convertToInt(el);
        }
        return sum;
    }

    public static int getLength(@Nullable IParameter parameter) {
        if (parameter == null) {
            return 0;
        }
        ParameterValue value = parameter.getParameterValue();
        if (value == null) {
            return 0;
        }
        Object v = value.getValue();
        switch (parameter.getParameterType()) {
            case PAR_STRING: {
                return ((String)v).length();
            }
            case PAR_INTEGER: {
                return 0;
            }
            case PAR_LONG: {
                return 0;
            }
            case PAR_FLOAT: {
                return 0;
            }
            case PAR_NUMBER: {
                return 0;
            }
            case PAR_BOOLEAN: {
                return 0;
            }
            case PAR_TUPLE: {
                return 2;
            }
            case PAR_VECTOR: {
                return ((List)v).size();
            }
            case PAR_ITEM: {
                return ((ItemStack)v).m_41613_();
            }
            case PAR_SIDE: 
            case PAR_INVENTORY: 
            case PAR_FLUID: 
            case PAR_EXCEPTION: {
                return 0;
            }
        }
        return 0;
    }

    public static Number addNumbers(Number n1, Number n2) {
        if (n1 instanceof Double || n2 instanceof Double) {
            return TypeConverters.castToDouble(n1) + TypeConverters.castToDouble(n2);
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf(TypeConverters.castToFloat(n1) + TypeConverters.castToFloat(n2));
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return TypeConverters.castToLong(n1) + TypeConverters.castToLong(n2);
        }
        return TypeConverters.castToInt(n1) + TypeConverters.castToInt(n2);
    }

    public static Number subtractNumbers(Number n1, Number n2) {
        if (n1 instanceof Double || n2 instanceof Double) {
            return TypeConverters.castToDouble(n1) - TypeConverters.castToDouble(n2);
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf(TypeConverters.castToFloat(n1) - TypeConverters.castToFloat(n2));
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return TypeConverters.castToLong(n1) - TypeConverters.castToLong(n2);
        }
        return TypeConverters.castToInt(n1) - TypeConverters.castToInt(n2);
    }

    public static Number multiplyNumbers(Number n1, Number n2) {
        if (n1 instanceof Double || n2 instanceof Double) {
            return TypeConverters.castToDouble(n1) * TypeConverters.castToDouble(n2);
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf(TypeConverters.castToFloat(n1) * TypeConverters.castToFloat(n2));
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return TypeConverters.castToLong(n1) * TypeConverters.castToLong(n2);
        }
        return TypeConverters.castToInt(n1) * TypeConverters.castToInt(n2);
    }

    public static Number divideNumbers(Number n1, Number n2) {
        if (n1 instanceof Double || n2 instanceof Double) {
            return TypeConverters.castToDouble(n1) / TypeConverters.castToDouble(n2);
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf(TypeConverters.castToFloat(n1) / TypeConverters.castToFloat(n2));
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return TypeConverters.castToLong(n1) / TypeConverters.castToLong(n2);
        }
        return TypeConverters.castToInt(n1) / TypeConverters.castToInt(n2);
    }

    public static Number moduloNumbers(Number n1, Number n2) {
        if (n1 instanceof Double || n2 instanceof Double) {
            return TypeConverters.castToDouble(n1) % TypeConverters.castToDouble(n2);
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf(TypeConverters.castToFloat(n1) % TypeConverters.castToFloat(n2));
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return TypeConverters.castToLong(n1) % TypeConverters.castToLong(n2);
        }
        return TypeConverters.castToInt(n1) % TypeConverters.castToInt(n2);
    }
}

