/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.network.PacketVariablesReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketGetVariables {
    private final BlockPos pos;
    private final ResourceKey<Level> type;
    private final TypedMap params;
    private final boolean fromTablet;

    public PacketGetVariables(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.type = LevelTools.getId((ResourceLocation)buf.m_130281_());
        this.params = TypedMapTools.readArguments((FriendlyByteBuf)buf);
        this.fromTablet = buf.readBoolean();
    }

    public PacketGetVariables(BlockPos pos, ResourceKey<Level> type, boolean fromTablet) {
        this.pos = pos;
        this.type = type;
        this.params = TypedMap.EMPTY;
        this.fromTablet = fromTablet;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.type.m_135782_());
        TypedMapTools.writeArguments((FriendlyByteBuf)buf, (TypedMap)this.params);
        buf.writeBoolean(this.fromTablet);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity te;
            ServerLevel world = LevelTools.getLevel((Level)ctx.getSender().m_20193_(), this.type);
            if (world.m_46805_(this.pos) && (te = world.m_7702_(this.pos)) instanceof GenericTileEntity) {
                List list = ((GenericTileEntity)te).executeServerCommandList(ProcessorTileEntity.CMD_GETVARS.name(), (Player)ctx.getSender(), this.params, Parameter.class);
                RFToolsCtrlMessages.INSTANCE.sendTo((Object)new PacketVariablesReady(this.fromTablet ? null : this.pos, ProcessorTileEntity.CMD_GETVARS.name(), list), ctx.getSender().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.setPacketHandled(true);
    }
}

