/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketVariablesReady {
    private BlockPos pos;
    private final List<Parameter> list;
    private final String command;

    public PacketVariablesReady(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.m_130135_();
        }
        this.command = buf.m_130136_(Short.MAX_VALUE);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<Parameter>(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(ParameterTools.readFromBuf(buf));
            }
        } else {
            this.list = null;
        }
    }

    public PacketVariablesReady(@Nullable BlockPos pos, String command, List<Parameter> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<Parameter>();
        this.list.addAll(list);
    }

    public void toBytes(FriendlyByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130070_(this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (Parameter item : this.list) {
                if (item == null) {
                    buf.writeByte(-1);
                    continue;
                }
                ParameterTools.writeToBuf(buf, item);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity te;
            if (this.pos == null) {
                ProcessorContainer container = PacketVariablesReady.getOpenContainer();
                if (container == null) {
                    Logging.log((String)"Container is missing!");
                    return;
                }
                te = container.getTe();
            } else {
                te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            }
            if (te instanceof GenericTileEntity) {
                ((GenericTileEntity)te).handleListFromServer(this.command, SafeClientTools.getClientPlayer(), TypedMap.EMPTY, this.list);
            }
        });
        ctx.setPacketHandled(true);
    }

    private static ProcessorContainer getOpenContainer() {
        AbstractContainerMenu container = SafeClientTools.getClientPlayer().f_36096_;
        if (container instanceof ProcessorContainer) {
            return (ProcessorContainer)container;
        }
        return null;
    }
}

