/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.programmer.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.icons.IIcon;
import mcjty.lib.gui.icons.ImageIcon;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.IconHolder;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbase.api.control.code.Opcode;
import mcjty.rftoolsbase.api.control.code.OpcodeCategory;
import mcjty.rftoolsbase.api.control.code.OpcodeOutput;
import mcjty.rftoolsbase.api.control.parameters.ParameterDescription;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.Connection;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTypeTools;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.ProgramValidator;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditors;
import mcjty.rftoolscontrol.modules.processor.logic.grid.GridInstance;
import mcjty.rftoolscontrol.modules.processor.logic.grid.GridPos;
import mcjty.rftoolscontrol.modules.processor.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Opcodes;
import mcjty.rftoolscontrol.modules.programmer.ProgrammerModule;
import mcjty.rftoolscontrol.modules.programmer.blocks.ProgrammerTileEntity;
import mcjty.rftoolscontrol.modules.programmer.client.GuiTools;
import mcjty.rftoolscontrol.modules.programmer.network.PacketUpdateNBTItemInventoryProgrammer;
import mcjty.rftoolscontrol.modules.various.items.ProgramCardItem;
import mcjty.rftoolscontrol.setup.Config;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GuiProgrammer
extends GenericGuiContainer<ProgrammerTileEntity, GenericContainer> {
    public static final int SIDEWIDTH = 80;
    public static final int WIDTH = 256;
    public static final int HEIGHT = 236;
    public static final int GRID_HEIGHT = 10;
    public static final int GRID_WIDTH = 11;
    public static final int ICONSIZE = 20;
    private static final ResourceLocation mainBackground = new ResourceLocation("rftoolscontrol", "textures/gui/programmer.png");
    private static final ResourceLocation sideBackground = new ResourceLocation("rftoolscontrol", "textures/gui/sidegui.png");
    private static final ResourceLocation icons = new ResourceLocation("rftoolscontrol", "textures/gui/icons.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftoolscontrol", "textures/gui/guielements.png");
    private Window sideWindow;
    private WidgetList gridList;
    private WidgetList editorList;
    private WidgetList opcodeList;
    private IconHolder trashcan;
    private List<ImageChoiceLabel> categoryLabels = new ArrayList<ImageChoiceLabel>();
    private int iconLeavesFromX = -1;
    private int iconLeavesFromY = -1;
    private boolean loading = false;
    private OpcodeCategory currentCategory = null;
    private static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private static final Map<Connection, IIcon> CONNECTION_ICONS = new HashMap<Connection, IIcon>();
    private static final Map<Connection, IIcon> HIGHLIGHT_ICONS = new HashMap<Connection, IIcon>();
    private static final IIcon selectionIcon;
    private static final IIcon errorIcon1;
    private static final IIcon errorIcon2;
    private static ProgramCardInstance undoProgram;
    private GridPos prevHighlightConnector = null;
    private long prevTime = -1L;
    private int saveCounter = 10;

    public GuiProgrammer(ProgrammerTileEntity te, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)te, (AbstractContainerMenu)container, inventory, ((BaseBlock)ProgrammerModule.PROGRAMMER.get()).getManualEntry());
        this.f_97726_ = 256;
        this.f_97727_ = 236;
        this.initIcons();
    }

    public static void register() {
        GuiProgrammer.register((MenuType)((MenuType)ProgrammerModule.PROGRAMMER_CONTAINER.get()), GuiProgrammer::new);
    }

    private void initIcons() {
        if (ICONS.isEmpty()) {
            for (Map.Entry<String, Opcode> entry : Opcodes.OPCODES.entrySet()) {
                String id = entry.getKey();
                Opcode opcode = entry.getValue();
                ResourceLocation iconResource = icons;
                if (opcode.getIconResource() != null) {
                    iconResource = new ResourceLocation(opcode.getIconResource());
                }
                ICONS.put(id, (IIcon)new ImageIcon(id).setDimensions(20, 20).setImage(iconResource, opcode.getIconU() * 20, opcode.getIconV() * 20));
            }
        }
    }

    public void m_7856_() {
        super.m_7856_();
        Panel editorPanel = this.setupEditorPanel();
        Panel controlPanel = this.setupControlPanel();
        Panel gridPanel = this.setupGridPanel();
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(mainBackground)).children(new Widget[]{editorPanel, controlPanel, gridPanel});
        toplevel.bounds(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel).addFocusEvent(focused -> this.selectIcon(this.window, focused));
        Panel listPanel = this.setupListPanel();
        Panel sidePanel = (Panel)((Panel)Widgets.positional().background(sideBackground)).children(new Widget[]{listPanel});
        sidePanel.bounds(this.f_97735_ - 80, this.f_97736_, 80, this.f_97727_);
        this.sideWindow = new Window((Screen)this, (AbstractContainerWidget)sidePanel);
        this.loadProgram(1);
        this.clearCategoryLabels();
        this.f_96541_.f_91068_.m_90926_(true);
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.sideWindow);
        mgr.getIconManager().setClickHoldToDrag(true);
    }

    private Panel setupGridPanel() {
        Panel panel = (Panel)Widgets.positional().hint(5, 5, 246, 130);
        this.gridList = ((WidgetList)Widgets.list((int)0, (int)0, (int)236, (int)130).name("grid")).propagateEventsToChildren(true).invisibleSelection(true).drawHorizontalLines(false).rowheight(21);
        Slider slider = Widgets.slider((int)237, (int)0, (int)9, (int)130).vertical().scrollableName("grid");
        for (int y = 0; y < 10; ++y) {
            Panel rowPanel = new Panel().layout((Layout)((HorizontalLayout)((HorizontalLayout)new HorizontalLayout().setSpacing(-1)).setHorizontalMargin(0)).setVerticalMargin(0));
            int x = 0;
            while (x < 11) {
                final int finalX = x++;
                final int finalY = y;
                IconHolder holder = ((IconHolder)((IconHolder)((IconHolder)new IconHolder(){

                    public List<String> getTooltips() {
                        return GuiProgrammer.this.getGridIconTooltips(finalX, finalY);
                    }
                }.desiredWidth(22)).desiredHeight(22)).border(1).borderColor(Integer.valueOf(-8947849)).selectable(true).userObject((Object)new GridPos(finalX, finalY))).hoverEvent((iIcon, dx, dy) -> this.handleConnectorHighlight(finalX, finalY, iIcon, dx, dy)).leavesEvent(icon -> {
                    this.iconLeavesFromX = finalX;
                    this.iconLeavesFromY = finalY;
                    return true;
                }).arrivesEvent(icon -> {
                    if (icon != null && !this.loading) {
                        this.handleNewIconOverlay(icon, finalX, finalY);
                    }
                    return true;
                }).clickedEvent((icon, dx, dy) -> {
                    this.gridIconClicked(icon, finalX, finalY, dx, dy);
                    return true;
                });
                rowPanel.children(new Widget[]{holder});
            }
            this.gridList.children(new Widget[]{rowPanel});
        }
        ((Panel)panel.children(new Widget[]{this.gridList})).children(new Widget[]{slider});
        return panel;
    }

    private List<String> getGridIconTooltips(int finalX, int finalY) {
        if (SafeClientTools.isCtrlKeyDown()) {
            ArrayList<String> tooltips = new ArrayList<String>();
            if ((Integer)Config.tooltipVerbosityLevel.get() >= 2) {
                tooltips.add(ChatFormatting.GREEN + "Ctrl-Click to add or remove selection");
                tooltips.add(ChatFormatting.GREEN + "Ctrl-Double click to (de)select sequence");
                tooltips.add(ChatFormatting.YELLOW + "Ctrl-A to select entire grid");
                tooltips.add(ChatFormatting.YELLOW + "Ctrl-C to copy selected grid");
                tooltips.add(ChatFormatting.YELLOW + "Ctrl-X to cut selected grid");
                tooltips.add(ChatFormatting.YELLOW + "Ctrl-V to paste to selected grid");
                tooltips.add(ChatFormatting.YELLOW + "Ctrl-Z undo last paste operation");
            } else if ((Integer)Config.tooltipVerbosityLevel.get() >= 1) {
                tooltips.add(ChatFormatting.GREEN + "Use Ctrl with A, C, X, V or Z");
            }
            return tooltips;
        }
        if (this.prevHighlightConnector != null) {
            ArrayList<String> tooltips = new ArrayList<String>();
            if (((Boolean)Config.doubleClickToChangeConnector.get()).booleanValue()) {
                tooltips.add(ChatFormatting.GREEN + "Double click to change connector");
            } else {
                tooltips.add(ChatFormatting.GREEN + "Click to change connector");
            }
            return tooltips;
        }
        return this.getIconTooltipGrid(finalX, finalY);
    }

    private void selectSequence(GridPos pos, Set<GridPos> done, boolean select) {
        if (!this.checkValidGridPos(pos)) {
            return;
        }
        if (done.contains(pos)) {
            return;
        }
        IIcon icon = this.getHolder(pos.x(), pos.y()).getIcon();
        if (icon == null) {
            return;
        }
        icon.removeOverlay("S");
        if (select) {
            icon.addOverlay(selectionIcon);
        }
        done.add(pos);
        this.selectSequence(pos.up(), done, select);
        this.selectSequence(pos.down(), done, select);
        this.selectSequence(pos.left(), done, select);
        this.selectSequence(pos.right(), done, select);
    }

    private boolean checkValidGridPos(GridPos pos) {
        if (pos.x() < 0 || pos.x() >= 11) {
            return false;
        }
        return pos.y() >= 0 && pos.y() < 10;
    }

    private void gridIconClicked(IIcon icon, int x, int y, int dx, int dy) {
        Connection connection;
        boolean doubleclick;
        if (SafeClientTools.isCtrlKeyDown()) {
            long time = System.currentTimeMillis();
            boolean doubleclick2 = false;
            if (this.prevTime != -1L && time - this.prevTime < 250L) {
                doubleclick2 = true;
            }
            this.prevTime = time;
            if (icon.hasOverlay("S")) {
                if (doubleclick2) {
                    this.selectSequence(new GridPos(x, y), new HashSet<GridPos>(), true);
                } else {
                    icon.removeOverlay("S");
                }
            } else if (doubleclick2) {
                this.selectSequence(new GridPos(x, y), new HashSet<GridPos>(), false);
            } else {
                icon.addOverlay(selectionIcon);
            }
            return;
        }
        this.clearSelection();
        long time = System.currentTimeMillis();
        boolean bl = doubleclick = (Boolean)Config.doubleClickToChangeConnector.get() == false;
        if (this.prevTime != -1L && time - this.prevTime < 250L) {
            doubleclick = true;
        }
        this.prevTime = time;
        if (doubleclick && (connection = this.getConnectionHandle(dx, dy)) != null) {
            this.handleIconOverlay(icon, connection);
        }
    }

    private void selectAll() {
        for (int ix = 0; ix < 11; ++ix) {
            for (int iy = 0; iy < 10; ++iy) {
                IIcon i = this.getHolder(ix, iy).getIcon();
                if (i == null) continue;
                i.addOverlay(selectionIcon);
            }
        }
    }

    private void clearSelection() {
        for (int ix = 0; ix < 11; ++ix) {
            for (int iy = 0; iy < 10; ++iy) {
                IIcon i = this.getHolder(ix, iy).getIcon();
                if (i == null) continue;
                i.removeOverlay("S");
            }
        }
    }

    private boolean checkSelection() {
        for (int ix = 0; ix < 11; ++ix) {
            for (int iy = 0; iy < 10; ++iy) {
                IIcon i = this.getHolder(ix, iy).getIcon();
                if (i == null || !i.hasOverlay("S")) continue;
                return true;
            }
        }
        return false;
    }

    private void handleConnectorHighlight(int finalX, int finalY, IIcon iIcon, int dx, int dy) {
        if (this.prevHighlightConnector != null) {
            IconHolder h = this.getHolder(this.prevHighlightConnector.x(), this.prevHighlightConnector.y());
            if (h.getIcon() != null) {
                h.getIcon().removeOverlay("H");
            }
            this.prevHighlightConnector = null;
        }
        if (iIcon == null) {
            return;
        }
        iIcon.removeOverlay("H");
        Connection connection = this.getConnectionHandle(dx, dy);
        if (connection != null) {
            iIcon.addOverlay(HIGHLIGHT_ICONS.get((Object)connection));
            this.prevHighlightConnector = new GridPos(finalX, finalY);
        }
    }

    private Connection getConnectionHandle(int dx, int dy) {
        if (dy <= 5 && dx >= 8 && dx <= 15) {
            return Connection.UP;
        }
        if (dy >= 17 && dx >= 8 && dx <= 15) {
            return Connection.DOWN;
        }
        if (dx <= 5 && dy >= 7 && dy <= 14) {
            return Connection.LEFT;
        }
        if (dx >= 17 && dy >= 7 && dy <= 14) {
            return Connection.RIGHT;
        }
        return null;
    }

    private void handleNewIconOverlay(IIcon icon, int x, int y) {
        if (x == this.iconLeavesFromX && y == this.iconLeavesFromY) {
            return;
        }
        Opcode opcode = Opcodes.OPCODES.get(icon.getID());
        if (opcode.isEvent()) {
            return;
        }
        this.tryConnectToThis(x - 1, y, icon, Connection.RIGHT);
        this.tryConnectToThis(x + 1, y, icon, Connection.LEFT);
        this.tryConnectToThis(x, y - 1, icon, Connection.DOWN);
        this.tryConnectToThis(x, y + 1, icon, Connection.UP);
    }

    private void tryConnectToThis(int x, int y, IIcon icon, Connection connection) {
        if (x < 0 || x >= 11) {
            return;
        }
        if (y < 0 || y >= 10) {
            return;
        }
        IconHolder holder = this.getHolder(x, y);
        IIcon sourceIcon = holder.getIcon();
        if (sourceIcon != null) {
            Opcode opcode = Opcodes.OPCODES.get(sourceIcon.getID());
            if (opcode.getOpcodeOutput() == OpcodeOutput.NONE) {
                return;
            }
            if (opcode.getOpcodeOutput() == OpcodeOutput.SINGLE) {
                int cnt = this.countConnections(sourceIcon);
                if (cnt == 0) {
                    sourceIcon.addOverlay(CONNECTION_ICONS.get((Object)connection));
                }
            } else if (opcode.getOpcodeOutput() == OpcodeOutput.YESNO) {
                int cnt = this.countPrimaryConnections(sourceIcon);
                if (cnt == 0) {
                    sourceIcon.addOverlay(CONNECTION_ICONS.get((Object)connection));
                } else {
                    cnt = this.countSecondaryConnections(sourceIcon);
                    if (cnt == 0) {
                        sourceIcon.addOverlay(CONNECTION_ICONS.get((Object)connection.getOpposite()));
                    }
                }
            }
        }
    }

    private int countConnections(IIcon sourceIcon) {
        int cnt = 0;
        for (Connection connection : Connection.values()) {
            if (!sourceIcon.hasOverlay(connection.getId())) continue;
            ++cnt;
        }
        return cnt;
    }

    private int countPrimaryConnections(IIcon sourceIcon) {
        int cnt = 0;
        for (Connection connection : Connection.values()) {
            if (!connection.isPrimary() || !sourceIcon.hasOverlay(connection.getId())) continue;
            ++cnt;
        }
        return cnt;
    }

    private int countSecondaryConnections(IIcon sourceIcon) {
        int cnt = 0;
        for (Connection connection : Connection.values()) {
            if (connection.isPrimary() || !sourceIcon.hasOverlay(connection.getId())) continue;
            ++cnt;
        }
        return cnt;
    }

    private void handleIconOverlay(IIcon icon, Connection connection) {
        Opcode opcode = Opcodes.OPCODES.get(icon.getID());
        if (opcode.getOpcodeOutput() == OpcodeOutput.NONE) {
            return;
        }
        if (opcode.getOpcodeOutput() == OpcodeOutput.SINGLE) {
            boolean has = icon.hasOverlay(connection.getId());
            for (Connection c : Connection.values()) {
                icon.removeOverlay(c.getId());
            }
            if (!has && !icon.hasOverlay(connection.getId())) {
                icon.addOverlay(CONNECTION_ICONS.get((Object)connection));
            }
        } else if (icon.hasOverlay(connection.getId())) {
            icon.removeOverlay(Connection.DOWN_NEG.getId());
            icon.removeOverlay(Connection.UP_NEG.getId());
            icon.removeOverlay(Connection.LEFT_NEG.getId());
            icon.removeOverlay(Connection.RIGHT_NEG.getId());
            icon.removeOverlay(connection.getId());
            icon.addOverlay(CONNECTION_ICONS.get((Object)connection.getOpposite()));
        } else if (icon.hasOverlay(connection.getOpposite().getId())) {
            icon.removeOverlay(connection.getOpposite().getId());
        } else {
            if (connection.isPrimary()) {
                icon.removeOverlay(Connection.DOWN.getId());
                icon.removeOverlay(Connection.UP.getId());
                icon.removeOverlay(Connection.LEFT.getId());
                icon.removeOverlay(Connection.RIGHT.getId());
            } else {
                icon.removeOverlay(Connection.DOWN_NEG.getId());
                icon.removeOverlay(Connection.UP_NEG.getId());
                icon.removeOverlay(Connection.LEFT_NEG.getId());
                icon.removeOverlay(Connection.RIGHT_NEG.getId());
            }
            icon.addOverlay(CONNECTION_ICONS.get((Object)connection));
        }
    }

    private void clearGrid(boolean selection) {
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 10; ++y) {
                IconHolder h = this.getHolder(x, y);
                if (selection && (h.getIcon() == null || !h.getIcon().hasOverlay("S"))) continue;
                h.setIcon(null);
            }
        }
    }

    private IconHolder getHolder(int x, int y) {
        Panel row = (Panel)this.gridList.getChild(y);
        return (IconHolder)row.getChild(x);
    }

    private void validateAndHilight() {
        ProgramCardInstance instance = this.makeGridInstance(false);
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 10; ++y) {
                IconHolder h = this.getHolder(x, y);
                if (h.getIcon() == null) continue;
                h.getIcon().removeOverlay("E1");
                h.getIcon().removeOverlay("E2");
            }
        }
        long time = System.currentTimeMillis();
        List<Pair<GridPos, String>> errors = ProgramValidator.validate(instance);
        for (Pair<GridPos, String> entry : errors) {
            GridPos p = (GridPos)entry.getKey();
            IconHolder h = this.getHolder(p.x(), p.y());
            h.getIcon().addOverlay(time % 2000L < 1000L ? errorIcon1 : errorIcon2);
        }
    }

    private void validateProgram() {
        Panel panel = (Panel)((Panel)Widgets.vertical().filledBackground(-10066330, -5592406)).filledRectThickness(1);
        panel.bounds(60, 10, 200, 130);
        final Window modalWindow = this.getWindowManager().createModalWindow((AbstractContainerWidget)panel);
        final WidgetList errorList = new WidgetList();
        errorList.event(new SelectionEvent(){

            public void select(int index) {
            }

            public void doubleClick(int index) {
                Widget child;
                GridPos pos;
                if (errorList.getSelected() != -1 && (pos = (GridPos)(child = errorList.getChild(errorList.getSelected())).getUserObject()) != null) {
                    GuiProgrammer.this.window.setTextFocus((Widget)GuiProgrammer.this.getHolder(pos.x(), pos.y()));
                }
                GuiProgrammer.this.getWindowManager().closeWindow(modalWindow);
            }
        });
        panel.children(new Widget[]{errorList, Widgets.button((String)"Close").event(() -> this.getWindowManager().closeWindow(modalWindow))});
        ProgramCardInstance instance = this.makeGridInstance(false);
        List<Pair<GridPos, String>> errors = ProgramValidator.validate(instance);
        for (Pair<GridPos, String> entry : errors) {
            GridPos p = (GridPos)entry.getKey();
            errorList.children(new Widget[]{((Label)((Label)Widgets.label((String)((String)entry.getValue())).color(-65536)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).userObject((Object)p)});
        }
    }

    private void askNameAndSave(int slot) {
        ItemStack card = ((ProgrammerTileEntity)this.tileEntity).getItems().getStackInSlot(slot);
        if (card.m_41619_()) {
            GuiTools.showMessage(this.f_96541_, (Screen)this, this.getWindowManager(), 50, 50, "No card!");
            return;
        }
        String cardName = ProgramCardItem.getCardName(card);
        if (cardName.isEmpty() || SafeClientTools.isSneaking()) {
            GuiTools.askSomething(this.f_96541_, (Screen)this, this.getWindowManager(), 50, 50, "Card name:", cardName, s -> this.saveProgram(slot, (String)s));
        } else {
            this.saveProgram(slot, cardName);
        }
    }

    private void saveProgram(int slot, String name) {
        ItemStack card = ((ProgrammerTileEntity)this.tileEntity).getItems().getStackInSlot(slot);
        if (card.m_41619_()) {
            return;
        }
        if (name != null) {
            ProgramCardItem.setCardName(card, name);
        }
        ProgramCardInstance instance = this.makeGridInstance(false);
        instance.writeToNBT(card);
        RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketUpdateNBTItemInventoryProgrammer(((ProgrammerTileEntity)this.tileEntity).m_58899_(), slot, card.m_41783_()));
    }

    private ProgramCardInstance makeGridInstance(boolean selectionOnly) {
        ProgramCardInstance instance = ProgramCardInstance.newInstance();
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 10; ++y) {
                IconHolder holder = this.getHolder(x, y);
                IIcon icon = holder.getIcon();
                if (icon == null || selectionOnly && !icon.hasOverlay("S")) continue;
                String operandId = icon.getID();
                GridInstance.Builder builder = GridInstance.builder(operandId);
                for (Connection connection : Connection.values()) {
                    if (!icon.hasOverlay(connection.getId())) continue;
                    if (connection.isPrimary()) {
                        builder.primaryConnection(connection);
                        continue;
                    }
                    builder.secondaryConnection(connection);
                }
                Opcode opcode = Opcodes.OPCODES.get(operandId);
                Map data = icon.getData();
                for (ParameterDescription description : opcode.getParameters()) {
                    ParameterValue value;
                    ParameterValue parameterValue = value = data == null ? null : (ParameterValue)data.get(description.getName());
                    if (value == null) {
                        value = ParameterValue.constant(null);
                    }
                    Parameter parameter = Parameter.builder().type(description.getType()).value(value).build();
                    builder.parameter(parameter);
                }
                instance.putGridInstance(x, y, builder.build());
            }
        }
        return instance;
    }

    private void clearProgram() {
        undoProgram = this.makeGridInstance(false);
        this.clearGrid(false);
    }

    private void loadProgram(int slot) {
        ItemStack card = ((ProgrammerTileEntity)this.tileEntity).getItems().getStackInSlot(slot);
        if (card.m_41619_()) {
            return;
        }
        this.clearGrid(false);
        ProgramCardInstance instance = ProgramCardInstance.parseInstance(card);
        if (instance == null) {
            return;
        }
        this.loadProgram(instance);
    }

    private GridPos getSelectedGridHolder() {
        IconHolder holder;
        Widget widget = this.window.getTextFocus();
        if (widget instanceof IconHolder && (holder = (IconHolder)widget).getUserObject() instanceof GridPos) {
            return (GridPos)holder.getUserObject();
        }
        return null;
    }

    private void mergeProgram(ProgramCardInstance instance, GridPos pos) {
        int y;
        int x;
        int posy;
        int posx;
        GridPos leftTop = new GridPos(10000, 10000);
        if (pos == null) {
            posx = 0;
            posy = 0;
            leftTop = new GridPos(0, 0);
        } else {
            posx = pos.x();
            posy = pos.y();
            for (Map.Entry<GridPos, GridInstance> entry : instance.getGridInstances().entrySet()) {
                x = entry.getKey().x();
                y = entry.getKey().y();
                if (x < leftTop.x()) {
                    leftTop = entry.getKey();
                    continue;
                }
                if (x != leftTop.x() || y >= leftTop.y()) continue;
                leftTop = entry.getKey();
            }
            if (leftTop.x() > 1000) {
                return;
            }
        }
        for (Map.Entry<GridPos, GridInstance> entry : instance.getGridInstances().entrySet()) {
            x = entry.getKey().x() - leftTop.x() + posx;
            if (!this.checkValidGridPos(new GridPos(x, y = entry.getKey().y() - leftTop.y() + posy))) {
                GuiTools.showMessage(this.f_96541_, (Screen)this, this.getWindowManager(), 50, 50, ChatFormatting.RED + "No room for clipboard here!");
                return;
            }
            if (this.getHolder(x, y).getIcon() == null) continue;
            GuiTools.showMessage(this.f_96541_, (Screen)this, this.getWindowManager(), 50, 50, ChatFormatting.RED + "No room for clipboard here!");
            return;
        }
        for (Map.Entry<GridPos, GridInstance> entry : instance.getGridInstances().entrySet()) {
            x = entry.getKey().x() - leftTop.x() + posx;
            y = entry.getKey().y() - leftTop.y() + posy;
            this.loadGridInstance(entry, x, y);
        }
    }

    private void loadProgram(ProgramCardInstance instance) {
        for (Map.Entry<GridPos, GridInstance> entry : instance.getGridInstances().entrySet()) {
            int x = entry.getKey().x();
            int y = entry.getKey().y();
            this.loadGridInstance(entry, x, y);
        }
    }

    private void loadGridInstance(Map.Entry<GridPos, GridInstance> entry, int x, int y) {
        GridInstance gridInstance = entry.getValue();
        IIcon icon = ICONS.get(gridInstance.getId());
        if (icon == null) {
            Logging.logError((String)("Opcode with id '" + gridInstance.getId() + "' is missing!"));
            return;
        }
        icon = icon.clone();
        if (gridInstance.getPrimaryConnection() != null) {
            icon.addOverlay(CONNECTION_ICONS.get((Object)gridInstance.getPrimaryConnection()));
        }
        if (gridInstance.getSecondaryConnection() != null) {
            icon.addOverlay(CONNECTION_ICONS.get((Object)gridInstance.getSecondaryConnection()));
        }
        Opcode opcode = Opcodes.OPCODES.get(icon.getID());
        List<Parameter> parameters = gridInstance.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            String name = ((ParameterDescription)opcode.getParameters().get(i)).getName();
            icon.addData(name, (Object)parameters.get(i).getParameterValue());
        }
        this.loading = true;
        this.getHolder(x, y).setIcon(icon);
        this.loading = false;
    }

    private Panel setupControlPanel() {
        this.trashcan = ((IconHolder)((IconHolder)((IconHolder)new IconHolder().desiredWidth(14)).desiredHeight(14)).border(1).borderColor(Integer.valueOf(-65536)).tooltips(new String[]{ChatFormatting.YELLOW + "Delete opcode", "Drop opcodes here to", "delete them"})).selectable(false);
        return (Panel)((Panel)Widgets.horizontal((int)1, (int)2).hint(108, 136, 145, 18)).children(new Widget[]{((Button)((Button)Widgets.button((String)"Load").tooltips(new String[]{ChatFormatting.YELLOW + "Load program", "Load the current program", "from a program card"})).desiredHeight(15)).event(() -> this.loadProgram(0)), ((Button)((Button)Widgets.button((String)"Save").tooltips(new String[]{ChatFormatting.YELLOW + "Save program", "Save the current program", "to a program card", ChatFormatting.GREEN + "Press shift to change name"})).desiredHeight(15)).event(() -> this.askNameAndSave(0)), ((Button)((Button)Widgets.button((String)"Clear").tooltips(new String[]{ChatFormatting.YELLOW + "Clear program", "Remove all opcodes on the grid", "(press Ctrl-Z if this was a mistake)"})).desiredHeight(15)).event(this::clearProgram), ((Button)((Button)Widgets.button((String)"Val").tooltips(new String[]{ChatFormatting.YELLOW + "Validate program", "Perform some basic validations on", "the current program", "Double click on error", "to highlight opcode"})).desiredHeight(15)).event(this::validateProgram), this.trashcan});
    }

    private void clearCategoryLabels() {
        for (ImageChoiceLabel label : this.categoryLabels) {
            label.setCurrentChoice("off");
        }
        this.currentCategory = null;
        this.fillOpcodes();
    }

    private void makeCategoryToggle(Panel panel, int cx, int cy, OpcodeCategory category, int u, int v) {
        ImageChoiceLabel catLabel = ((ImageChoiceLabel)new ImageChoiceLabel().hint(cx * 18 + 3, cy * 18 + 14, 16, 16)).choice("off", "Filter on category " + category.getName() + " (off)", guiElements, u * 16, v * 16).choice("on", "Filter on category " + category.getName() + " (on)", guiElements, u * 16 + 16, v * 16);
        catLabel.event(newChoice -> {
            if ("on".equals(newChoice)) {
                this.clearCategoryLabels();
                catLabel.setCurrentChoice("on");
                this.currentCategory = category;
                this.fillOpcodes();
            } else {
                this.clearCategoryLabels();
            }
        });
        panel.children(new Widget[]{catLabel});
        this.categoryLabels.add(catLabel);
    }

    private Panel setupListPanel() {
        Panel panel = (Panel)((Panel)Widgets.positional().hint(2, 2, 78, 232)).children(new Widget[]{Widgets.label((int)0, (int)0, (int)70, (int)12, (String)"Opcodes:")});
        this.makeCategoryToggle(panel, 0, 0, OpcodeCategory.CATEGORY_ITEMS, 8, 5);
        this.makeCategoryToggle(panel, 1, 0, OpcodeCategory.CATEGORY_LIQUIDS, 10, 5);
        this.makeCategoryToggle(panel, 2, 0, OpcodeCategory.CATEGORY_CRAFTING, 6, 5);
        this.makeCategoryToggle(panel, 3, 0, OpcodeCategory.CATEGORY_REDSTONE, 14, 5);
        this.makeCategoryToggle(panel, 0, 1, OpcodeCategory.CATEGORY_ENERGY, 12, 5);
        this.makeCategoryToggle(panel, 1, 1, OpcodeCategory.CATEGORY_NUMBERS, 8, 6);
        this.makeCategoryToggle(panel, 2, 1, OpcodeCategory.CATEGORY_VECTORS, 10, 6);
        this.makeCategoryToggle(panel, 3, 1, OpcodeCategory.CATEGORY_GRAPHICS, 6, 6);
        this.opcodeList = ((WidgetList)Widgets.list((int)0, (int)52, (int)68, (int)180).name("opcodes")).propagateEventsToChildren(true).invisibleSelection(true).drawHorizontalLines(false).rowheight(22);
        Slider slider = Widgets.slider((int)68, (int)52, (int)8, (int)180).vertical().scrollableName("opcodes");
        this.fillOpcodes();
        return (Panel)panel.children(new Widget[]{this.opcodeList, slider});
    }

    private void fillOpcodes() {
        this.opcodeList.removeChildren();
        int x = 0;
        int y = 0;
        Panel childPanel = null;
        for (Opcode opcode : Opcodes.SORTED_OPCODES) {
            if (this.currentCategory != null && !opcode.getCategories().contains(this.currentCategory)) continue;
            String key = opcode.getId();
            if (childPanel == null) {
                childPanel = (Panel)new Panel().layout((Layout)((HorizontalLayout)((HorizontalLayout)new HorizontalLayout().setVerticalMargin(1)).setSpacing(1)).setHorizontalMargin(0)).desiredHeight(21);
                this.opcodeList.children(new Widget[]{childPanel});
            }
            IconHolder holder = ((IconHolder)((IconHolder)new IconHolder(){

                public List<String> getTooltips() {
                    return GuiProgrammer.this.getIconTooltip(this.getIcon());
                }
            }.desiredWidth(20)).desiredHeight(20)).makeCopy(true);
            holder.setIcon(ICONS.get(key).clone());
            childPanel.children(new Widget[]{holder});
            if (++x < 3) continue;
            ++y;
            x = 0;
            childPanel = null;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.handleClipboard(keyCode)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void keyTypedFromEvent(int keyCode, int scanCode) {
        if (this.handleClipboard(keyCode)) {
            return;
        }
        super.keyTypedFromEvent(keyCode, keyCode);
    }

    private boolean handleClipboard(int keyCode) {
        if (SafeClientTools.isCtrlKeyDown()) {
            if (keyCode == 65) {
                this.selectAll();
            } else {
                if (keyCode == 67) {
                    if (!this.checkSelection()) {
                        GuiTools.showMessage(this.f_96541_, (Screen)this, this.getWindowManager(), 50, 50, ChatFormatting.RED + "Nothing is selected!");
                    } else {
                        ProgramCardInstance instance = this.makeGridInstance(true);
                        String json = instance.writeToJson();
                        try {
                            this.f_96541_.f_91068_.m_90911_(json);
                        }
                        catch (Exception e) {
                            GuiTools.showMessage(this.f_96541_, (Screen)this, this.getWindowManager(), 50, 50, ChatFormatting.RED + "Error copying to clipboard!");
                        }
                    }
                    return true;
                }
                if (keyCode == 90) {
                    if (undoProgram != null) {
                        ProgramCardInstance curProgram = this.makeGridInstance(false);
                        this.clearGrid(false);
                        this.loadProgram(undoProgram);
                        undoProgram = curProgram;
                    }
                    return true;
                }
                if (keyCode == 88) {
                    if (!this.checkSelection()) {
                        GuiTools.showMessage(this.f_96541_, (Screen)this, this.getWindowManager(), 50, 50, ChatFormatting.RED + "Nothing is selected!");
                    } else {
                        ProgramCardInstance instance = this.makeGridInstance(true);
                        String json = instance.writeToJson();
                        try {
                            Minecraft.m_91087_().f_91068_.m_90911_(json);
                            undoProgram = this.makeGridInstance(false);
                            this.clearGrid(this.checkSelection());
                        }
                        catch (Exception e) {
                            GuiTools.showMessage(this.f_96541_, (Screen)this, this.getWindowManager(), 50, 50, ChatFormatting.RED + "Error copying to clipboard!");
                        }
                    }
                    return true;
                }
                if (keyCode == 86) {
                    try {
                        String data = Minecraft.m_91087_().f_91068_.m_90876_();
                        ProgramCardInstance program = ProgramCardInstance.readFromJson(data);
                        undoProgram = this.makeGridInstance(false);
                        this.mergeProgram(program, this.getSelectedGridHolder());
                    }
                    catch (Exception e) {
                        GuiTools.showMessage(this.f_96541_, (Screen)this, this.getWindowManager(), 50, 50, ChatFormatting.RED + "Error reading from clipboard!");
                    }
                }
            }
        }
        return false;
    }

    public boolean mouseClickedFromEvent(double x, double y, int button) {
        super.mouseClickedFromEvent(x, y, button);
        return false;
    }

    public boolean mouseReleasedFromEvent(double x, double y, int button) {
        super.mouseReleasedFromEvent(x, y, button);
        return false;
    }

    public boolean mouseScrolledFromEvent(double x, double y, double amount) {
        super.mouseScrolledFromEvent(x, y, amount);
        return false;
    }

    protected void m_6597_(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotId == -999) {
            return;
        }
        super.m_6597_(slotIn, slotId, mouseButton, type);
    }

    private List<String> getIconTooltipGrid(int x, int y) {
        IconHolder holder = this.getHolder(x, y);
        IIcon icon = holder.getIcon();
        if (icon != null) {
            Opcode opcode = Opcodes.OPCODES.get(icon.getID());
            List description = opcode.getDescription();
            ArrayList<String> tooltips = new ArrayList<String>();
            boolean isComment = Opcodes.DO_COMMENT.getId().equals(opcode.getId());
            if (isComment) {
                Map data = icon.getData() == null ? Collections.emptyMap() : icon.getData();
                for (ParameterDescription parameter : opcode.getParameters()) {
                    String s;
                    String name = parameter.getName();
                    ParameterValue value = (ParameterValue)data.get(name);
                    if (value == null || (s = ParameterTypeTools.stringRepresentation(parameter.getType(), value)).isEmpty()) continue;
                    tooltips.add(ChatFormatting.BLUE + s);
                }
            } else if (SafeClientTools.isSneaking()) {
                tooltips.add((String)description.get(0) + ChatFormatting.WHITE + " [" + x + "," + y + "]");
                Map data = icon.getData() == null ? Collections.emptyMap() : icon.getData();
                for (ParameterDescription parameter : opcode.getParameters()) {
                    String name = parameter.getName();
                    ParameterValue value = (ParameterValue)data.get(name);
                    if (value != null) {
                        tooltips.add(ChatFormatting.BLUE + "Par " + name + ": " + ParameterTypeTools.stringRepresentation(parameter.getType(), value));
                        continue;
                    }
                    tooltips.add(ChatFormatting.BLUE + "Par " + name + ": NULL");
                }
            } else {
                tooltips.add((String)description.get(0));
                tooltips.add("<Shift for more info>");
            }
            return tooltips;
        }
        return Collections.emptyList();
    }

    private List<String> getIconTooltip(IIcon icon) {
        if (icon != null) {
            Opcode opcode = Opcodes.OPCODES.get(icon.getID());
            List description = opcode.getDescription();
            ArrayList<String> tooltips = new ArrayList<String>();
            if (SafeClientTools.isSneaking()) {
                tooltips.addAll(description);
                for (ParameterDescription parameter : opcode.getParameters()) {
                    boolean first = true;
                    for (int i = 0; i < parameter.getDescription().size(); ++i) {
                        Object s = (String)parameter.getDescription().get(i);
                        if (first) {
                            s = ChatFormatting.BLUE + "Par '" + parameter.getName() + "': " + (String)s;
                            first = false;
                        } else {
                            s = ChatFormatting.BLUE + "      " + (String)s;
                        }
                        if (parameter.isOptional() && i == parameter.getDescription().size() - 1) {
                            s = (String)s + ChatFormatting.GOLD + " [Optional]";
                        }
                        tooltips.add((String)s);
                    }
                }
                tooltips.add(ChatFormatting.YELLOW + "Result: " + opcode.getOutputDescription());
            } else {
                tooltips.add((String)description.get(0));
                tooltips.add("<Shift for more info>");
            }
            return tooltips;
        }
        return Collections.emptyList();
    }

    private void selectIcon(Window parent, Widget<?> focused) {
        if (parent == this.window && focused instanceof IconHolder) {
            IconHolder iconHolder = (IconHolder)focused;
            this.clearEditorPanel();
            IIcon icon = iconHolder.getIcon();
            if (icon != null) {
                this.setEditorPanel(iconHolder, icon);
            }
        }
    }

    private Panel createValuePanel(ParameterDescription parameter, IIcon icon, IconHolder iconHolder, String tempDefault, boolean constantOnly) {
        Label label = (Label)((Label)Widgets.label((int)0, (int)0, (int)53, (int)13, (String)(StringUtils.capitalize((String)parameter.getName()) + ":")).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredHeight(13);
        ArrayList<CallSite> description = new ArrayList<CallSite>(parameter.getDescription());
        if (parameter.isOptional()) {
            description.set(description.size() - 1, (CallSite)((Object)((String)description.get(description.size() - 1) + ChatFormatting.GOLD + " [Optional]")));
        }
        if (tempDefault != null && !tempDefault.isEmpty()) {
            description.add((CallSite)((Object)(ChatFormatting.BLUE + tempDefault)));
        }
        String[] tooltips = description.toArray(new String[description.size()]);
        TextField field = ((TextField)((TextField)Widgets.textfield((int)0, (int)12, (int)68, (int)13).text(tempDefault).tooltips(tooltips)).desiredHeight(13)).editable(false);
        Button button = ((Button)((Button)Widgets.button((int)58, (int)0, (int)11, (int)13, (String)"...").desiredHeight(13)).tooltips(tooltips)).event(() -> this.openValueEditor(icon, iconHolder, parameter, field, constantOnly));
        return (Panel)((Panel)Widgets.positional().children(new Widget[]{label, field, button})).desiredWidth(68);
    }

    private void openValueEditor(IIcon icon, IconHolder iconHolder, ParameterDescription parameter, TextField field, boolean constantOnly) {
        Panel editPanel;
        ParameterEditor editor = ParameterEditors.getEditor(parameter.getType());
        if (editor != null) {
            editPanel = (Panel)Widgets.positional().filledRectThickness(1);
            Map data = icon.getData() == null ? Collections.emptyMap() : icon.getData();
            editor.build(this.f_96541_, (Screen)this, editPanel, o -> {
                icon.addData(parameter.getName(), (Object)o);
                field.text(ParameterTypeTools.stringRepresentation(parameter.getType(), o));
            });
            editor.writeValue((ParameterValue)data.get(parameter.getName()));
            if (constantOnly) {
                editor.constantOnly();
            }
        } else {
            return;
        }
        Panel panel = (Panel)((Panel)Widgets.vertical().filledBackground(-10066330, -5592406)).filledRectThickness(1);
        panel.bounds(50, 25, 200, 60 + editor.getHeight());
        Window modalWindow = this.getWindowManager().createModalWindow((AbstractContainerWidget)panel);
        panel.children(new Widget[]{Widgets.label((String)(StringUtils.capitalize((String)parameter.getName()) + ":")), editPanel, Widgets.button((String)"Close").event(() -> {
            this.getWindowManager().closeWindow(modalWindow);
            this.window.setTextFocus((Widget)iconHolder);
        })});
        editor.initialFocus(modalWindow);
        editor.setOnClose(() -> this.window.setTextFocus((Widget)iconHolder));
    }

    private void clearEditorPanel() {
        this.editorList.removeChildren();
    }

    private void setEditorPanel(IconHolder iconHolder, IIcon icon) {
        String id = icon.getID();
        Opcode opcode = Opcodes.OPCODES.get(id);
        Map data = icon.getData() == null ? Collections.emptyMap() : icon.getData();
        this.clearEditorPanel();
        for (ParameterDescription parameter : opcode.getParameters()) {
            String name = parameter.getName();
            ParameterValue value = (ParameterValue)data.get(name);
            Panel panel = value != null ? this.createValuePanel(parameter, icon, iconHolder, ParameterTypeTools.stringRepresentation(parameter.getType(), value), opcode.isEvent()) : this.createValuePanel(parameter, icon, iconHolder, "", opcode.isEvent());
            this.editorList.children(new Widget[]{panel});
        }
    }

    private Panel setupEditorPanel() {
        this.editorList = ((WidgetList)Widgets.list((int)0, (int)0, (int)75, (int)96).name("editor")).propagateEventsToChildren(true).rowheight(30);
        Slider slider = Widgets.slider((int)76, (int)0, (int)9, (int)96).scrollableName("editor");
        return (Panel)((Panel)((Panel)((Panel)Widgets.positional().hint(4, 137, 85, 96)).filledRectThickness(-1)).filledBackground(StyleConfig.colorListBackground)).children(new Widget[]{this.editorList, slider});
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.drawWindow(matrixStack);
        this.trashcan.setIcon(null);
        --this.saveCounter;
        if (this.saveCounter < 0) {
            this.saveCounter = 10;
            this.validateAndHilight();
            this.saveProgram(1, null);
        }
    }

    static {
        undoProgram = null;
        CONNECTION_ICONS.put(Connection.UP, (IIcon)new ImageIcon(Connection.UP.getId()).setImage(icons, 0, 100));
        CONNECTION_ICONS.put(Connection.UP_NEG, (IIcon)new ImageIcon(Connection.UP_NEG.getId()).setImage(icons, 0, 120));
        CONNECTION_ICONS.put(Connection.RIGHT, (IIcon)new ImageIcon(Connection.RIGHT.getId()).setImage(icons, 20, 100));
        CONNECTION_ICONS.put(Connection.RIGHT_NEG, (IIcon)new ImageIcon(Connection.RIGHT_NEG.getId()).setImage(icons, 20, 120));
        CONNECTION_ICONS.put(Connection.DOWN, (IIcon)new ImageIcon(Connection.DOWN.getId()).setImage(icons, 40, 100));
        CONNECTION_ICONS.put(Connection.DOWN_NEG, (IIcon)new ImageIcon(Connection.DOWN_NEG.getId()).setImage(icons, 40, 120));
        CONNECTION_ICONS.put(Connection.LEFT, (IIcon)new ImageIcon(Connection.LEFT.getId()).setImage(icons, 60, 100));
        CONNECTION_ICONS.put(Connection.LEFT_NEG, (IIcon)new ImageIcon(Connection.LEFT_NEG.getId()).setImage(icons, 60, 120));
        HIGHLIGHT_ICONS.put(Connection.UP, (IIcon)new ImageIcon("H").setImage(icons, 0, 140));
        HIGHLIGHT_ICONS.put(Connection.RIGHT, (IIcon)new ImageIcon("H").setImage(icons, 20, 140));
        HIGHLIGHT_ICONS.put(Connection.DOWN, (IIcon)new ImageIcon("H").setImage(icons, 40, 140));
        HIGHLIGHT_ICONS.put(Connection.LEFT, (IIcon)new ImageIcon("H").setImage(icons, 60, 140));
        for (IIcon icon : CONNECTION_ICONS.values()) {
            ((ImageIcon)icon).setDimensions(20, 20);
        }
        for (IIcon icon : HIGHLIGHT_ICONS.values()) {
            ((ImageIcon)icon).setDimensions(20, 20);
        }
        selectionIcon = new ImageIcon("S").setDimensions(20, 20).setImage(icons, 0, 160);
        errorIcon1 = new ImageIcon("E1").setDimensions(20, 20).setImage(icons, 20, 160);
        errorIcon2 = new ImageIcon("E2").setDimensions(20, 20).setImage(icons, 40, 160);
    }
}

