/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.variablemodule;

import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolscontrol.compat.rftoolssupport.ModuleDataVariable;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class VariableScreenModule
implements IScreenModule<ModuleDataVariable> {
    private ResourceKey<Level> dim = Level.f_46428_;
    private BlockPos coordinate = BlockPosTools.INVALID;
    private int varIdx = -1;

    public ModuleDataVariable getData(IScreenDataHelper h, Level worldObj, long millis) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, this.dim);
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return null;
        }
        Block block = world.m_8055_(this.coordinate).m_60734_();
        if (block != ProcessorModule.PROCESSOR.get()) {
            return null;
        }
        if (this.varIdx < 0 || this.varIdx >= 32) {
            return null;
        }
        BlockEntity te = world.m_7702_(this.coordinate);
        if (te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            Parameter parameter = processor.getParameter(this.varIdx);
            return new ModuleDataVariable(parameter);
        }
        return null;
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.varIdx = tagCompound.m_128441_("varIdx") ? tagCompound.m_128451_("varIdx") : -1;
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.m_128441_("monitorx")) {
                this.dim = tagCompound.m_128441_("monitordim") ? LevelTools.getId((String)tagCompound.m_128461_("monitordim")) : LevelTools.getId((String)tagCompound.m_128461_("dim"));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
                    int dx = Math.abs(c.m_123341_() - pos.m_123341_());
                    int dy = Math.abs(c.m_123342_() - pos.m_123342_());
                    int dz = Math.abs(c.m_123343_() - pos.m_123343_());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)Config.VARIABLEMODULE_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
    }
}

