/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.model;

import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class JetpackModel
extends HumanoidModel<LivingEntity> {
    private static final String MIDDLE = "middle";
    private static final String LEFT_CANISTER = "left_canister";
    private static final String RIGHT_CANISTER = "right_canister";
    private static final String LEFT_TIP_1 = "left_tip_1";
    private static final String LEFT_TIP_2 = "left_tip_2";
    private static final String RIGHT_TIP_1 = "right_tip_1";
    private static final String RIGHT_TIP_2 = "right_tip_2";
    private static final String LEFT_EXHAUST_1 = "left_exhaust_1";
    private static final String LEFT_EXHAUST_2 = "left_exhaust_2";
    private static final String RIGHT_EXHAUST_1 = "right_exhaust_1";
    private static final String RIGHT_EXHAUST_2 = "right_exhaust_2";
    private final ModelPart middle;
    private final ModelPart leftCanister;
    private final ModelPart rightCanister;
    private final ModelPart leftTip1;
    private final ModelPart leftTip2;
    private final ModelPart rightTip1;
    private final ModelPart rightTip2;
    private final ModelPart leftExhaust1;
    private final ModelPart leftExhaust2;
    private final ModelPart rightExhaust1;
    private final ModelPart rightExhaust2;
    private final ModelPart[] energyBarLeft = new ModelPart[6];
    private final ModelPart[] energyBarRight = new ModelPart[6];

    public JetpackModel(ModelPart part) {
        super(part);
        this.middle = part.m_171324_(MIDDLE);
        this.leftCanister = part.m_171324_(LEFT_CANISTER);
        this.rightCanister = part.m_171324_(RIGHT_CANISTER);
        this.leftTip1 = part.m_171324_(LEFT_TIP_1);
        this.leftTip2 = part.m_171324_(LEFT_TIP_2);
        this.rightTip1 = part.m_171324_(RIGHT_TIP_1);
        this.rightTip2 = part.m_171324_(RIGHT_TIP_2);
        this.leftExhaust1 = part.m_171324_(LEFT_EXHAUST_1);
        this.leftExhaust2 = part.m_171324_(LEFT_EXHAUST_2);
        this.rightExhaust1 = part.m_171324_(RIGHT_EXHAUST_1);
        this.rightExhaust2 = part.m_171324_(RIGHT_EXHAUST_2);
        for (int i = 0; i < 6; ++i) {
            this.energyBarLeft[i] = part.m_171324_("left_energy_bar_" + i);
            this.energyBarRight[i] = part.m_171324_("right_energy_bar_" + i);
        }
    }

    public void m_6973_(LivingEntity entity, float f1, float f2, float f3, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, f1, f2, f3, netHeadYaw, headPitch);
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        Jetpack jetpack = JetpackUtils.getJetpack(chest);
        if (jetpack.creative) {
            this.resetEnergyBars();
            this.energyBarLeft[5].f_104207_ = true;
            this.energyBarRight[5].f_104207_ = true;
        } else {
            IEnergyStorage energy = JetpackUtils.getEnergyStorage(chest);
            double stored = (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
            int state = 0;
            if (stored > 0.8) {
                state = 5;
            } else if (stored > 0.6) {
                state = 4;
            } else if (stored > 0.4) {
                state = 3;
            } else if (stored > 0.2) {
                state = 2;
            } else if (stored > 0.0) {
                state = 1;
            }
            this.resetEnergyBars();
            this.energyBarLeft[state].f_104207_ = true;
            this.energyBarRight[state].f_104207_ = true;
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        this.middle.m_104315_(this.f_102810_);
        this.leftCanister.m_104315_(this.middle);
        this.rightCanister.m_104315_(this.middle);
        this.leftTip1.m_104315_(this.middle);
        this.leftTip2.m_104315_(this.middle);
        this.rightTip1.m_104315_(this.middle);
        this.rightTip2.m_104315_(this.middle);
        this.leftExhaust1.m_104315_(this.middle);
        this.leftExhaust2.m_104315_(this.middle);
        this.rightExhaust1.m_104315_(this.middle);
        this.rightExhaust2.m_104315_(this.middle);
        ImmutableList.Builder parts = ImmutableList.builder();
        parts.add((Object[])new ModelPart[]{this.f_102810_, this.middle, this.leftCanister, this.rightCanister, this.leftTip1, this.leftTip2, this.rightTip1, this.rightTip2, this.leftExhaust1, this.leftExhaust2, this.rightExhaust1, this.rightExhaust2, this.f_102812_, this.f_102811_});
        for (int i = 0; i < 6; ++i) {
            parts.add((Object)this.energyBarLeft[i]);
            parts.add((Object)this.energyBarRight[i]);
        }
        return parts.build();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f);
        PartDefinition root = mesh.m_171576_();
        root.m_171599_(MIDDLE, CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 54).m_171481_(-2.0f, 5.0f, 3.6f, 4.0f, 3.0f, 2.0f), PartPose.f_171404_);
        root.m_171599_(LEFT_CANISTER, CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 32).m_171481_(0.5f, 2.0f, 2.6f, 4.0f, 7.0f, 4.0f), PartPose.f_171404_);
        root.m_171599_(RIGHT_CANISTER, CubeListBuilder.m_171558_().m_171480_().m_171514_(17, 32).m_171481_(-4.5f, 2.0f, 2.6f, 4.0f, 7.0f, 4.0f), PartPose.f_171404_);
        root.m_171599_(LEFT_TIP_1, CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 45).m_171481_(1.0f, 0.0f, 3.1f, 3.0f, 2.0f, 3.0f), PartPose.f_171404_);
        root.m_171599_(LEFT_TIP_2, CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 50).m_171481_(1.5f, -1.0f, 3.6f, 2.0f, 1.0f, 2.0f), PartPose.f_171404_);
        root.m_171599_(RIGHT_TIP_1, CubeListBuilder.m_171558_().m_171480_().m_171514_(17, 45).m_171481_(-4.0f, 0.0f, 3.1f, 3.0f, 2.0f, 3.0f), PartPose.f_171404_);
        root.m_171599_(RIGHT_TIP_2, CubeListBuilder.m_171558_().m_171480_().m_171514_(17, 50).m_171481_(-3.5f, -1.0f, 3.6f, 2.0f, 1.0f, 2.0f), PartPose.f_171404_);
        root.m_171599_(LEFT_EXHAUST_1, CubeListBuilder.m_171558_().m_171480_().m_171514_(35, 32).m_171481_(1.0f, 9.0f, 3.1f, 3.0f, 1.0f, 3.0f), PartPose.f_171404_);
        root.m_171599_(LEFT_EXHAUST_2, CubeListBuilder.m_171558_().m_171480_().m_171514_(35, 37).m_171481_(0.5f, 10.0f, 2.6f, 4.0f, 3.0f, 4.0f), PartPose.f_171404_);
        root.m_171599_(RIGHT_EXHAUST_1, CubeListBuilder.m_171558_().m_171480_().m_171514_(48, 32).m_171481_(-4.0f, 9.0f, 3.1f, 3.0f, 1.0f, 3.0f), PartPose.f_171404_);
        root.m_171599_(RIGHT_EXHAUST_2, CubeListBuilder.m_171558_().m_171480_().m_171514_(35, 45).m_171481_(-4.5f, 10.0f, 2.6f, 4.0f, 3.0f, 4.0f), PartPose.f_171404_);
        for (int i = 0; i < 6; ++i) {
            root.m_171599_("left_energy_bar_" + i, CubeListBuilder.m_171558_().m_171514_(16 + i * 4, 55).m_171481_(2.0f, 3.0f, 5.8f, 1.0f, 5.0f, 1.0f), PartPose.f_171404_);
            root.m_171599_("right_energy_bar_" + i, CubeListBuilder.m_171558_().m_171514_(16 + i * 4, 55).m_171481_(-3.0f, 3.0f, 5.8f, 1.0f, 5.0f, 1.0f), PartPose.f_171404_);
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    private void resetEnergyBars() {
        for (int i = 0; i < 6; ++i) {
            this.energyBarLeft[i].f_104207_ = false;
            this.energyBarRight[i].f_104207_ = false;
        }
    }
}

