/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.crafting.ingredient.JetpackTierIngredient;
import com.blakebr0.ironjetpacks.crafting.recipe.JetpackUpgradeRecipe;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class DynamicRecipeManager {
    private static final DynamicRecipeManager INSTANCE = new DynamicRecipeManager();

    public void onResourceManagerReload(ResourceManager manager) {
        JetpackRegistry.getInstance().getJetpacks().forEach(jetpack -> {
            ShapedRecipe cell = DynamicRecipeManager.makeCellRecipe(jetpack);
            ShapedRecipe thruster = DynamicRecipeManager.makeThrusterRecipe(jetpack);
            ShapedRecipe capacitor = DynamicRecipeManager.makeCapacitorRecipe(jetpack);
            ShapedRecipe jetpackSelf = DynamicRecipeManager.makeJetpackRecipe(jetpack);
            JetpackUpgradeRecipe jetpackUpgrade = DynamicRecipeManager.makeJetpackUpgradeRecipe(jetpack);
            if (cell != null) {
                RecipeHelper.addRecipe((Recipe)cell);
            }
            if (thruster != null) {
                RecipeHelper.addRecipe((Recipe)thruster);
            }
            if (capacitor != null) {
                RecipeHelper.addRecipe((Recipe)capacitor);
            }
            if (jetpackSelf != null) {
                RecipeHelper.addRecipe((Recipe)jetpackSelf);
            }
            if (jetpackUpgrade != null) {
                RecipeHelper.addRecipe((Recipe)jetpackUpgrade);
            }
        });
    }

    public static DynamicRecipeManager getInstance() {
        return INSTANCE;
    }

    private static ShapedRecipe makeCellRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_CELL_RECIPES.get()).booleanValue()) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        Tag redstoneTag = SerializationTags.m_13199_().m_144452_(Registry.f_122904_).m_13404_(Tags.Items.DUSTS_REDSTONE.m_6979_());
        if (redstoneTag == null) {
            return null;
        }
        Ingredient coil = Ingredient.m_43929_((ItemLike[])new ItemLike[]{jetpacks.getCoilForTier(jetpack.tier)});
        Ingredient redstone = Ingredient.m_43911_((Tag)redstoneTag);
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.f_43901_, redstone, Ingredient.f_43901_, material, coil, material, Ingredient.f_43901_, redstone, Ingredient.f_43901_});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_cell");
        ItemStack output = JetpackUtils.getItemForComponent((Item)ModItems.CELL.get(), jetpack);
        return new ShapedRecipe(name, "ironjetpacks:cells", 3, 3, inputs, output);
    }

    private static ShapedRecipe makeThrusterRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_THRUSTER_RECIPES.get()).booleanValue()) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        Ingredient coil = Ingredient.m_43929_((ItemLike[])new ItemLike[]{jetpacks.getCoilForTier(jetpack.tier)});
        NBTIngredient cell = new NBTIngredient(JetpackUtils.getItemForComponent((Item)ModItems.CELL.get(), jetpack));
        Ingredient furnace = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50094_});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, coil, material, coil, cell, coil, material, furnace, material});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_thruster");
        ItemStack output = JetpackUtils.getItemForComponent((Item)ModItems.THRUSTER.get(), jetpack);
        return new ShapedRecipe(name, "ironjetpacks:thrusters", 3, 3, inputs, output);
    }

    private static ShapedRecipe makeCapacitorRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_CAPACITOR_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        NBTIngredient cell = new NBTIngredient(JetpackUtils.getItemForComponent((Item)ModItems.CELL.get(), jetpack));
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, cell, material, material, cell, material, material, cell, material});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_capacitor");
        ItemStack output = JetpackUtils.getItemForComponent((Item)ModItems.CAPACITOR.get(), jetpack);
        return new ShapedRecipe(name, "ironjetpacks:capacitors", 3, 3, inputs, output);
    }

    private static ShapedRecipe makeJetpackRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_JETPACK_RECIPES.get()).booleanValue()) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        if (jetpack.tier != jetpacks.getLowestTier()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        NBTIngredient capacitor = new NBTIngredient(JetpackUtils.getItemForComponent((Item)ModItems.CAPACITOR.get(), jetpack));
        NBTIngredient thruster = new NBTIngredient(JetpackUtils.getItemForComponent((Item)ModItems.THRUSTER.get(), jetpack));
        Ingredient strap = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAP.get()});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, capacitor, material, material, strap, material, thruster, Ingredient.f_43901_, thruster});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_jetpack");
        ItemStack output = JetpackUtils.getItemForJetpack(jetpack);
        return new ShapedRecipe(name, "ironjetpacks:jetpacks", 3, 3, inputs, output);
    }

    private static JetpackUpgradeRecipe makeJetpackUpgradeRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_JETPACK_RECIPES.get()).booleanValue()) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        if (jetpack.tier == jetpacks.getLowestTier()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        NBTIngredient capacitor = new NBTIngredient(JetpackUtils.getItemForComponent((Item)ModItems.CAPACITOR.get(), jetpack));
        NBTIngredient thruster = new NBTIngredient(JetpackUtils.getItemForComponent((Item)ModItems.THRUSTER.get(), jetpack));
        JetpackTierIngredient jetpackTier = new JetpackTierIngredient(jetpack.tier - 1);
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, capacitor, material, material, jetpackTier, material, thruster, Ingredient.f_43901_, thruster});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_jetpack");
        ItemStack output = JetpackUtils.getItemForJetpack(jetpack);
        return new JetpackUpgradeRecipe(name, "ironjetpacks:jetpacks", 3, 3, (NonNullList<Ingredient>)inputs, output);
    }

    private static class NBTIngredient
    extends net.minecraftforge.common.crafting.NBTIngredient {
        protected NBTIngredient(ItemStack stack) {
            super(stack);
        }
    }
}

