/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.norecipeadvancements.mixin;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.permutated.norecipeadvancements.NoRecipeAdvancements;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ServerAdvancementManager.class})
public class MixinAdvancementManager {
    @Final
    @Shadow
    private static Logger f_136021_;
    @Shadow
    private AdvancementList f_136023_;
    @Final
    @Shadow
    private PredicateManager f_136024_;

    @Overwrite
    protected void m_5787_(Map<ResourceLocation, JsonElement> datapacks, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        AtomicInteger recipeAdvancements = new AtomicInteger();
        datapacks.forEach((location, jsonElement) -> {
            try {
                JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"advancement");
                Advancement.Builder advancement$builder = Advancement.Builder.m_138380_((JsonObject)jsonobject, (DeserializationContext)new DeserializationContext(location, this.f_136024_));
                if (advancement$builder == null) {
                    f_136021_.debug("Skipping loading advancement {} as it's conditions were not met", location);
                    return;
                }
                if (advancement$builder.m_138405_().containsKey("has_the_recipe")) {
                    recipeAdvancements.incrementAndGet();
                    return;
                }
                map.put(location, advancement$builder);
            }
            catch (Exception exception) {
                f_136021_.error("Parsing error loading custom advancement {}: {}", location, (Object)exception.getMessage());
            }
        });
        AdvancementList advancementlist = new AdvancementList();
        advancementlist.m_139333_((Map)map);
        NoRecipeAdvancements.LOGGER.info("Skipped loading {} recipe advancements.", (Object)recipeAdvancements.get());
        for (Advancement advancement : advancementlist.m_139343_()) {
            if (advancement.m_138320_() == null) continue;
            TreeNodePosition.m_16587_((Advancement)advancement);
        }
        this.f_136023_ = advancementlist;
    }
}

