/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.Main;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.api.lunarevent.client.LunarEventClientSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HarvestMoon
extends LunarEvent {
    public static final Codec<HarvestMoon> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LunarEventClientSettings.CODEC.fieldOf("clientSettings").forGetter(clientSettings -> clientSettings.getClientSettings()), (App)Codec.INT.fieldOf("minNumberOfNightsBetween").forGetter(clientSettings -> clientSettings.getMinNumberOfNightsBetween()), (App)Codec.DOUBLE.fieldOf("chance").forGetter(clientSettings -> clientSettings.getChance()), (App)Codec.list((Codec)Codec.INT).fieldOf("validMoonPhases").forGetter(clientSettings -> new ArrayList<Integer>(clientSettings.getValidMoonPhases())), (App)LunarTextComponents.CODEC.fieldOf("textComponents").forGetter(blueMoon -> blueMoon.getTextComponents()), (App)Codec.BOOL.fieldOf("blockSleeping").forGetter(clientSettings -> clientSettings.blockSleeping()), (App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("enhancedCrops").forGetter(clientSettings -> new ArrayList<ResourceLocation>(clientSettings.cropTags)), (App)Codec.DOUBLE.fieldOf("cropDropMultiplier").orElse((Object)2.5).forGetter(clientSettings -> clientSettings.cropDropMultiplier)).apply((Applicative)builder, HarvestMoon::new));
    private final List<Object> enhancedCrops = new ArrayList<Object>();
    private final Collection<ResourceLocation> cropTags;
    private final double cropDropMultiplier;

    public HarvestMoon(LunarEventClientSettings clientSettings, int minNumberOfNightsBetween, double chance, Collection<Integer> validMoonPhases, LunarTextComponents lunarTextComponents, boolean blockSleeping, Collection<ResourceLocation> cropTags, double cropDropMultiplier) {
        this(clientSettings, minNumberOfNightsBetween, chance, validMoonPhases, lunarTextComponents, blockSleeping, cropTags, cropDropMultiplier, true);
    }

    public HarvestMoon(LunarEventClientSettings clientSettings, int minNumberOfNightsBetween, double chance, Collection<Integer> validMoonPhases, LunarTextComponents lunarTextComponents, boolean blockSleeping, Collection<ResourceLocation> cropTags, double cropDropMultiplier, boolean serializeCrops) {
        super(clientSettings, minNumberOfNightsBetween, chance, validMoonPhases, lunarTextComponents, blockSleeping);
        this.cropTags = cropTags;
        this.cropDropMultiplier = cropDropMultiplier;
        if (serializeCrops) {
            for (ResourceLocation tagID : cropTags) {
                if (tagID.m_135815_().contains("item_tag_")) {
                    tagID = new ResourceLocation(tagID.m_135827_(), tagID.m_135815_().replace("item_tag_", ""));
                    Map allTags = ItemTags.m_13193_().m_5643_();
                    if (allTags.containsKey(tagID)) {
                        this.enhancedCrops.add(allTags.get(tagID));
                        continue;
                    }
                    Main.LOGGER.error("\"" + tagID + "\" is not a valid item tag!");
                    continue;
                }
                Optional optional = Registry.f_122827_.m_6612_(tagID = new ResourceLocation(tagID.m_135827_(), tagID.m_135815_()));
                if (optional.isPresent()) {
                    this.enhancedCrops.add(optional.get());
                    continue;
                }
                Main.LOGGER.error("\"" + tagID + "\" is not a valid item ID!");
            }
        }
    }

    @Override
    public void onBlockItemDrop(ServerLevel world, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        for (Object enhancedCrop : this.enhancedCrops) {
            if (enhancedCrop instanceof Tag) {
                if (!((Tag)enhancedCrop).m_8110_((Object)item)) continue;
                itemStack.m_41764_((int)((double)itemStack.m_41613_() * this.cropDropMultiplier));
                break;
            }
            if (!(enhancedCrop instanceof Item) || enhancedCrop != item) continue;
            itemStack.m_41764_((int)((double)itemStack.m_41613_() * this.cropDropMultiplier));
            break;
        }
        super.onBlockItemDrop(world, itemStack);
    }

    @Override
    public Codec<? extends LunarEvent> codec() {
        return CODEC;
    }
}

