/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.mixin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import corgitaco.enhancedcelestials.Main;
import corgitaco.enhancedcelestials.mixin.access.JsonReloadListenerAccess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.LootTables;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LootTables.class})
public abstract class MixinLootTableManager
extends SimpleJsonResourceReloadListener {
    public MixinLootTableManager(Gson gson, String string) {
        super(gson, string);
    }

    @Inject(method={"apply"}, at={@At(value="HEAD")})
    private void appendTables(Map<ResourceLocation, JsonElement> values, ResourceManager resourceManager, ProfilerFiller profilerFiller, CallbackInfo ci) {
        String appendTablesDir = "append_loot_tables";
        Collection resourceLocations = resourceManager.m_6540_(appendTablesDir, key -> key.endsWith(".json"));
        for (ResourceLocation resourceLocation : resourceLocations) {
            ResourceLocation key2 = new ResourceLocation(resourceLocation.m_135815_().replace(appendTablesDir + "/", "").replaceFirst("/", ":").replace(".json", ""));
            if (!values.containsKey(key2)) continue;
            values.get(key2).getAsJsonObject().getAsJsonArray("pools").addAll(this.extractPools(resourceManager, resourceLocation));
        }
    }

    private JsonArray extractPools(ResourceManager resourceManager, ResourceLocation location) {
        JsonArray jsonArray;
        block8: {
            Resource appendedTable = resourceManager.m_142591_(location);
            try {
                InputStream inputstream = appendedTable.m_6679_();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                JsonElement appendedElement = (JsonElement)GsonHelper.m_13776_((Gson)((JsonReloadListenerAccess)((Object)this)).getGson(), (Reader)reader, JsonElement.class);
                jsonArray = appendedElement.getAsJsonObject().getAsJsonArray("pools");
                if (appendedTable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (appendedTable != null) {
                        try {
                            appendedTable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Main.LOGGER.error("Could not read appended table:" + location.toString());
                    e.printStackTrace();
                    return new JsonArray();
                }
            }
            appendedTable.close();
        }
        return jsonArray;
    }
}

