/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.network.packet;

import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class LunarContextConstructionPacket {
    private final LunarContext lunarContext;

    public LunarContextConstructionPacket(LunarContext lunarContext) {
        this.lunarContext = lunarContext;
    }

    public static void writeToPacket(LunarContextConstructionPacket packet, FriendlyByteBuf buf) {
        try {
            buf.m_130059_(LunarContext.PACKET_CODEC, (Object)packet.lunarContext);
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Context packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static LunarContextConstructionPacket readFromPacket(FriendlyByteBuf buf) {
        try {
            return new LunarContextConstructionPacket((LunarContext)buf.m_130057_(LunarContext.PACKET_CODEC));
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Context packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static void handle(LunarContextConstructionPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                LunarContext lunarContext;
                Minecraft minecraft = Minecraft.m_91087_();
                ClientLevel world = minecraft.f_91073_;
                if (world != null && minecraft.f_91074_ != null && (lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext()) == null) {
                    ((EnhancedCelestialsWorldData)world).setLunarContext(new LunarContext(message.lunarContext.getLunarForecast(), message.lunarContext.getLunarTimeSettings(), world.m_46472_().m_135782_(), message.lunarContext.getLunarEvents(), true));
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

