/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.network.packet;

import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.LunarForecast;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class LunarForecastChangedPacket {
    private final LunarForecast lunarForecast;

    public LunarForecastChangedPacket(LunarForecast lunarForecast) {
        this.lunarForecast = lunarForecast;
    }

    public static void writeToPacket(LunarForecastChangedPacket packet, FriendlyByteBuf buf) {
        try {
            buf.m_130059_(LunarForecast.CODEC, (Object)packet.lunarForecast);
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static LunarForecastChangedPacket readFromPacket(FriendlyByteBuf buf) {
        try {
            return new LunarForecastChangedPacket((LunarForecast)buf.m_130057_(LunarForecast.CODEC));
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static void handle(LunarForecastChangedPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                LunarContext lunarContext;
                Minecraft minecraft = Minecraft.m_91087_();
                ClientLevel world = minecraft.f_91073_;
                if (world != null && minecraft.f_91074_ != null && (lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext()) != null) {
                    lunarContext.getLunarForecast().getForecast().clear();
                    lunarContext.getLunarForecast().getForecast().addAll(message.lunarForecast.getForecast());
                    lunarContext.getLunarForecast().setLastCheckedGameTime(message.lunarForecast.getLastCheckedGameTime());
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

