/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.Constants;
import com.leobeliik.extremesoundmuffler.SoundMufflerCommon;
import com.leobeliik.extremesoundmuffler.gui.buttons.MuffledSlider;
import com.leobeliik.extremesoundmuffler.interfaces.IColorsGui;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import com.leobeliik.extremesoundmuffler.utils.DataManager;
import com.leobeliik.extremesoundmuffler.utils.Tips;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MufflerScreen
extends Screen
implements ISoundLists,
IColorsGui {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static boolean isMuffling = true;
    private static String screenTitle;
    private static String toggleSoundsListMessage;
    private final int xSize = 256;
    private final int ySize = 202;
    private final boolean isAnchorsDisabled = CommonConfig.get().disableAnchors().get();
    private int minYButton;
    private int maxYButton;
    private int index;
    private Button btnTMS;
    private Button btnDelete;
    private Button btnCSL;
    private Button btnSetAnchor;
    private Button btnEditAnchor;
    private Button btnNextSounds;
    private Button btnPrevSounds;
    private Button btnAccept;
    private Button btnCancel;
    private Button btnAnchor;
    private EditBox searchBar;
    private EditBox editAnchorTitleBar;
    private EditBox editRadBar;
    private MuffledSlider firstSoundButton;
    private MuffledSlider lastSoundButton;
    private Anchor anchor;
    private String tip;

    private MufflerScreen(Component title, Anchor anchor) {
        super(title);
        screenTitle = title.getString();
        this.anchor = anchor;
        minecraft.m_91152_((Screen)this);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.minYButton = this.getY() + 46;
        this.maxYButton = this.getY() + 164;
        MufflerScreen.minecraft.f_91068_.m_90926_(true);
        this.addButtons();
        this.addSideButtons();
        this.addAnchorButtons();
        this.addSoundListButtons();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        SoundMufflerCommon.renderGui();
        this.m_93228_(stack, this.getX(), this.getY(), 0, 0, 256, 202);
        this.renderSideScreen(stack, mouseX, mouseY);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        MufflerScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)screenTitle, (int)(this.getX() + 128), (int)(this.getY() + 8), (int)0xFFFFFF);
        this.renderTips(stack);
        this.renderButtons(stack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.editRadBar.m_94153_(s -> s.matches("[0-9]*(?:[0-9]*)?"));
        if (keyCode == 257 || keyCode == 335) {
            this.searchBar.m_94178_(false);
            this.editAnchorTitleBar.m_94178_(false);
            this.editRadBar.m_94178_(false);
            return true;
        }
        if (!(this.searchBar.m_93696_() || this.editAnchorTitleBar.m_93696_() || this.editRadBar.m_93696_() || !MufflerScreen.minecraft.f_91066_.f_92092_.m_90832_(keyCode, scanCode) && !Constants.soundMufflerKey.m_90832_(keyCode, scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.m_93696_()) {
            this.updateButtons();
        }
        if (!this.editRadBar.m_94155_().isEmpty()) {
            int Radius = Integer.parseInt(this.editRadBar.m_94155_());
            this.editRadBar.m_94202_(Radius > 32 || Radius < 1 ? 65535 : 0xFFFFFF);
        } else {
            this.editRadBar.m_94202_(0xFFFFFF);
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double direction) {
        if (this.firstSoundButton == null) {
            return false;
        }
        if (direction > 0.0 && this.firstSoundButton.f_93621_ == this.minYButton || direction < 0.0 && this.lastSoundButton.f_93621_ <= this.maxYButton) {
            return false;
        }
        this.m_6702_().stream().filter(b -> b instanceof MuffledSlider).map(b -> (MuffledSlider)b).forEach(b -> {
            b.setY((int)((double)b.f_93621_ + (double)(b.m_93694_() * 10) * Mth.m_14008_((double)direction, (double)-1.0, (double)1.0)));
            b.isVisible(b.f_93621_ >= this.minYButton && b.f_93621_ <= this.maxYButton);
        });
        return super.m_6050_(mouseX, mouseY, direction);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            if (this.searchBar.m_93696_()) {
                this.searchBar.m_94144_("");
                this.updateButtons();
                return true;
            }
            if (this.editAnchorTitleBar.m_93696_()) {
                this.editAnchorTitleBar.m_94144_("");
                return true;
            }
            if (this.editRadBar.m_198029_()) {
                this.editRadBar.m_94144_("");
                return true;
            }
        } else {
            this.searchBar.m_94178_(this.searchBar.m_5953_(mouseX, mouseY));
            this.editAnchorTitleBar.m_94178_(this.editAnchorTitleBar.m_5953_(mouseX, mouseY));
            this.editRadBar.m_94178_(this.editRadBar.m_5953_(mouseX, mouseY));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        DataManager.saveData();
        super.m_7379_();
    }

    private void open(Component title, Anchor anchor) {
        new MufflerScreen(title, anchor);
    }

    public static void open() {
        new MufflerScreen(Component.m_130674_((String)"ESM - Main Screen"), null);
    }

    private void addButtons() {
        this.btnCSL = new Button(this.getX() + 13, this.getY() + 181, 52, 13, Component.m_130674_((String)"Recent"), b -> {
            boolean isAnchorMuffling = this.anchor != null && !this.anchor.getMuffledSounds().isEmpty();
            switch (this.btnCSL.m_6035_().getString()) {
                case "Recent": {
                    toggleSoundsListMessage = "All";
                    break;
                }
                case "All": {
                    toggleSoundsListMessage = "Muffled";
                    break;
                }
                default: {
                    toggleSoundsListMessage = "Recent";
                }
            }
            b.m_93666_(Component.m_130674_((String)toggleSoundsListMessage));
            this.updateButtons();
        });
        this.m_7787_((GuiEventListener)this.btnCSL);
        this.searchBar = new EditBox(this.f_96547_, this.getX() + 74, this.getY() + 183, 119, 13, TextComponent.f_131282_);
        ((EditBox)this.m_142416_((GuiEventListener)this.searchBar)).m_94182_(false);
        this.btnTMS = new Button(this.getX() + 229, this.getY() + 180, 17, 17, Component.m_130674_((String)"Stop muffing"), b -> {
            isMuffling = !isMuffling;
        });
        this.m_7787_((GuiEventListener)this.btnTMS);
        this.btnDelete = new Button(this.getX() + 205, this.getY() + 180, 17, 17, Component.m_130674_((String)"Delete muffled sounds"), b -> {
            if (MufflerScreen.m_96638_()) {
                recentSoundsList.clear();
            } else if (this.anchor == null) {
                muffledSounds.clear();
            } else {
                this.anchor.deleteAnchor();
            }
            this.updateButtons();
        });
        this.m_7787_((GuiEventListener)this.btnDelete);
        this.btnPrevSounds = new Button(this.getX() + 10, this.getY() + 22, 13, 20, TextComponent.f_131282_, b -> this.m_6050_(0.0, 0.0, 1.0));
        this.m_7787_((GuiEventListener)this.btnPrevSounds);
        this.btnNextSounds = new Button(this.getX() + 233, this.getY() + 22, 13, 20, TextComponent.f_131282_, b -> this.m_6050_(0.0, 0.0, -1.0));
        this.m_7787_((GuiEventListener)this.btnNextSounds);
    }

    private void addSideButtons() {
        this.btnSetAnchor = new Button(this.getX() + 261, this.getY() + 62, 11, 11, TextComponent.f_131282_, b -> this.anchor.setAnchor());
        ((Button)this.m_7787_((GuiEventListener)new Button(this.getX() + 261, this.getY() + 62, 11, 11, TextComponent.f_131282_, b -> this.anchor.setAnchor()))).f_93623_ = false;
        this.btnEditAnchor = new Button(this.getX() + 275, this.getY() + 62, 11, 11, TextComponent.f_131282_, b -> this.editTitle());
        ((Button)this.m_7787_((GuiEventListener)new Button(this.getX() + 275, this.getY() + 62, 11, 11, TextComponent.f_131282_, b -> this.editTitle()))).f_93623_ = false;
        this.editAnchorTitleBar = new EditBox(this.f_96547_, this.getX() + 302, this.btnEditAnchor.f_93621_ + 20, 84, 11, TextComponent.f_131282_);
        ((EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.getX() + 302, this.btnEditAnchor.f_93621_ + 20, 84, 11, TextComponent.f_131282_))).f_93624_ = false;
        this.editRadBar = new EditBox(this.f_96547_, this.getX() + 302, this.editAnchorTitleBar.f_93621_ + 15, 30, 11, TextComponent.f_131282_);
        ((EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.getX() + 302, this.editAnchorTitleBar.f_93621_ + 15, 30, 11, TextComponent.f_131282_))).f_93624_ = false;
        this.btnAccept = new Button(this.getX() + 259, this.editRadBar.f_93621_ + 15, 40, 20, Component.m_130674_((String)"Accept"), b -> {
            if (!this.editAnchorTitleBar.m_94155_().isEmpty() && !this.editRadBar.m_94155_().isEmpty() && this.anchor != null) {
                this.anchor.editAnchor(this.editAnchorTitleBar.m_94155_(), Mth.m_14045_((int)Integer.parseInt(this.editRadBar.m_94155_()), (int)1, (int)32));
                screenTitle = this.editAnchorTitleBar.m_94155_();
                this.editTitle();
            }
        });
        ((Button)this.m_142416_((GuiEventListener)new Button(this.getX() + 259, this.editRadBar.f_93621_ + 15, 40, 20, Component.m_130674_((String)"Accept"), b -> {
            if (!this.editAnchorTitleBar.m_94155_().isEmpty() && !this.editRadBar.m_94155_().isEmpty() && this.anchor != null) {
                this.anchor.editAnchor(this.editAnchorTitleBar.m_94155_(), Mth.m_14045_((int)Integer.parseInt(this.editRadBar.m_94155_()), (int)1, (int)32));
                screenTitle = this.editAnchorTitleBar.m_94155_();
                this.editTitle();
            }
        }))).f_93624_ = false;
        this.btnCancel = new Button(this.getX() + 300, this.editRadBar.f_93621_ + 15, 40, 20, Component.m_130674_((String)"Cancel"), b -> this.editTitle());
        ((Button)this.m_142416_((GuiEventListener)new Button(this.getX() + 300, this.editRadBar.f_93621_ + 15, 40, 20, Component.m_130674_((String)"Cancel"), b -> this.editTitle()))).f_93624_ = false;
    }

    private void addAnchorButtons() {
        int buttonW = this.getX() + 30;
        for (int i = 0; i <= 9; ++i) {
            if (this.isAnchorsDisabled) {
                String[] disabledMsg = new String[]{"-", "D", "i", "s", "a", "b", "l", "e", "d", "-"};
                this.btnAnchor = new Button(buttonW, this.getY() + 24, 16, 16, Component.m_130674_((String)disabledMsg[i]), b -> {});
                this.btnAnchor.f_93623_ = false;
            } else {
                int finalI = i;
                this.btnAnchor = new Button(buttonW, this.getY() + 24, 16, 16, Component.m_130674_((String)String.valueOf(i)), b -> {
                    this.anchor = (Anchor)anchorList.get(finalI);
                    this.hideSideButtons();
                    if (screenTitle.equals(this.anchor.getName())) {
                        this.anchor = null;
                        screenTitle = "ESM - Main Screen";
                    } else {
                        screenTitle = this.anchor.getName();
                        this.btnSetAnchor.f_93623_ = true;
                    }
                    this.updateButtons();
                });
            }
            ((Button)this.m_142416_((GuiEventListener)this.btnAnchor)).m_93650_(0.0f);
            buttonW += 20;
        }
    }

    private void addSoundListButtons() {
        int by = this.minYButton;
        int bx = CommonConfig.get().leftButtons().get() != false ? this.getX() + 36 : this.getX() + 11;
        this.firstSoundButton = null;
        soundsList.clear();
        switch (this.btnCSL.m_6035_().getString()) {
            case "Recent": {
                soundsList.addAll(recentSoundsList);
                break;
            }
            case "All": {
                soundsList.addAll(Registry.f_122821_.m_6566_());
                break;
            }
            default: {
                soundsList.addAll(this.anchor == null ? muffledSounds.keySet() : this.anchor.getMuffledSounds().keySet());
            }
        }
        if (CommonConfig.get().lawfulAllList().get().booleanValue() && this.btnCSL.m_6035_().getString().equals("All")) {
            forbiddenSounds.forEach(fs -> soundsList.removeIf(sl -> sl.toString().contains((CharSequence)fs)));
        } else if (this.btnCSL.m_6035_().getString().equals("Recent")) {
            forbiddenSounds.forEach(fs -> soundsList.removeIf(sl -> sl.toString().contains((CharSequence)fs)));
        }
        if (soundsList.isEmpty()) {
            return;
        }
        for (ResourceLocation sound : soundsList) {
            if (!sound.toString().contains(this.searchBar.m_94155_())) continue;
            double volume = this.anchor != null ? (this.anchor.getMuffledSounds().get(sound) == null ? 1.0 : (Double)this.anchor.getMuffledSounds().get(sound)) : (muffledSounds.get(sound) == null ? 1.0 : (Double)muffledSounds.get(sound));
            int bg = this.m_6702_().size() % 2 == 0 ? darkBG : brightBG;
            MuffledSlider btnSound = new MuffledSlider(bx, by, bg, sound, volume, this);
            if (this.anchor != null) {
                this.setFGColor(btnSound, this.anchor.getMuffledSounds().containsKey(sound) ? "aqua" : "white");
            } else if (!muffledSounds.isEmpty()) {
                this.setFGColor(btnSound, muffledSounds.containsKey(sound) ? "aqua" : "white");
            } else {
                this.setFGColor(btnSound, "white");
            }
            this.m_142416_((GuiEventListener)btnSound);
            by += btnSound.m_93694_();
            btnSound.isVisible(btnSound.f_93621_ < this.maxYButton);
            if (this.firstSoundButton == null) {
                this.firstSoundButton = btnSound;
            }
            this.lastSoundButton = btnSound;
        }
    }

    private void updateButtons() {
        Iterator iterator = this.m_6702_().iterator();
        while (iterator.hasNext()) {
            Widget button = (Widget)iterator.next();
            if (!(button instanceof MuffledSlider)) continue;
            ((MuffledSlider)button).isVisible(false);
            iterator.remove();
        }
        this.addSoundListButtons();
    }

    private void renderButtons(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        boolean notMuffling;
        Object message;
        SoundMufflerCommon.renderGui();
        if (isMuffling) {
            MufflerScreen.m_93133_((PoseStack)stack, (int)(this.btnTMS.f_93620_ + 1), (int)(this.btnTMS.f_93621_ + 1), (float)54.0f, (float)202.0f, (int)15, (int)15, (int)256, (int)256);
        }
        Object object = message = isMuffling ? "Stop Muffling" : "Start Muffling";
        if (this.btnTMS.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (String)message, (AbstractWidget)this.btnTMS);
        }
        Object object2 = message = this.anchor == null ? "Delete Muffled List" : "Delete Anchor";
        if (MufflerScreen.m_96638_()) {
            SoundMufflerCommon.renderGui();
            MufflerScreen.m_93133_((PoseStack)stack, (int)(this.btnDelete.f_93620_ + 2), (int)(this.btnDelete.f_93621_ + 1), (float)54.0f, (float)217.0f, (int)13, (int)13, (int)256, (int)256);
            message = "Clear recent sounds list";
        }
        if (this.btnDelete.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (String)message, (AbstractWidget)this.btnDelete);
        }
        MutableComponent searchHint = new TranslatableComponent("gui.recipebook.search_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
        if (!this.searchBar.m_93696_() && this.searchBar.m_94155_().isEmpty()) {
            MufflerScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)searchHint, (int)(this.searchBar.f_93620_ + 1), (int)(this.searchBar.f_93621_ + 1), (int)-1);
        }
        boolean bl = notMuffling = this.anchor == null ? muffledSounds.isEmpty() : this.anchor.getMuffledSounds().isEmpty();
        if (notMuffling && this.btnCSL.m_6035_().getString().equals("Muffled")) {
            MutableComponent text = Component.m_130674_((String)"Nothing to show here yet..").m_6881_().m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
            MufflerScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)text, (int)(this.getX() + 128), (int)(this.getY() + 101), (int)0xFFFFFF);
        }
        float centerX = (float)this.btnCSL.f_93620_ + (float)this.btnCSL.m_5711_() / 2.0f - (float)this.f_96547_.m_92895_(this.btnCSL.m_6035_().getString()) / 2.0f;
        this.f_96547_.m_92883_(stack, this.btnCSL.m_6035_().getString(), centerX, (float)(this.btnCSL.f_93621_ + 3), 0);
        message = "Showing " + this.btnCSL.m_6035_().getString() + " sounds";
        if (this.btnCSL.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (String)message, (AbstractWidget)this.btnCSL);
        }
        message = "Next Sounds";
        if (this.btnNextSounds.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (String)message, (AbstractWidget)this.btnNextSounds);
        }
        message = "Previous Sounds";
        if (this.btnPrevSounds.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (String)message, (AbstractWidget)this.btnPrevSounds);
        }
        if (mouseX > this.getX() + 30 && mouseX < this.btnAnchor.f_93620_ + this.btnAnchor.m_5711_() && mouseY > this.btnAnchor.f_93621_ && mouseY < this.btnAnchor.f_93621_ + this.btnAnchor.m_93694_() && CommonConfig.get().disableAnchors().get().booleanValue()) {
            this.m_96602_(stack, Component.m_130674_((String)"Anchors are disabled!"), this.getX() + 60, this.getY() + 40);
        }
        for (GuiEventListener widget : this.m_6702_()) {
            AbstractWidget btn = (AbstractWidget)widget;
            if (btn instanceof MuffledSlider) {
                if (this.anchor == null || this.anchor.getAnchorPos() != null || !((MuffledSlider)widget).getBtnToggleSound().m_5953_((double)mouseX, (double)mouseY)) continue;
                this.renderButtonTooltip(stack, "Set the anchor first", (AbstractWidget)((MuffledSlider)widget).getBtnToggleSound());
                continue;
            }
            if (!btn.m_6035_().getString().matches("[0-9]") || anchorList.isEmpty()) continue;
            String color = ((Anchor)anchorList.get(Integer.parseInt(btn.m_6035_().getString()))).getAnchorPos() != null ? "green" : "white";
            this.setFGColor(btn, color);
            if (this.anchor == null || !btn.m_6035_().getString().equals(String.valueOf(this.anchor.getAnchorId()))) continue;
            SoundMufflerCommon.renderGui();
            MufflerScreen.m_93133_((PoseStack)stack, (int)(btn.f_93620_ - 5), (int)(btn.f_93621_ - 2), (float)71.0f, (float)202.0f, (int)27, (int)22, (int)256, (int)256);
        }
        if (this.editRadBar.m_198029_()) {
            this.renderButtonTooltip(stack, "Range: 1 - 32", (AbstractWidget)this.editRadBar);
        }
        if (this.editAnchorTitleBar.m_198029_()) {
            this.renderButtonTooltip(stack, "Change Anchor title", (AbstractWidget)this.editAnchorTitleBar);
        }
        if (this.btnSetAnchor.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, "Set Anchor", (AbstractWidget)this.btnSetAnchor);
        }
        if (this.btnEditAnchor.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, "Edit Anchor", (AbstractWidget)this.btnEditAnchor);
        }
    }

    private void renderSideScreen(PoseStack stack, int mouseX, int mouseY) {
        String Radius;
        if (this.anchor == null) {
            return;
        }
        String dimensionName = "";
        int x = this.btnSetAnchor.f_93620_;
        int y = this.btnSetAnchor.f_93621_;
        int stringW = this.f_96547_.m_92895_("Dimension: ");
        String string = Radius = this.anchor.getRadius() == 0 ? "" : String.valueOf(this.anchor.getRadius());
        if (this.anchor.getDimension() != null) {
            stringW += this.f_96547_.m_92895_(this.anchor.getDimension().m_135815_());
            dimensionName = this.anchor.getDimension().m_135815_();
        }
        MufflerScreen.m_93172_((PoseStack)stack, (int)(x - 5), (int)(y - 57), (int)(x + stringW + 7), (int)(y + 17), (int)whiteBG);
        MufflerScreen.m_93172_((PoseStack)stack, (int)(x - 5), (int)(y - 56), (int)(x + stringW + 6), (int)(y + 16), (int)darkBG);
        MufflerScreen.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)("X: " + this.anchor.getX()), (int)(x + 1), (int)(y - 50), (int)0xFFFFFF);
        MufflerScreen.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)("Y: " + this.anchor.getY()), (int)(x + 1), (int)(y - 40), (int)0xFFFFFF);
        MufflerScreen.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)("Z: " + this.anchor.getZ()), (int)(x + 1), (int)(y - 30), (int)0xFFFFFF);
        MufflerScreen.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)("Radius: " + Radius), (int)(x + 1), (int)(y - 20), (int)0xFFFFFF);
        MufflerScreen.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)("Dimension: " + dimensionName), (int)(x + 1), (int)(y - 10), (int)0xFFFFFF);
        SoundMufflerCommon.renderGui();
        MufflerScreen.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)69.45f, (int)11, (int)11, (int)88, (int)88);
        if (this.anchor.getAnchorPos() != null) {
            this.btnEditAnchor.f_93623_ = true;
            MufflerScreen.m_93133_((PoseStack)stack, (int)this.btnEditAnchor.f_93620_, (int)this.btnEditAnchor.f_93621_, (float)32.0f, (float)213.0f, (int)11, (int)11, (int)256, (int)256);
        } else {
            this.btnEditAnchor.f_93623_ = false;
        }
        x = this.btnSetAnchor.f_93620_;
        y = this.editAnchorTitleBar.f_93621_;
        if (this.editRadBar.f_93624_) {
            MufflerScreen.m_93172_((PoseStack)stack, (int)(x + stringW + 7), (int)(y - 5), (int)(this.editAnchorTitleBar.f_93620_ + this.editAnchorTitleBar.m_5711_() + 4), (int)(this.btnAccept.f_93621_ + 23), (int)whiteBG);
            MufflerScreen.m_93172_((PoseStack)stack, (int)(x - 5), (int)(this.btnAccept.f_93621_ + 23), (int)(this.editAnchorTitleBar.f_93620_ + this.editAnchorTitleBar.m_5711_() + 4), (int)(this.btnAccept.f_93621_ + 24), (int)whiteBG);
            MufflerScreen.m_93172_((PoseStack)stack, (int)(x - 6), (int)(y - 4), (int)(this.editAnchorTitleBar.f_93620_ + this.editAnchorTitleBar.m_5711_() + 3), (int)(this.btnAccept.f_93621_ + 23), (int)darkBG);
            this.f_96547_.m_92883_(stack, "Title: ", (float)(x - 2), (float)(y + 1), 0xFFFFFF);
            this.f_96547_.m_92883_(stack, "Radius: ", (float)(x - 2), (float)(this.editRadBar.f_93621_ + 1), 0xFFFFFF);
        }
    }

    private void renderButtonTooltip(PoseStack stack, String message, AbstractWidget button) {
        int centeredMessageX = button.f_93620_ - this.f_96547_.m_92895_(message) / 2;
        int centeredMessageY = button.equals(this.btnPrevSounds) || button.equals(this.btnNextSounds) ? button.f_93621_ - 1 : button.f_93621_ + button.m_93694_() + 16;
        this.m_96602_(stack, Component.m_130674_((String)message), centeredMessageX, centeredMessageY);
    }

    private void renderTips(PoseStack stack) {
        if (CommonConfig.get().showTip().get().booleanValue()) {
            if (this.index % 500 == 0) {
                this.tip = Tips.randomTip();
                this.index = 0;
            }
            Objects.requireNonNull(this.f_96547_);
            int h = 9 * (this.f_96547_.m_92895_(this.tip) / 245 + 1) + 215;
            MufflerScreen.m_93172_((PoseStack)stack, (int)(this.getX() - 2), (int)(this.getY() + 208), (int)(this.getX() + 257), (int)(this.getY() + h + 2), (int)darkBG);
            MufflerScreen.m_93172_((PoseStack)stack, (int)(this.getX() - 1), (int)(this.getY() + 209), (int)(this.getX() + 256), (int)(this.getY() + h + 1), (int)goldBG);
            MufflerScreen.m_93172_((PoseStack)stack, (int)this.getX(), (int)(this.getY() + 210), (int)(this.getX() + 255), (int)(this.getY() + h), (int)darkBG);
            this.f_96547_.m_92857_(FormattedText.m_130775_((String)this.tip), this.getX() + 5, this.getY() + 213, 245, 0xFFFFFF);
            ++this.index;
        }
    }

    private void hideSideButtons() {
        this.btnSetAnchor.f_93623_ = false;
        this.btnEditAnchor.f_93623_ = false;
        this.editAnchorTitleBar.f_93624_ = false;
        this.editRadBar.f_93624_ = false;
        this.btnAccept.f_93624_ = false;
        this.btnCancel.f_93624_ = false;
    }

    private void editTitle() {
        this.editAnchorTitleBar.m_94144_(this.anchor.getName());
        this.editAnchorTitleBar.f_93624_ = !this.editAnchorTitleBar.f_93624_;
        this.editRadBar.m_94144_(String.valueOf(this.anchor.getRadius()));
        this.editRadBar.f_93624_ = !this.editRadBar.f_93624_;
        this.btnAccept.f_93624_ = !this.btnAccept.f_93624_;
        this.btnCancel.f_93624_ = !this.btnCancel.f_93624_;
        this.editRadBar.m_94202_(0xFFFFFF);
    }

    public boolean removeSoundMuffled(ResourceLocation sound) {
        if (this.anchor != null) {
            if (this.anchor.getAnchorPos() != null) {
                this.anchor.removeSound(sound);
                return true;
            }
        } else {
            muffledSounds.remove(sound);
            return true;
        }
        return false;
    }

    public boolean addSoundMuffled(ResourceLocation sound, double volume) {
        if (this.anchor != null) {
            if (this.anchor.getAnchorPos() != null) {
                this.anchor.addSound(sound, volume);
                return true;
            }
        } else {
            muffledSounds.put(sound, volume);
            return true;
        }
        return false;
    }

    public void replaceVolume(ResourceLocation sound, double volume) {
        if (this.anchor != null) {
            this.anchor.replaceSound(sound, volume);
        } else {
            muffledSounds.replace(sound, volume);
        }
    }

    public static boolean isMuffling() {
        return isMuffling;
    }

    private int getX() {
        return (this.f_96543_ - 256) / 2;
    }

    private int getY() {
        return (this.f_96544_ - 202) / 2;
    }
}

