/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class DataManager
implements ISoundLists {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadData() {
        DataManager.loadMuffledMap().forEach((R, D) -> muffledSounds.put(new ResourceLocation(R), D));
        if (!CommonConfig.get().disableAnchors().get().booleanValue()) {
            anchorList.clear();
            anchorList.addAll(DataManager.loadAnchors());
        }
    }

    public static void saveData() {
        DataManager.saveMuffledMap();
        if (!CommonConfig.get().disableAnchors().get().booleanValue()) {
            DataManager.saveAnchors();
        }
    }

    private static String getWorldName() {
        if (Minecraft.m_91087_().m_91089_() != null) {
            return Minecraft.m_91087_().m_91089_().f_105362_;
        }
        if (Minecraft.m_91087_().m_91092_() != null) {
            return Minecraft.m_91087_().m_91092_().m_129910_().m_5462_();
        }
        return "ServerWorld";
    }

    private static CompoundTag serializeAnchor(Anchor anchor) {
        CompoundTag anchorNBT = new CompoundTag();
        CompoundTag muffledNBT = new CompoundTag();
        anchorNBT.m_128405_("ID", anchor.getAnchorId());
        anchorNBT.m_128359_("NAME", anchor.getName());
        if (anchor.getAnchorPos() == null) {
            return anchorNBT;
        }
        anchorNBT.m_128365_("POS", (Tag)NbtUtils.m_129224_((BlockPos)anchor.getAnchorPos()));
        anchorNBT.m_128359_("DIM", anchor.getDimension().toString());
        anchorNBT.m_128405_("RAD", anchor.getRadius());
        anchor.getMuffledSounds().forEach((R, D) -> muffledNBT.m_128347_(R.toString(), D.doubleValue()));
        anchorNBT.m_128365_("MUFFLED", (Tag)muffledNBT);
        return anchorNBT;
    }

    public static Anchor deserializeAnchor(CompoundTag nbt) {
        TreeMap<String, Double> muffledSounds = new TreeMap<String, Double>();
        CompoundTag muffledNBT = nbt.m_128469_("MUFFLED");
        for (String key : muffledNBT.m_128431_()) {
            muffledSounds.put(key, muffledNBT.m_128459_(key));
        }
        if (!nbt.m_128441_("POS")) {
            return new Anchor(nbt.m_128451_("ID"), nbt.m_128461_("NAME"));
        }
        return new Anchor(nbt.m_128451_("ID"), nbt.m_128461_("NAME"), NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("POS")), new ResourceLocation(nbt.m_128461_("DIM")), nbt.m_128451_("RAD"), muffledSounds);
    }

    private static void saveMuffledMap() {
        new File("ESM/").mkdir();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)muffledSounds));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Map<String, Double> loadMuffledMap() {
        Map map;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);
        try {
            map = (Map)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<Map<String, Double>>(){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException e) {
                return new HashMap<String, Double>();
            }
        }
        reader.close();
        return map;
    }

    private static void saveAnchors() {
        new File("ESM/", DataManager.getWorldName()).mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/" + DataManager.getWorldName() + "/anchors.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)anchorList));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static List<Anchor> loadAnchors() {
        List list;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/" + DataManager.getWorldName() + "/anchors.dat"), StandardCharsets.UTF_8);
        try {
            list = (List)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<List<Anchor>>(){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException ignored) {
                return IntStream.range(0, 10).mapToObj(i -> new Anchor(i, "Anchor " + i)).collect(Collectors.toList());
            }
        }
        reader.close();
        return list;
    }
}

