/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.handler.lootmodifier;

import com.google.gson.JsonObject;
import de.melanx.aiotbotania.core.Registration;
import de.melanx.aiotbotania.items.alfsteel.ItemAlfsteelAIOT;
import de.melanx.aiotbotania.items.terrasteel.ItemTerraSteelAIOT;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import vazkii.botania.common.lib.ModTags;

public class DisposeModifier
extends LootModifier {
    public DisposeModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    public static void filterDisposable(List<ItemStack> drops, Entity entity, ItemStack stack) {
        if (!stack.m_41619_() && (stack.m_41720_() == Registration.elementium_aiot.get() || stack.m_41720_() == Registration.terrasteel_aiot.get() && ItemTerraSteelAIOT.isTipped(stack) || stack.m_41720_() == Registration.alfsteel_aiot.get() && ItemAlfsteelAIOT.isTipped(stack))) {
            drops.removeIf(s -> !s.m_41619_() && (DisposeModifier.isDisposable(s) || DisposeModifier.isSemiDisposable(s) && !entity.m_6047_()));
        }
    }

    private static boolean isDisposable(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return ModTags.Items.DISPOSABLE.m_8110_((Object)stack.m_41720_());
    }

    private static boolean isSemiDisposable(ItemStack stack) {
        return ModTags.Items.SEMI_DISPOSABLE.m_8110_((Object)stack.m_41720_());
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (entity != null && tool != null && !tool.m_41619_()) {
            DisposeModifier.filterDisposable(generatedLoot, entity, tool);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DisposeModifier> {
        public DisposeModifier read(ResourceLocation location, JsonObject json, LootItemCondition[] conditions) {
            return new DisposeModifier(conditions);
        }

        public JsonObject write(DisposeModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

