/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.terrasteel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import de.melanx.aiotbotania.core.network.AIOTBotaniaNetwork;
import de.melanx.aiotbotania.core.network.TerrasteelCreateBurstMesssage;
import de.melanx.aiotbotania.items.ItemTiers;
import de.melanx.aiotbotania.items.alfsteel.ItemAlfsteelAIOT;
import de.melanx.aiotbotania.items.base.ItemAIOTBase;
import de.melanx.aiotbotania.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraSword;
import vazkii.botania.common.item.relic.ItemThorRing;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ItemTerraSteelAIOT
extends ItemAIOTBase
implements ISequentialBreaker,
IManaItem {
    public static final int MANA_PER_DAMAGE = 100;
    public static final float DAMAGE = 6.0f;
    public static final float SPEED = -2.2f;
    protected static final Set<Material> MATERIALS = ImmutableSet.of((Object)Material.f_76278_, (Object)Material.f_76279_, (Object)Material.f_76276_, (Object)Material.f_76275_, (Object)Material.f_76283_, (Object)Material.f_76281_, (Object[])new Material[]{Material.f_76315_, Material.f_76314_, Material.f_76317_, Material.f_76308_, Material.f_76280_, Material.f_76313_});
    private static final Set<Material> AXE_MATERIALS = ImmutableSet.of((Object)Material.f_76320_, (Object)Material.f_76274_, (Object)Material.f_76271_);
    public static final int[] LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] CREATIVE_MANA = new int[]{9999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final Map<ResourceKey<Level>, Set<BlockSwapper>> blockSwappers = new HashMap<ResourceKey<Level>, Set<BlockSwapper>>();
    private static boolean tickingSwappers = false;

    public ItemTerraSteelAIOT() {
        this(ItemTiers.TERRASTEEL_AIOT_ITEM_TIER);
    }

    public ItemTerraSteelAIOT(Tier tier) {
        super(tier, 6.0f, -2.2f, 100, true);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDrops);
        MinecraftForge.EVENT_BUS.addListener(this::leftClick);
        MinecraftForge.EVENT_BUS.addListener(this::attackEntity);
        MinecraftForge.EVENT_BUS.addListener(this::onTickEnd);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_.m_7454_(ModItems.terraSword);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap result = super.m_7167_(slot);
        if (slot == EquipmentSlot.MAINHAND) {
            result = HashMultimap.create((Multimap)result);
            if (ItemTerraSteelAIOT.isTipped(stack)) {
                result.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier((EquipmentSlot)slot, (String)"AIOT modifier", (double)0.1));
            }
        }
        return result;
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack stack) {
        int level = ItemTerraSteelAIOT.getLevel(stack);
        int max = LEVELS[Math.min(LEVELS.length - 1, level + 1)];
        int curr = ItemTerraSteelAIOT.getMana_(stack);
        float percent = level == 0 ? 0.0f : (float)curr / (float)max;
        return Optional.of(new ManaBarTooltip(percent, level));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        BlockHitResult hitResult = ToolCommons.raytraceFromEntity((Entity)player, (double)10.0, (boolean)false);
        if (!player.f_19853_.f_46443_ && hitResult.m_6662_() == HitResult.Type.BLOCK) {
            Direction face = hitResult.m_82434_();
            if (AXE_MATERIALS.contains(player.m_20193_().m_8055_(hitResult.m_82425_()).m_60767_())) {
                this.breakOtherBlockAxe(player, stack, pos, pos, face);
            } else {
                this.breakOtherBlock(player, stack, pos, pos, face);
            }
            BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
        }
        return false;
    }

    private void onEntityDrops(LivingDropsEvent event) {
        ItemStack weapon;
        if (event.isRecentlyHit() && event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof Player && !(weapon = ((Player)event.getSource().m_7639_()).m_21205_()).m_41619_() && weapon.m_41720_() == this) {
            Random rand = event.getEntityLiving().f_19853_.f_46441_;
            int looting = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)weapon);
            if (event.getEntityLiving() instanceof AbstractSkeleton && rand.nextInt(26) <= 3 + looting) {
                this.addDrop(event, new ItemStack((ItemLike)(event.getEntity() instanceof WitherSkeleton ? Items.f_42679_ : Items.f_42678_)));
            } else if (event.getEntityLiving() instanceof Zombie && !(event.getEntityLiving() instanceof ZombifiedPiglin) && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(event, new ItemStack((ItemLike)Items.f_42681_));
            } else if (event.getEntityLiving() instanceof Creeper && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(event, new ItemStack((ItemLike)Items.f_42682_));
            } else if (event.getEntityLiving() instanceof Player && rand.nextInt(11) <= 1 + looting) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
                ItemNBTHelper.setString((ItemStack)stack, (String)"SkullOwner", (String)((Player)event.getEntityLiving()).m_36316_().getName());
                this.addDrop(event, stack);
            } else if (event.getEntityLiving() instanceof EntityDoppleganger && rand.nextInt(13) < 1 + looting) {
                this.addDrop(event, new ItemStack((ItemLike)ModBlocks.gaiaHead));
            }
        }
    }

    private void addDrop(LivingDropsEvent event, ItemStack drop) {
        ItemEntity entityitem = new ItemEntity(event.getEntityLiving().f_19853_, event.getEntityLiving().f_19790_, event.getEntityLiving().f_19791_, event.getEntityLiving().f_19792_, drop);
        entityitem.m_32010_(10);
        event.getDrops().add(entityitem);
    }

    public void trySpawnBurst(Player player) {
        if (!player.m_21205_().m_41619_() && player.m_21205_().m_41720_() == this && player.m_36403_(0.0f) == 1.0f) {
            EntityManaBurst burst = this.getBurst(player, player.m_21205_());
            player.f_19853_.m_7967_((Entity)burst);
            player.m_21205_().m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(InteractionHand.MAIN_HAND));
            player.f_19853_.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.terraBlade, SoundSource.PLAYERS, 0.4f, 1.4f);
        }
    }

    public EntityManaBurst getBurst(Player player, ItemStack stack) {
        return ItemTerraSword.getBurst((Player)player, (ItemStack)stack);
    }

    private void leftClick(PlayerInteractEvent.LeftClickEmpty event) {
        if (!event.getItemStack().m_41619_() && event.getItemStack().m_41720_() == this) {
            AIOTBotaniaNetwork.INSTANCE.sendToServer((Object)new TerrasteelCreateBurstMesssage());
        }
    }

    private void attackEntity(AttackEntityEvent event) {
        if (!event.getPlayer().f_19853_.f_46443_) {
            this.trySpawnBurst(event.getPlayer());
        }
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            for (int mana : CREATIVE_MANA) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemTerraSteelAIOT.setMana(stack, mana);
                items.add((Object)stack);
            }
            ItemStack stack = new ItemStack((ItemLike)this);
            ItemTerraSteelAIOT.setMana(stack, CREATIVE_MANA[1]);
            ItemTerraSteelAIOT.setTipped(stack);
            items.add((Object)stack);
        }
    }

    public int getEntityLifespan(ItemStack itemStack, Level level) {
        return Integer.MAX_VALUE;
    }

    public static boolean isTipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"tipped", (boolean)false);
    }

    public static void setTipped(ItemStack stack) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"tipped", (boolean)true);
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"enabled", (boolean)false);
    }

    public static void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"enabled", (boolean)enabled);
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"mana", (int)mana);
    }

    public int getMana(ItemStack stack) {
        return ItemTerraSteelAIOT.getMana_(stack);
    }

    public static int getMana_(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"mana", (int)0);
    }

    public static int getLevel(ItemStack stack) {
        int mana = ItemTerraSteelAIOT.getMana_(stack);
        for (int i = LEVELS.length - 1; i > 0; --i) {
            if (mana < LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    public int getMaxMana(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public void addMana(ItemStack stack, int mana) {
        ItemTerraSteelAIOT.setMana(stack, Math.min(this.getMana(stack) + mana, Integer.MAX_VALUE));
    }

    public boolean canReceiveManaFromPool(ItemStack stack, BlockEntity pool) {
        return true;
    }

    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !ModTags.Items.TERRA_PICK_BLACKLIST.m_8110_((Object)otherStack.m_41720_());
    }

    public boolean canExportManaToPool(ItemStack stack, BlockEntity pool) {
        return false;
    }

    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    public boolean isNoExport(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack before, @Nonnull ItemStack after, boolean slotChanged) {
        return after.m_41720_() != this || ItemTerraSteelAIOT.isEnabled(before) != ItemTerraSteelAIOT.isEnabled(after);
    }

    @Override
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @Nonnull InteractionHand hand) {
        if (player.m_6144_()) {
            return super.m_7203_(level, player, hand);
        }
        ItemStack stack = player.m_21120_(hand);
        this.getMana(stack);
        int manaLevel = ItemTerraSteelAIOT.getLevel(stack);
        if (manaLevel != 0) {
            ItemTerraSteelAIOT.setEnabled(stack, !ItemTerraSteelAIOT.isEnabled(stack));
            if (!level.f_46443_) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.terraPickMode, SoundSource.PLAYERS, 0.5f, 0.4f);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void breakOtherBlock(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        Level level;
        Material mat;
        if (ItemTerraSteelAIOT.isEnabled(stack) && MATERIALS.contains(mat = (level = player.f_19853_).m_8055_(pos).m_60767_()) && !level.m_46859_(pos)) {
            boolean thor = !ItemThorRing.getThorRing((Player)player).m_41619_();
            boolean doX = thor || side.m_122429_() == 0;
            boolean doY = thor || side.m_122430_() == 0;
            boolean doZ = thor || side.m_122431_() == 0;
            int origLevel = ItemTerraSteelAIOT.getLevel(stack);
            int tier = origLevel + (thor ? 1 : 0);
            int rangeDepth = tier / 2;
            if (ItemTemperanceStone.hasTemperanceActive((Player)player) && tier > 2) {
                tier = 2;
                rangeDepth = 0;
            }
            if (!(stack.m_41720_() instanceof ItemAlfsteelAIOT)) {
                rangeDepth = 0;
            }
            int range = tier - 1;
            int rangeY = Math.max(1, range);
            if (range != 0 || tier == 1) {
                Vec3i beginDiff = new Vec3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
                Vec3i endDiff = new Vec3i(doX ? range : rangeDepth * -side.m_122429_(), doY ? rangeY * 2 - 1 : 0, doZ ? range : rangeDepth * -side.m_122431_());
                ToolCommons.removeBlocksInIteration((Player)player, (ItemStack)stack, (Level)level, (BlockPos)pos, (Vec3i)beginDiff, (Vec3i)endDiff, state -> stack.m_41691_(state) > 1.0f || MATERIALS.contains(state.m_60767_()));
                if (origLevel == 5) {
                    PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix((String)"challenge/rank_ss_pick"), (String)"code_triggered");
                }
            }
        }
    }

    public void breakOtherBlockAxe(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (!player.m_6144_() && !tickingSwappers && ItemTerraSteelAIOT.isEnabled(stack) && !ItemTemperanceStone.hasTemperanceActive((Player)player)) {
            ItemTerraSteelAIOT.addBlockSwapper(player.f_19853_, player, stack, pos, 32, true);
        }
    }

    private void onTickEnd(TickEvent.WorldTickEvent event) {
        ResourceKey dim;
        if (!event.world.f_46443_ && event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.m_46472_())) {
            tickingSwappers = true;
            Set<BlockSwapper> swappers = blockSwappers.get(dim);
            swappers.removeIf(next -> next == null || !next.tick());
            tickingSwappers = false;
        }
    }

    private static void addBlockSwapper(Level level, Player player, ItemStack stack, BlockPos origCoords, int steps, boolean leaves) {
        BlockSwapper swapper = new BlockSwapper(level, player, stack, origCoords, steps, leaves);
        if (!level.f_46443_) {
            ResourceKey dim = level.m_46472_();
            blockSwappers.computeIfAbsent((ResourceKey<Level>)dim, d -> new HashSet()).add(swapper);
        }
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, Level level, List<Component> list, @Nonnull TooltipFlag flags) {
        super.m_7373_(stack, level, list, flags);
        TranslatableComponent rank = new TranslatableComponent("botania.rank" + ItemTerraSteelAIOT.getLevel(stack));
        TranslatableComponent rankFormat = new TranslatableComponent("botaniamisc.toolRank", new Object[]{rank});
        list.add((Component)rankFormat);
        if (this.getMana(stack) == Integer.MAX_VALUE) {
            list.add((Component)new TranslatableComponent("botaniamisc.getALife").m_130940_(ChatFormatting.RED));
        }
    }

    @Override
    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        boolean hoemode = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
        if (hoemode) {
            boolean thor = !ItemThorRing.getThorRing((Player)player).m_41619_();
            int origLevel = ItemTerraSteelAIOT.getLevel(stack);
            int tier = origLevel + (thor ? 1 : 0);
            if (ItemTemperanceStone.hasTemperanceActive((Player)player) && tier > 2) {
                tier = 2;
            }
            int range = tier - 1;
            if (!player.m_6047_()) {
                if (ItemTerraSteelAIOT.isEnabled(stack)) {
                    return ToolUtil.hoeUseAOE(context, this.special, false, range);
                }
                return ToolUtil.hoeUse(context, this.special, false);
            }
            InteractionResult result = InteractionResult.PASS;
            if (context.m_43719_() != Direction.DOWN && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
                result = ToolUtil.shovelUse(context);
            }
            return result == InteractionResult.PASS ? ToolUtil.stripLog(context) : result;
        }
        if (!player.m_6047_()) {
            return ToolUtil.pickUse(context);
        }
        if (context.m_43719_() == Direction.UP) {
            return ToolUtil.axeUse(context);
        }
        return InteractionResult.PASS;
    }

    private static class BlockSwapper {
        private final Level level;
        private final Player player;
        private final ItemStack truncator;
        private final boolean treatLeavesSpecial;
        private final PriorityQueue<SwapCandidate> candidateQueue;
        private final Set<BlockPos> completedCoords;

        public BlockSwapper(Level level, Player player, ItemStack truncator, BlockPos origCoords, int range, boolean leaves) {
            this.level = level;
            this.player = player;
            this.truncator = truncator;
            this.treatLeavesSpecial = leaves;
            this.candidateQueue = new PriorityQueue();
            this.completedCoords = new HashSet<BlockPos>();
            this.candidateQueue.offer(new SwapCandidate(origCoords, range));
        }

        public boolean tick() {
            if (this.candidateQueue.isEmpty()) {
                return false;
            }
            int remainingSwaps = 10;
            while (remainingSwaps > 0 && !this.candidateQueue.isEmpty()) {
                SwapCandidate candidate = this.candidateQueue.poll();
                if (this.completedCoords.contains(candidate.coordinates) || candidate.range <= 0) continue;
                ToolCommons.removeBlockWithDrops((Player)this.player, (ItemStack)this.truncator, (Level)this.level, (BlockPos)candidate.coordinates, state -> state.m_60620_((Tag)BlockTags.f_144280_) || state.m_60620_((Tag)BlockTags.f_13035_));
                --remainingSwaps;
                this.completedCoords.add(candidate.coordinates);
                for (BlockPos adj : this.adjacent(candidate.coordinates)) {
                    Block block = this.level.m_8055_(adj).m_60734_();
                    boolean isWood = BlockTags.f_13106_.m_8110_((Object)block);
                    boolean isLeaf = BlockTags.f_13035_.m_8110_((Object)block);
                    if (!isWood && !isLeaf) continue;
                    int newRange = this.treatLeavesSpecial && isLeaf ? Math.min(3, candidate.range - 1) : candidate.range - 1;
                    this.candidateQueue.offer(new SwapCandidate(adj, newRange));
                }
            }
            return true;
        }

        public List<BlockPos> adjacent(BlockPos original) {
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        coords.add(original.m_142082_(dx, dy, dz));
                    }
                }
            }
            return coords;
        }

        public record SwapCandidate(BlockPos coordinates, int range) implements Comparable<SwapCandidate>
        {
            @Override
            public int compareTo(@Nonnull SwapCandidate other) {
                return other.range - this.range;
            }
        }
    }
}

