/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.util;

import de.melanx.aiotbotania.core.Registration;
import de.melanx.aiotbotania.items.livingrock.ItemLivingrockAIOT;
import de.melanx.aiotbotania.util.ToolBreakContext;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ToolUtil {
    private static final Pattern TORCH_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)torch)|(?:(?:[a-z-_.:]|^)Torch))(?:[A-Z-_.:]|$)");
    private static final Pattern SAPLING_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)sapling)|(?:(?:[a-z-_.:]|^)Sapling))(?:[A-Z-_.:]|$)");
    public static final ToolAction HOE_TILL = ToolAction.get((String)"till");
    public static final Set<ToolAction> DEFAULT_HOE_ACTIONS = Set.of(ToolActions.HOE_DIG, HOE_TILL);
    public static final Set<ToolAction> DEFAULT_AIOT_ACTIONS = Set.of(ToolActions.AXE_DIG, ToolActions.AXE_STRIP, ToolActions.AXE_SCRAPE, ToolActions.AXE_WAX_OFF, ToolActions.HOE_DIG, HOE_TILL, ToolActions.SHOVEL_DIG, ToolActions.SHOVEL_FLATTEN, ToolActions.PICKAXE_DIG, ToolActions.SWORD_DIG);

    public static void inventoryTick(ItemStack stack, Level level, Entity player, int manaPerDamage) {
        if (!level.f_46443_ && player instanceof Player && stack.m_41773_() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, (Player)player, manaPerDamage * 2, true)) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    public static void toggleMode(Player player, ItemStack stack) {
        Style dark_blue = Style.f_131099_.m_131140_(ChatFormatting.DARK_BLUE).m_131155_(Boolean.valueOf(true));
        Style aqua = Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131155_(Boolean.valueOf(true));
        MutableComponent text = new TranslatableComponent("aiotbotania.toggleMode").m_130946_(" ").m_130948_(dark_blue);
        MutableComponent utilityMode = new TranslatableComponent("aiotbotania.utilityMode").m_130948_(aqua);
        MutableComponent hoeMode = new TranslatableComponent("aiotbotania.hoeMode").m_130948_(aqua);
        MutableComponent hoeModePath = new TranslatableComponent("aiotbotania.hoeModePath").m_130948_(aqua);
        if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true)) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"hoemode", (boolean)false);
            text.m_7220_((Component)utilityMode);
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
            if (stack.m_41720_() instanceof ItemLivingrockAIOT) {
                text = text.m_7220_((Component)hoeMode);
            } else {
                text.m_7220_((Component)hoeModePath);
            }
        }
        player.m_5661_((Component)text, true);
    }

    public static InteractionResult hoemodeUse(@Nonnull UseOnContext context, Player player, Level level, BlockPos pos, Direction side) {
        if (!player.m_6047_()) {
            return ToolUtil.hoeUse(context, false, true);
        }
        if (side != Direction.DOWN && level.m_46859_(pos.m_7494_())) {
            return ToolUtil.shovelUse(context);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult hoeUse(UseOnContext context, boolean special, boolean lowTier) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        if (player != null && player.m_36204_(pos, side, context.m_43722_()) && context.m_43719_() != Direction.DOWN && level.m_46859_(pos.m_7494_())) {
            BlockState state = level.m_8055_(pos);
            BlockState blockstate = ToolUtil.getHoeTillingState(state, context);
            if (blockstate != null) {
                if (blockstate.m_60734_() == Blocks.f_50093_ && special) {
                    blockstate = ((Block)Registration.custom_farmland.get()).m_49966_();
                } else if (blockstate.m_60734_() == Blocks.f_152549_) {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)side, (ItemStack)new ItemStack((ItemLike)Items.f_151017_));
                }
                level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.f_46443_) {
                    level.m_7731_(pos, blockstate, 11);
                    context.m_43722_().m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(context.m_43724_()));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (state.m_60734_() instanceof FarmBlock) {
                Block block = null;
                if (special) {
                    block = Blocks.f_50440_;
                } else if (!lowTier) {
                    block = Blocks.f_50493_;
                }
                if (block != null) {
                    level.m_46597_(pos, block.m_49966_());
                    Block.m_49897_((BlockState)state, (BlockState)block.m_49966_(), (Level)level, (BlockPos)pos);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult hoeUseAOE(UseOnContext context, boolean special, boolean lowTier, int radius) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos basePos = context.m_8083_().m_7949_();
        Direction side = context.m_43719_();
        if (player == null || !player.m_36204_(basePos, side, context.m_43722_())) {
            return InteractionResult.PASS;
        }
        BlockState baseStateResult = ToolUtil.getHoeTillingState(level.m_8055_(basePos), context);
        InteractionResult toReturn = ToolUtil.hoeUse(context, special, lowTier);
        if (toReturn.m_19077_()) {
            boolean soundPlayed = false;
            for (int xd = -radius; xd <= radius; ++xd) {
                for (int zd = -radius; zd <= radius; ++zd) {
                    BlockState blockstate;
                    if (xd == 0 && zd == 0) continue;
                    BlockPos pos = basePos.m_142082_(xd, 0, zd);
                    if (side == Direction.DOWN || !level.m_46859_(pos.m_7494_()) || baseStateResult != (blockstate = ToolUtil.getHoeTillingState(level.m_8055_(pos), context))) continue;
                    if (blockstate != null) {
                        if (blockstate.m_60734_() == Blocks.f_50093_ && special) {
                            blockstate = ((Block)Registration.custom_farmland.get()).m_49966_();
                        }
                        if (!soundPlayed) {
                            level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            soundPlayed = true;
                        }
                        if (level.f_46443_) continue;
                        level.m_7731_(pos, blockstate, 11);
                        context.m_43722_().m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(context.m_43724_()));
                        continue;
                    }
                    if (!(level.m_8055_(pos).m_60734_() instanceof FarmBlock)) continue;
                    Block block = null;
                    if (special) {
                        block = Blocks.f_50440_;
                    } else if (!lowTier) {
                        block = Blocks.f_50493_;
                    }
                    if (block == null) continue;
                    level.m_46597_(pos, block.m_49966_());
                }
            }
        }
        return toReturn;
    }

    @Nonnull
    public static InteractionResult pickUse(UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stackAt = player.m_150109_().m_8020_(i);
                if (stackAt.m_41619_() || !TORCH_PATTERN.matcher(stackAt.m_41720_().m_5524_()).find()) continue;
                InteractionResult did = PlayerHelper.substituteUse((UseOnContext)context, (ItemStack)stackAt);
                if (did == InteractionResult.SUCCESS && !context.m_43725_().m_5776_()) {
                    ItemsRemainingRenderHandler.send((Player)player, (ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (Pattern)TORCH_PATTERN);
                }
                return did;
            }
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public static InteractionResult axeUse(UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stackAt = player.m_150109_().m_8020_(i);
                if (stackAt.m_41619_() || !SAPLING_PATTERN.matcher(stackAt.m_41720_().m_5524_()).find()) continue;
                InteractionResult did = PlayerHelper.substituteUse((UseOnContext)context, (ItemStack)stackAt);
                if (did == InteractionResult.SUCCESS && !context.m_43725_().m_5776_()) {
                    ItemsRemainingRenderHandler.send((Player)player, (ItemStack)new ItemStack((ItemLike)Blocks.f_50746_), (Pattern)SAPLING_PATTERN);
                }
                return did;
            }
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult shovelUse(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        if (context.m_43719_() != Direction.DOWN) {
            Player player = context.m_43723_();
            BlockState modifiedState = state.getToolModifiedState(level, pos, player, context.m_43722_(), ToolActions.SHOVEL_FLATTEN);
            if (modifiedState != null && level.m_46859_(pos.m_7494_())) {
                level.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (state.m_60734_() instanceof CampfireBlock && ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                if (!level.m_5776_()) {
                    level.m_5898_(null, 1009, pos, 0);
                }
                CampfireBlock.m_152749_((Entity)player, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
                modifiedState = (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
            }
            if (modifiedState != null) {
                if (!level.f_46443_) {
                    level.m_7731_(pos, modifiedState, 11);
                    if (player != null) {
                        context.m_43722_().m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(context.m_43724_()));
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult stripLog(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Optional<BlockState> strip = Optional.ofNullable(state.getToolModifiedState(level, pos, player, context.m_43722_(), ToolActions.AXE_STRIP));
        Optional<BlockState> scrape = Optional.ofNullable(state.getToolModifiedState(level, pos, player, context.m_43722_(), ToolActions.AXE_SCRAPE));
        Optional<BlockState> waxOff = Optional.ofNullable(state.getToolModifiedState(level, pos, player, context.m_43722_(), ToolActions.AXE_WAX_OFF));
        Optional<Object> resultState = Optional.empty();
        if (strip.isPresent()) {
            level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            resultState = strip;
        } else if (scrape.isPresent()) {
            level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, pos, 0);
            resultState = scrape;
        } else if (waxOff.isPresent()) {
            level.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, pos, 0);
            resultState = waxOff;
        }
        if (resultState.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
        }
        level.m_7731_(pos, (BlockState)resultState.get(), 11);
        if (player != null) {
            stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(context.m_43724_()));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static BlockState getHoeTillingState(BlockState state, UseOnContext context) {
        Block block = state.m_60734_();
        if (block == Blocks.f_152549_) {
            return Blocks.f_50493_.m_49966_();
        }
        if (context.m_43719_() != Direction.DOWN && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
            if (block == Blocks.f_50440_ || block == Blocks.f_152481_ || block == Blocks.f_50493_) {
                return Blocks.f_50093_.m_49966_();
            }
            if (block == Blocks.f_50546_) {
                return Blocks.f_50493_.m_49966_();
            }
        }
        return null;
    }

    public static void removeBlocksInRange(ToolBreakContext context, Direction side, int range, Predicate<BlockState> predicate) {
        boolean doX = side.m_122429_() == 0;
        boolean doY = side.m_122430_() == 0;
        boolean doZ = side.m_122431_() == 0;
        Vec3i beginDiff = new Vec3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        Vec3i endDiff = new Vec3i(doX ? range : 0, doY ? range * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration((Player)context.getPlayer(), (ItemStack)context.getItem(), (Level)context.getLevel(), (BlockPos)context.getPos(), (Vec3i)beginDiff, (Vec3i)endDiff, predicate);
    }
}

